/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.internal.corext.util.JavaElementResourceMapping;
import org.eclipse.jdt.internal.ui.IResourceLocator;
import org.eclipse.jdt.internal.ui.JavaElementContainmentAdapter;
import org.eclipse.jdt.internal.ui.JavaElementProperties;
import org.eclipse.jdt.internal.ui.JavaTaskListAdapter;
import org.eclipse.jdt.internal.ui.JavaWorkbenchAdapter;
import org.eclipse.jdt.internal.ui.PersistableJavaElementFactory;
import org.eclipse.jdt.internal.ui.ResourceLocator;
import org.eclipse.jdt.internal.ui.compare.JavaElementHistoryPageSource;
import org.eclipse.jdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.jdt.internal.ui.search.JavaSearchPageScoreComputer;
import org.eclipse.jdt.internal.ui.search.SearchUtil;
import org.eclipse.search.ui.ISearchPageScoreComputer;
import org.eclipse.team.ui.history.IHistoryPageSource;
import org.eclipse.ui.IContainmentAdapter;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.IPersistableElement;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.FilePropertySource;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.ResourcePropertySource;
import org.eclipse.ui.views.tasklist.ITaskListResourceAdapter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter2 {
    private static Class<?>[] ADAPTER_LIST = new Class[]{IPropertySource.class, IResource.class, IWorkbenchAdapter.class, IResourceLocator.class, IPersistableElement.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, ITaskListResourceAdapter.class, IContainmentAdapter.class};
    private Object fSearchPageScoreComputer;
    private boolean fIsTeamUILoaded;
    private static IResourceLocator fgResourceLocator;
    private static JavaWorkbenchAdapter fgJavaWorkbenchAdapter;
    private static ITaskListResourceAdapter fgTaskListAdapter;
    private static JavaElementContainmentAdapter fgJavaElementContainmentAdapter;

    public Class<?>[] getAdapterList() {
        this.updateLazyLoadedAdapters();
        return ADAPTER_LIST;
    }

    public <T> T getAdapter(Object element, Class<T> key) {
        this.updateLazyLoadedAdapters();
        IJavaElement java = this.getJavaElement(element);
        if (IPropertySource.class.equals(key)) {
            return (T)this.getProperties(java);
        }
        if (IResource.class.equals(key)) {
            return (T)this.getResource(java);
        }
        if (this.fSearchPageScoreComputer != null && ISearchPageScoreComputer.class.equals(key)) {
            return (T)this.fSearchPageScoreComputer;
        }
        if (IWorkbenchAdapter.class.equals(key)) {
            return (T)JavaElementAdapterFactory.getJavaWorkbenchAdapter();
        }
        if (IResourceLocator.class.equals(key)) {
            return (T)JavaElementAdapterFactory.getResourceLocator();
        }
        if (IPersistableElement.class.equals(key)) {
            return (T)new PersistableJavaElementFactory(java);
        }
        if (IContributorResourceAdapter.class.equals(key)) {
            return (T)this;
        }
        if (IContributorResourceAdapter2.class.equals(key)) {
            return (T)this;
        }
        if (ITaskListResourceAdapter.class.equals(key)) {
            return (T)JavaElementAdapterFactory.getTaskListAdapter();
        }
        if (IContainmentAdapter.class.equals(key)) {
            return (T)JavaElementAdapterFactory.getJavaElementContainmentAdapter();
        }
        if (this.fIsTeamUILoaded && IHistoryPageSource.class.equals(key) && JavaElementHistoryPageSource.hasEdition(java)) {
            return (T)((Object)JavaElementHistoryPageSource.getInstance());
        }
        return null;
    }

    private IResource getResource(IJavaElement element) {
        switch (element.getElementType()) {
            case 7: {
                IJavaElement parent = element.getParent();
                if (parent instanceof ICompilationUnit) {
                    return ((ICompilationUnit)parent).getPrimary().getResource();
                }
                return null;
            }
            case 5: {
                return ((ICompilationUnit)element).getPrimary().getResource();
            }
            case 4: 
            case 6: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                if (!root.isArchive() && !root.isExternal()) {
                    return element.getResource();
                }
                return null;
            }
            case 1: 
            case 2: 
            case 3: {
                return element.getResource();
            }
        }
        return null;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        IJavaElement je = this.getJavaElement(adaptable);
        if (je != null) {
            return this.getResource(je);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        IJavaElement je = this.getJavaElement(adaptable);
        if (je != null) {
            return JavaElementResourceMapping.create(je);
        }
        return null;
    }

    private IJavaElement getJavaElement(Object element) {
        if (element instanceof IJavaElement) {
            return (IJavaElement)element;
        }
        if (element instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)element).getClassFile().getPrimaryElement();
        }
        return null;
    }

    private IPropertySource getProperties(IJavaElement element) {
        IResource resource = this.getResource(element);
        if (resource == null) {
            return new JavaElementProperties(element);
        }
        if (resource.getType() == 1) {
            return new FilePropertySource((IFile)resource);
        }
        return new ResourcePropertySource(resource);
    }

    private void updateLazyLoadedAdapters() {
        if (this.fSearchPageScoreComputer == null && SearchUtil.isSearchPlugInActivated()) {
            this.createSearchPageScoreComputer();
        }
        if (!this.fIsTeamUILoaded && JavaElementAdapterFactory.isTeamUIPlugInActivated()) {
            JavaElementAdapterFactory.addClassToAdapterList(IHistoryPageSource.class);
            this.fIsTeamUILoaded = true;
        }
    }

    private void createSearchPageScoreComputer() {
        this.fSearchPageScoreComputer = new JavaSearchPageScoreComputer();
        JavaElementAdapterFactory.addClassToAdapterList(ISearchPageScoreComputer.class);
    }

    private static void addClassToAdapterList(Class<?> clazz) {
        int oldSize = ADAPTER_LIST.length;
        Class<?>[] oldProperties = ADAPTER_LIST;
        ADAPTER_LIST = new Class[oldSize + 1];
        System.arraycopy(oldProperties, 0, ADAPTER_LIST, 0, oldSize);
        JavaElementAdapterFactory.ADAPTER_LIST[oldSize] = clazz;
    }

    private static boolean isTeamUIPlugInActivated() {
        return Platform.getBundle((String)"org.eclipse.team.ui").getState() == 32;
    }

    private static IResourceLocator getResourceLocator() {
        if (fgResourceLocator == null) {
            fgResourceLocator = new ResourceLocator();
        }
        return fgResourceLocator;
    }

    private static JavaWorkbenchAdapter getJavaWorkbenchAdapter() {
        if (fgJavaWorkbenchAdapter == null) {
            fgJavaWorkbenchAdapter = new JavaWorkbenchAdapter();
        }
        return fgJavaWorkbenchAdapter;
    }

    private static ITaskListResourceAdapter getTaskListAdapter() {
        if (fgTaskListAdapter == null) {
            fgTaskListAdapter = new JavaTaskListAdapter();
        }
        return fgTaskListAdapter;
    }

    private static JavaElementContainmentAdapter getJavaElementContainmentAdapter() {
        if (fgJavaElementContainmentAdapter == null) {
            fgJavaElementContainmentAdapter = new JavaElementContainmentAdapter();
        }
        return fgJavaElementContainmentAdapter;
    }
}

