/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jface.text.ITextSelection;

public class RefactoringActions {
    public static IType getEnclosingOrPrimaryType(JavaTextSelection selection) throws JavaModelException {
        IJavaElement element = selection.resolveEnclosingElement();
        if (element != null) {
            return RefactoringActions.convertToEnclosingOrPrimaryType(element);
        }
        return null;
    }

    public static IType getEnclosingOrPrimaryType(JavaEditor editor) throws JavaModelException {
        return RefactoringActions.convertToEnclosingOrPrimaryType(SelectionConverter.resolveEnclosingElement(editor, (ITextSelection)editor.getSelectionProvider().getSelection()));
    }

    private static IType convertToEnclosingOrPrimaryType(IJavaElement element) throws JavaModelException {
        if (element instanceof IType) {
            return (IType)element;
        }
        IType result = (IType)element.getAncestor(7);
        if (result != null) {
            return result;
        }
        if (element instanceof ICompilationUnit) {
            return ((ICompilationUnit)element).findPrimaryType();
        }
        if (element instanceof IClassFile) {
            return ((IClassFile)element).getType();
        }
        return null;
    }

    public static IType getEnclosingType(JavaTextSelection selection) throws JavaModelException {
        return RefactoringActions.convertToEnclosingType(selection.resolveEnclosingElement());
    }

    public static IType getEnclosingType(JavaEditor editor) throws JavaModelException {
        return RefactoringActions.convertToEnclosingType(SelectionConverter.resolveEnclosingElement(editor, (ITextSelection)editor.getSelectionProvider().getSelection()));
    }

    private static IType convertToEnclosingType(IJavaElement element) {
        if (element == null) {
            return null;
        }
        if (!(element instanceof IType)) {
            element = element.getAncestor(7);
        }
        return (IType)element;
    }
}

