/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.viewsupport.BasicElementLabels;
import org.eclipse.jdt.ui.JavaElementLabels;
import org.eclipse.jface.dialogs.IDialogSettings;

public class AccessorDescription {
    private static final String KEY_ACCESSOR_NAME = "accessorName";
    private static final String KEY_ACCESSOR_PACK = "accessorPackage";
    private static final String KEY_RESOURCE_BUNDLE_NAME = "bundleName";
    private static final String KEY_RESOURCE_BUNDLE_PACK = "bundlePackage";
    private final IPackageFragment fResourceBundlePackage;
    private final String fAccessorClassName;
    private final IPackageFragment fAccessorClassPackage;
    private final String fResourceBundleName;

    public AccessorDescription(String accessorClassName, IPackageFragment accessorClassPackage, String propertyFileName, IPackageFragment propertyFilePackage) {
        this.fAccessorClassName = accessorClassName;
        this.fAccessorClassPackage = accessorClassPackage;
        this.fResourceBundleName = propertyFileName;
        this.fResourceBundlePackage = propertyFilePackage;
    }

    public String getLabel() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getAccessorClassPackage().getElementName());
        if (buf.length() > 0) {
            buf.append('.');
        }
        buf.append(BasicElementLabels.getResourceName(this.getAccessorClassName()));
        buf.append(JavaElementLabels.CONCAT_STRING);
        IPath propertyFilePath = this.getResourceBundlePackage().getPath().append(this.getResourceBundleName());
        buf.append(BasicElementLabels.getPathLabel(propertyFilePath, false));
        return buf.toString();
    }

    public void serialize(IDialogSettings settings) {
        settings.put(KEY_ACCESSOR_NAME, this.getAccessorClassName());
        settings.put(KEY_ACCESSOR_PACK, this.getAccessorClassPackage().getHandleIdentifier());
        settings.put(KEY_RESOURCE_BUNDLE_NAME, this.getResourceBundleName());
        settings.put(KEY_RESOURCE_BUNDLE_PACK, this.getResourceBundlePackage().getHandleIdentifier());
    }

    public String getAccessorClassName() {
        return this.fAccessorClassName;
    }

    public IPackageFragment getAccessorClassPackage() {
        return this.fAccessorClassPackage;
    }

    public String getResourceBundleName() {
        return this.fResourceBundleName;
    }

    public IPackageFragment getResourceBundlePackage() {
        return this.fResourceBundlePackage;
    }

    public boolean equals(Object obj) {
        if (obj != null && obj.getClass().equals(this.getClass())) {
            AccessorDescription other = (AccessorDescription)obj;
            return other == this || other.fAccessorClassName.equals(this.fAccessorClassName) && other.fAccessorClassPackage.equals(this.fAccessorClassPackage) && other.fResourceBundleName.equals(this.fResourceBundleName) && other.fResourceBundlePackage.equals(this.fResourceBundlePackage);
        }
        return false;
    }

    public int hashCode() {
        return this.fAccessorClassName.hashCode() + this.fAccessorClassPackage.hashCode() + this.fResourceBundleName.hashCode() + this.fResourceBundlePackage.hashCode();
    }

    public static AccessorDescription deserialize(IDialogSettings settings) {
        String accessorName = settings.get(KEY_ACCESSOR_NAME);
        if (accessorName == null) {
            return null;
        }
        String accessorPackHandle = settings.get(KEY_ACCESSOR_PACK);
        if (accessorPackHandle == null) {
            return null;
        }
        IJavaElement accessorPack = JavaCore.create((String)accessorPackHandle);
        if (!(accessorPack instanceof IPackageFragment) || !accessorPack.exists()) {
            return null;
        }
        String bundleName = settings.get(KEY_RESOURCE_BUNDLE_NAME);
        if (bundleName == null) {
            return null;
        }
        String bundlePackHandle = settings.get(KEY_RESOURCE_BUNDLE_PACK);
        if (bundlePackHandle == null) {
            return null;
        }
        IJavaElement bundlePack = JavaCore.create((String)bundlePackHandle);
        if (!(bundlePack instanceof IPackageFragment) || !bundlePack.exists()) {
            return null;
        }
        return new AccessorDescription(accessorName, (IPackageFragment)accessorPack, bundleName, (IPackageFragment)bundlePack);
    }
}

