/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.schema;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.pde.internal.core.ischema.ISchemaCompositor;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.ischema.ISchemaObject;
import org.eclipse.pde.internal.core.ischema.ISchemaType;
import org.eclipse.pde.internal.core.schema.SchemaComplexType;
import org.eclipse.pde.internal.core.schema.SchemaCompositor;
import org.eclipse.pde.internal.core.schema.SchemaElement;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class NewCompositorAction
extends Action {
    private ISchemaElement source;
    private Object object;
    private int kind;

    public NewCompositorAction(ISchemaElement source, Object object, int kind) {
        this.source = source;
        this.object = object;
        this.kind = kind;
        String text = this.upperCaseFirstLetter(ISchemaCompositor.kindTable[kind]);
        this.setText("&" + text);
        this.setToolTipText(NLS.bind((String)PDEUIMessages.SchemaEditor_NewCompositor_tooltip, (Object)text));
        ImageDescriptor desc = null;
        switch (kind) {
            case 2: {
                desc = PDEPluginImages.DESC_SEQ_SC_OBJ;
                break;
            }
            case 1: {
                desc = PDEPluginImages.DESC_CHOICE_SC_OBJ;
            }
        }
        this.setImageDescriptor(desc);
        this.setEnabled(source.getSchema().isEditable());
    }

    private String upperCaseFirstLetter(String text) {
        if (text == null || text.length() < 2) {
            return text;
        }
        String firstLetter = text.substring(0, 1).toUpperCase();
        String rest = text.substring(1);
        return String.valueOf(firstLetter) + rest;
    }

    public void run() {
        SchemaCompositor compositor = new SchemaCompositor((ISchemaObject)this.source, this.kind);
        if (this.object instanceof SchemaElement) {
            SchemaComplexType type = null;
            SchemaElement element = (SchemaElement)this.source;
            if (element.getType() instanceof SchemaComplexType) {
                type = (SchemaComplexType)element.getType();
                ISchemaCompositor oldComp = type.getCompositor();
                if (oldComp != null) {
                    ISchemaObject[] oldChildren = oldComp.getChildren();
                    int i = 0;
                    while (i < oldChildren.length) {
                        compositor.addChild(oldChildren[i]);
                        ++i;
                    }
                }
                type.setCompositor((ISchemaCompositor)compositor);
            } else {
                type = new SchemaComplexType(this.source.getSchema());
                type.setCompositor((ISchemaCompositor)compositor);
                ((SchemaElement)this.source).setType((ISchemaType)type);
            }
            if (element.hasTranslatableContent()) {
                element.setTranslatableProperty(false);
            }
        } else if (this.object instanceof SchemaCompositor) {
            ((SchemaCompositor)this.object).addChild((ISchemaObject)compositor);
        }
    }
}

