/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.core.op;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.egit.core.Activator;
import org.eclipse.egit.core.AdaptableFileTreeIterator;
import org.eclipse.egit.core.internal.CoreText;
import org.eclipse.egit.core.internal.job.RuleUtil;
import org.eclipse.egit.core.op.IEGitOperation;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.treewalk.WorkingTreeIterator;

public class AddToIndexOperation
implements IEGitOperation {
    private final Collection<? extends IResource> rsrcList;

    public AddToIndexOperation(Collection<? extends IResource> rsrcs) {
        this.rsrcList = rsrcs;
    }

    public AddToIndexOperation(IResource[] resources) {
        this.rsrcList = Arrays.asList(resources);
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    @Override
    public void execute(IProgressMonitor m) throws CoreException {
        monitor /* !! */  = m == null ? new NullProgressMonitor() : m;
        addCommands = new HashMap<RepositoryMapping, AddCommand>();
        try {
            try {
                for (IResource obj : this.rsrcList) {
                    this.addToCommand(obj, addCommands);
                    monitor /* !! */ .worked(200);
                }
                for (AddCommand command : addCommands.values()) {
                    command.call();
                }
            }
            catch (RuntimeException e) {
                throw new CoreException(Activator.error(CoreText.AddToIndexOperation_failed, e));
            }
            catch (GitAPIException e) {
                throw new CoreException(Activator.error(CoreText.AddToIndexOperation_failed, e));
            }
        }
        finally {
            ** for (rm : addCommands.keySet())
        }
lbl-1000:
        // 1 sources

        {
            rm.fireRepositoryChanged();
            continue;
        }
lbl22:
        // 1 sources

        monitor /* !! */ .done();
    }

    @Override
    public ISchedulingRule getSchedulingRule() {
        return RuleUtil.getRuleForRepositories(this.rsrcList.toArray(new IResource[this.rsrcList.size()]));
    }

    private void addToCommand(IResource resource, Map<RepositoryMapping, AddCommand> addCommands) {
        String filepattern;
        IProject project = resource.getProject();
        RepositoryMapping map = RepositoryMapping.getMapping(project);
        AddCommand command = addCommands.get(map);
        if (command == null) {
            Repository repo = map.getRepository();
            Git git = new Git(repo);
            AdaptableFileTreeIterator it = new AdaptableFileTreeIterator(repo, resource.getWorkspace().getRoot());
            command = git.add().setWorkingTreeIterator((WorkingTreeIterator)it);
            addCommands.put(map, command);
        }
        if ("".equals(filepattern = map.getRepoRelativePath(resource))) {
            filepattern = ".";
        }
        command.addFilepattern(filepattern);
    }
}

