/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.osgi.service.resolver.BaseDescription;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.BundleSpecification;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.ImportPackageSpecification;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;

public class DependencyCalculator {
    boolean fIncludeOptional;
    protected HashMap<String, IPluginModelBase> fDependencies;

    public DependencyCalculator(boolean includeOptional) {
        this.fIncludeOptional = includeOptional;
    }

    public void findDependencies(Object[] includedBundles) {
        if (this.fDependencies == null) {
            this.fDependencies = new HashMap();
        }
        int i = 0;
        while (i < includedBundles.length) {
            this.findObjectDependencies(includedBundles[i]);
            ++i;
        }
    }

    public void findDependency(Object bundle) {
        if (this.fDependencies == null) {
            this.fDependencies = new HashMap();
        }
        this.findObjectDependencies(bundle);
    }

    private void findObjectDependencies(Object obj) {
        IPluginModelBase base;
        BundleDescription desc;
        if (obj instanceof IPluginModelBase && (desc = (base = (IPluginModelBase)obj).getBundleDescription()) != null) {
            obj = desc;
        }
        if (obj instanceof BundleDescription) {
            this.findDependencies((BundleDescription)obj);
        }
    }

    public Set<String> getBundleIDs() {
        Set<String> temp = this.fDependencies.keySet();
        this.fDependencies = null;
        return temp;
    }

    protected void findDependencies(BundleDescription desc) {
        if (desc == null) {
            return;
        }
        String id = desc.getSymbolicName();
        if (this.fDependencies.containsKey(id)) {
            return;
        }
        IPluginModelBase model = PluginRegistry.findModel((BundleDescription)desc);
        if (model == null) {
            return;
        }
        this.fDependencies.put(id, model);
        this.addRequiredBundles(desc.getRequiredBundles());
        this.addImportedPackages(desc.getImportPackages());
        HostSpecification host = desc.getHost();
        if (host != null) {
            BaseDescription bd = host.getSupplier();
            if (bd != null && bd instanceof BundleDescription) {
                this.findDependencies((BundleDescription)bd);
            }
        } else {
            this.addFragments(desc);
        }
    }

    protected void addRequiredBundles(BundleSpecification[] requiredBundles) {
        int i = 0;
        while (i < requiredBundles.length) {
            BaseDescription bd;
            if ((!requiredBundles[i].isOptional() || this.fIncludeOptional) && (bd = requiredBundles[i].getSupplier()) != null && bd instanceof BundleDescription) {
                this.findDependencies((BundleDescription)bd);
            }
            ++i;
        }
    }

    protected void addImportedPackages(ImportPackageSpecification[] packages) {
        int i = 0;
        while (i < packages.length) {
            BundleDescription exporter;
            BaseDescription bd;
            if ((this.fIncludeOptional || !"optional".equals(packages[i].getDirective("resolution"))) && (bd = packages[i].getSupplier()) != null && bd instanceof ExportPackageDescription && (exporter = ((ExportPackageDescription)bd).getExporter()) != null) {
                this.findDependencies(exporter);
            }
            ++i;
        }
    }

    protected void addFragments(BundleDescription desc) {
        BundleDescription[] fragments = desc.getFragments();
        int i = 0;
        while (i < fragments.length) {
            if (fragments[i].isResolved() && !fragments[i].getSymbolicName().equals("org.eclipse.ui.workbench.compatibility")) {
                this.findDependencies(fragments[i]);
            }
            ++i;
        }
    }

    public boolean containsPluginId(String id) {
        return this.fDependencies.containsKey(id);
    }
}

