/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.builder;

import java.util.HashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.api.tools.internal.builder.AbstractIllegalTypeReference;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.internal.provisional.Factory;
import org.eclipse.pde.api.tools.internal.provisional.IApiAnnotations;
import org.eclipse.pde.api.tools.internal.provisional.RestrictionModifiers;
import org.eclipse.pde.api.tools.internal.provisional.builder.IReference;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiComponent;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiMember;
import org.eclipse.pde.api.tools.internal.provisional.model.IApiType;

public class IllegalImplementsProblemDetector
extends AbstractIllegalTypeReference {
    private HashMap<String, IApiType> fRestrictedInterfaces = new HashMap();

    @Override
    public int getReferenceKinds() {
        return 2;
    }

    @Override
    protected int getProblemKind() {
        return 4;
    }

    @Override
    protected String getSeverityKey() {
        return "ILLEGAL_IMPLEMENT";
    }

    @Override
    public boolean considerReference(IReference reference) {
        block7: {
            block6: {
                if (!super.considerReference(reference)) break block6;
                return true;
            }
            try {
                IApiType type = (IApiType)reference.getMember();
                IApiType[] inters = type.getSuperInterfaces();
                IApiType inter = null;
                int j = 0;
                while (j < inters.length) {
                    if (inters[j].getName().equals(reference.getReferencedTypeName())) {
                        inter = inters[j];
                        break;
                    }
                    ++j;
                }
                if (inter != null && this.findRestrictedSuperinterfaces(type.getApiComponent(), reference.getReferencedTypeName(), inter)) {
                    this.retainReference(reference);
                    return true;
                }
            }
            catch (CoreException ce) {
                if (!ApiPlugin.DEBUG_PROBLEM_DETECTOR) break block7;
                ApiPlugin.log(ce);
            }
        }
        return false;
    }

    @Override
    protected boolean isProblem(IReference reference) {
        try {
            IApiMember member;
            if (this.isIllegalType(reference)) {
                return super.isProblem(reference);
            }
            if (this.fRestrictedInterfaces.size() > 0 && (member = reference.getMember()).getType() == 2) {
                IApiType itype = this.fRestrictedInterfaces.get(reference.getReferencedTypeName());
                return itype != null && !this.isImplemented(((IApiType)member).getSuperclass(), itype.getName());
            }
            return true;
        }
        catch (CoreException ce) {
            if (ApiPlugin.DEBUG_PROBLEM_DETECTOR) {
                ApiPlugin.log(ce);
            }
            return super.isProblem(reference);
        }
    }

    @Override
    protected String[] getMessageArgs(IReference reference) throws CoreException {
        IApiType type;
        IApiType inter;
        String[] args = super.getMessageArgs(reference);
        if (!this.isIllegalType(reference) && this.fRestrictedInterfaces.size() > 0 && (inter = this.fRestrictedInterfaces.get((type = (IApiType)reference.getResolvedReference()).getName())) != null) {
            String[] newargs = new String[args.length + 1];
            System.arraycopy(args, 0, newargs, 0, args.length);
            newargs[args.length] = this.getSimpleTypeName(inter);
            return newargs;
        }
        return args;
    }

    @Override
    protected String[] getQualifiedMessageArgs(IReference reference) throws CoreException {
        IApiType type;
        IApiType inter;
        String[] args = super.getQualifiedMessageArgs(reference);
        if (!this.isIllegalType(reference) && this.fRestrictedInterfaces.size() > 0 && (inter = this.fRestrictedInterfaces.get((type = (IApiType)reference.getResolvedReference()).getName())) != null) {
            String[] newargs = new String[args.length + 1];
            System.arraycopy(args, 0, newargs, 0, args.length);
            newargs[args.length] = inter.getName();
            return newargs;
        }
        return args;
    }

    @Override
    protected int getProblemFlags(IReference reference) {
        if (this.isIllegalType(reference)) {
            return super.getProblemFlags(reference);
        }
        IApiType type = (IApiType)reference.getMember();
        if (type.isLocal()) {
            return 13;
        }
        return 12;
    }

    private boolean isImplemented(IApiType type, String iname) throws CoreException {
        if (type == null) {
            return false;
        }
        if (this.isImplemented(iname, type.getSuperInterfaces())) {
            return true;
        }
        return this.isImplemented(type.getSuperclass(), iname);
    }

    private boolean isImplemented(String iname, IApiType[] interfaces) throws CoreException {
        if (interfaces.length == 0) {
            return false;
        }
        int i = 0;
        while (i < interfaces.length) {
            if (interfaces[i].getName().equals(iname)) {
                return true;
            }
            if (this.isImplemented(iname, interfaces[i].getSuperInterfaces())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean findRestrictedSuperinterfaces(IApiComponent originalcomponent, String entryinterface, IApiType type) throws CoreException {
        IApiType[] inters = type.getSuperInterfaces();
        if (inters.length == 0) {
            return false;
        }
        IApiAnnotations annot = null;
        IApiComponent comp = null;
        int i = 0;
        while (i < inters.length) {
            comp = inters[i].getApiComponent();
            if (comp != null) {
                if (!comp.equals(originalcomponent) && (annot = comp.getApiDescription().resolveAnnotations(Factory.typeDescriptor(inters[i].getName()))) != null && RestrictionModifiers.isImplementRestriction(annot.getRestrictions())) {
                    this.fRestrictedInterfaces.put(entryinterface, inters[i]);
                    return true;
                }
                return this.findRestrictedSuperinterfaces(originalcomponent, entryinterface, inters[i]);
            }
            ++i;
        }
        return false;
    }
}

