/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.propertiesfileeditor;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jface.text.AbstractReusableInformationControlCreator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPartitioningException;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentExtension3;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlCreator;
import org.eclipse.jface.text.IInformationControlExtension2;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextHover;
import org.eclipse.jface.text.ITextHoverExtension;
import org.eclipse.jface.text.ITextHoverExtension2;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.editors.text.EditorsUI;

public class PropertiesFileHover
implements ITextHover,
ITextHoverExtension,
ITextHoverExtension2 {
    private int fOffset;
    private final ITextHover fTextHover;
    private HoverControlCreator fHoverControlCreator;

    public PropertiesFileHover(ITextHover textHover) {
        this.fTextHover = textHover;
    }

    public Object getHoverInfo2(ITextViewer textViewer, IRegion hoverRegion) {
        return this.getHoverInfo(textViewer, hoverRegion);
    }

    public IInformationControlCreator getHoverControlCreator() {
        if (this.fHoverControlCreator == null) {
            this.fHoverControlCreator = new HoverControlCreator();
        }
        return this.fHoverControlCreator;
    }

    public String getHoverInfo(ITextViewer textViewer, IRegion hoverRegion) {
        String type;
        IDocument document;
        ITypedRegion partition;
        String unescapedString;
        block12: {
            block11: {
                String hoverInfo = this.fTextHover.getHoverInfo(textViewer, hoverRegion);
                if (hoverInfo != null && hoverInfo.length() > 0) {
                    return hoverInfo;
                }
                unescapedString = null;
                partition = null;
                document = textViewer.getDocument();
                if (document instanceof IDocumentExtension3) {
                    partition = ((IDocumentExtension3)document).getPartition("___pf_partitioning", this.fOffset, false);
                }
                if (partition != null) break block11;
                return null;
            }
            type = partition.getType();
            if (type.equals("__pf_roperty_value") || type.equals("__dftl_partition_content_type")) break block12;
            return null;
        }
        try {
            String escapedString = document.get(partition.getOffset(), partition.getLength());
            if (type.equals("__pf_roperty_value")) {
                escapedString = escapedString.substring(1);
            }
            try {
                unescapedString = PropertiesFileEscapes.unescape(escapedString);
            }
            catch (CoreException e) {
                return e.getStatus().getMessage();
            }
            if (escapedString.equals(unescapedString)) {
                return null;
            }
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
        catch (BadPartitioningException e) {
            JavaPlugin.log(e);
        }
        return unescapedString;
    }

    public IRegion getHoverRegion(ITextViewer textViewer, int offset) {
        this.fOffset = offset;
        return this.fTextHover.getHoverRegion(textViewer, offset);
    }

    private static final class HoverControlCreator
    extends AbstractReusableInformationControlCreator {
        private HoverControlCreator() {
        }

        public IInformationControl doCreateInformationControl(Shell parent) {
            return new PropertiesFileHoverControl(parent, EditorsUI.getTooltipAffordanceString());
        }
    }

    static class PropertiesFileHoverControl
    extends DefaultInformationControl
    implements IInformationControlExtension2 {
        public PropertiesFileHoverControl(Shell parent, String tooltipAffordanceString) {
            super(parent, tooltipAffordanceString, null);
        }

        public void setInput(Object input) {
            this.setInformation((String)input);
        }
    }
}

