/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.core.protocol;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.rcptt.tesla.core.protocol.ActivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.ApplyCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.BooleanResponse;
import org.eclipse.rcptt.tesla.core.protocol.CancelCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.CellClick;
import org.eclipse.rcptt.tesla.core.protocol.CheckItem;
import org.eclipse.rcptt.tesla.core.protocol.ControlUIElement;
import org.eclipse.rcptt.tesla.core.protocol.CountItems;
import org.eclipse.rcptt.tesla.core.protocol.DeactivateCellEditor;
import org.eclipse.rcptt.tesla.core.protocol.ElementKind;
import org.eclipse.rcptt.tesla.core.protocol.GetSelection;
import org.eclipse.rcptt.tesla.core.protocol.IUIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.IntResponse;
import org.eclipse.rcptt.tesla.core.protocol.ItemUIElement;
import org.eclipse.rcptt.tesla.core.protocol.SelectionItem;
import org.eclipse.rcptt.tesla.core.protocol.SelectionResponse;
import org.eclipse.rcptt.tesla.core.protocol.UIPlayer;
import org.eclipse.rcptt.tesla.core.protocol.UISelector;
import org.eclipse.rcptt.tesla.core.protocol.UISetSelector;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;

public class ViewerUIElement
extends ControlUIElement {
    Selector selector = new Selector();

    public ViewerUIElement(Element e, UIPlayer player) {
        super(e, player);
        this.selector.set_item = new UISetSelector(player).parent(this.element);
        this.selector.item = new UISelector<ItemUIElement>(ElementKind.Item, (IUIPlayer)player, ItemUIElement.class).parent(this.getElement());
        this.selector.column = new UISelector<ControlUIElement>(ElementKind.ColumnHeader, (IUIPlayer)player, ControlUIElement.class).parent(this.getElement());
    }

    @Override
    protected void updateAfter(Element e) {
        super.updateAfter(e);
        this.selector.item.after = e;
    }

    public ItemUIElement item(String ... pattern) {
        return this.selector.item.path(pattern).find();
    }

    public ItemUIElement item(Integer ... index) {
        return this.selector.item.indexes(index).find();
    }

    public ControlUIElement column(String pattern, Integer index) {
        return this.selector.column.find(pattern, (Integer)(index != null && index == 0 ? null : index));
    }

    public boolean setSelection(String ... selection) {
        return this.selector.set_item.path(selection).select();
    }

    public boolean setSelectionList(List<String> selection) {
        return this.selector.set_item.pathList(selection).select();
    }

    public boolean setMultiSelection(String[] ... selection) {
        UISetSelector e = this.selector.set_item;
        if (selection.length > 0) {
            e = e.path(selection[0]);
            int i = 1;
            while (i < selection.length) {
                e = e.additional(selection[i]);
                ++i;
            }
        }
        return e.select();
    }

    public boolean setMultiSelectionList(List<List<String>> selection, boolean all) {
        UISetSelector e = this.selector.set_item;
        if (!selection.isEmpty()) {
            e = e.pathList(selection.get(0));
            int i = 1;
            while (i < selection.size()) {
                e = e.additionalPathList(selection.get(i));
                ++i;
            }
        }
        return e.select(all);
    }

    public boolean selectItem(String ... path) {
        return this.selector.set_item.path(path).select();
    }

    public boolean checkItem(String ... path) {
        return this.checkItem(true, path);
    }

    public boolean checkItem(boolean state, String ... path) {
        return this.checkItemList(state, Arrays.asList(path));
    }

    public boolean checkItemList(boolean state, List<String> path) {
        CheckItem cmd = this.factory.createCheckItem();
        if (path != null) {
            cmd.getPath().addAll(path);
        }
        cmd.setState(state);
        cmd.setElement(this.getElement());
        BooleanResponse res = (BooleanResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (res == null) {
            return true;
        }
        return res.isResult();
    }

    public int countItems() {
        CountItems cmd = this.factory.createCountItems();
        cmd.setElement(this.getElement());
        IntResponse response = (IntResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return 0;
        }
        return response.getResult();
    }

    public String[][] getSelection() {
        GetSelection cmd = this.factory.createGetSelection();
        cmd.setElement(this.getElement());
        SelectionResponse response = (SelectionResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        if (response == null) {
            return null;
        }
        EList<SelectionItem> values = response.getValues();
        ArrayList<String[]> result = new ArrayList<String[]>();
        for (SelectionItem item : values) {
            EList<String> text = item.getText();
            result.add((String[])text.toArray((Object[])new String[text.size()]));
        }
        return (String[][])result.toArray((T[])new String[result.size()][]);
    }

    public int countItems(String ... path) {
        CountItems cmd = this.factory.createCountItems();
        if (path != null) {
            cmd.getPath().addAll(Arrays.asList(path));
        }
        cmd.setElement(this.getElement());
        IntResponse res = (IntResponse)this.player.safeExecuteCommand(cmd);
        this.player.clearFailures();
        return res.getResult();
    }

    public void activateCellEditor(int column) {
        ActivateCellEditor cmd = this.factory.createActivateCellEditor();
        cmd.setElement(this.getElement());
        cmd.setColumn(column);
        this.player.safeExecuteCommand(cmd);
    }

    public void applyCellEditor() {
        ApplyCellEditor cmd = this.factory.createApplyCellEditor();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void deactivateCellEditor() {
        DeactivateCellEditor cmd = this.factory.createDeactivateCellEditor();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void cancelCellEditor() {
        CancelCellEditor cmd = this.factory.createCancelCellEditor();
        cmd.setElement(this.getElement());
        this.player.safeExecuteCommand(cmd);
    }

    public void cellClick(int index) {
        CellClick click = this.factory.createCellClick();
        click.setColumn(index);
        click.setElement(this.getElement());
        this.player.safeExecuteCommand(click);
    }

    private static class Selector {
        public UISetSelector set_item;
        public UISelector<ItemUIElement> item;
        public UISelector<ControlUIElement> column;

        private Selector() {
        }
    }
}

