/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.TextFileChange;
import org.eclipse.ltk.core.refactoring.resource.DeleteResourceChange;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.osgi.service.resolver.ExportPackageDescription;
import org.eclipse.osgi.service.resolver.HostSpecification;
import org.eclipse.osgi.service.resolver.State;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IExtensions;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ICoreConstants;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PDEManager;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundleFragmentModel;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.project.PDEProject;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.core.text.IDocumentAttributeNode;
import org.eclipse.pde.internal.core.text.IDocumentElementNode;
import org.eclipse.pde.internal.core.text.IDocumentTextNode;
import org.eclipse.pde.internal.core.text.IModelTextChangeListener;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.ManifestHeader;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleHeader;
import org.eclipse.pde.internal.core.text.bundle.RequireBundleObject;
import org.eclipse.pde.internal.core.text.bundle.SingleManifestHeader;
import org.eclipse.pde.internal.core.text.plugin.FragmentModel;
import org.eclipse.pde.internal.core.text.plugin.PluginModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.core.util.ManifestUtils;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.util.ModelModification;
import org.eclipse.pde.internal.ui.util.PDEModelUtility;
import org.eclipse.pde.internal.ui.wizards.tools.IOrganizeManifestsSettings;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class OrganizeManifest
implements IOrganizeManifestsSettings {
    private static String F_NL_PREFIX = "$nl$";
    private static String[] F_ICON_EXTENSIONS = new String[]{"BMP", "ICO", "JPEG", "JPG", "GIF", "PNG", "TIFF"};

    public static void organizeRequireBundles(IBundle bundle, boolean removeImports) {
        if (!(bundle instanceof Bundle)) {
            return;
        }
        RequireBundleHeader header = (RequireBundleHeader)((Bundle)bundle).getManifestHeader("Require-Bundle");
        if (header != null) {
            RequireBundleObject[] bundles = header.getRequiredBundles();
            int i = 0;
            while (i < bundles.length) {
                String pluginId = bundles[i].getId();
                if (PluginRegistry.findModel((String)pluginId) == null) {
                    if (removeImports) {
                        header.removeBundle(bundles[i]);
                    } else {
                        bundles[i].setOptional(true);
                    }
                }
                ++i;
            }
        }
    }

    public static void organizeExportPackages(IBundle bundle, IProject project, boolean addMissing, boolean removeUnresolved) {
        ExportPackageObject[] currentPkgs;
        if (!addMissing && !removeUnresolved) {
            return;
        }
        if (!(bundle instanceof Bundle)) {
            return;
        }
        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
        if (header == null) {
            bundle.setHeader("Export-Package", "");
            header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
            currentPkgs = new ExportPackageObject[]{};
        } else {
            currentPkgs = header.getPackages();
        }
        IManifestHeader bundleClasspathheader = bundle.getManifestHeader("Bundle-ClassPath");
        IPackageFragmentRoot[] roots = ManifestUtils.findPackageFragmentRoots((IManifestHeader)bundleClasspathheader, (IProject)project);
        HashSet<String> packages = new HashSet<String>();
        int i = 0;
        while (i < roots.length) {
            try {
                if (ManifestUtils.isImmediateRoot((IPackageFragmentRoot)roots[i])) {
                    IJavaElement[] elements = roots[i].getChildren();
                    int j = 0;
                    while (j < elements.length) {
                        if (elements[j] instanceof IPackageFragment) {
                            IPackageFragment fragment = (IPackageFragment)elements[j];
                            String name = fragment.getElementName();
                            if (name.length() == 0) {
                                name = ".";
                            }
                            if (fragment.hasChildren() || fragment.getNonJavaResources().length > 0) {
                                if (addMissing && !header.hasPackage(name)) {
                                    header.addPackage((PackageObject)new ExportPackageObject((ManifestHeader)header, fragment, "version"));
                                } else {
                                    packages.add(name);
                                }
                            }
                        }
                        ++j;
                    }
                }
            }
            catch (JavaModelException javaModelException) {}
            ++i;
        }
        if (removeUnresolved) {
            i = 0;
            while (i < currentPkgs.length) {
                if (!packages.contains(currentPkgs[i].getName())) {
                    header.removePackage((PackageObject)currentPkgs[i]);
                }
                ++i;
            }
        }
    }

    public static void markPackagesInternal(IBundle bundle, String packageFilter) {
        if (packageFilter == null || bundle == null || !(bundle instanceof Bundle)) {
            return;
        }
        ExportPackageHeader header = (ExportPackageHeader)bundle.getManifestHeader("Export-Package");
        if (header == null) {
            return;
        }
        ExportPackageObject[] currentPkgs = header.getPackages();
        Pattern pat = PatternConstructor.createPattern((String)packageFilter, (boolean)false);
        int i = 0;
        while (i < currentPkgs.length) {
            String values = currentPkgs[i].getValueComponents()[0];
            if (!currentPkgs[i].isInternal() && currentPkgs[i].getFriends().length == 0 && pat.matcher(values).matches()) {
                currentPkgs[i].setInternal(true);
            }
            ++i;
        }
    }

    public static void organizeImportPackages(IBundle bundle, boolean removeImports) {
        if (!(bundle instanceof Bundle)) {
            return;
        }
        ImportPackageHeader header = (ImportPackageHeader)((Bundle)bundle).getManifestHeader("Import-Package");
        if (header == null) {
            return;
        }
        ImportPackageObject[] importedPackages = header.getPackages();
        Set<String> availablePackages = OrganizeManifest.getAvailableExportedPackages();
        int i = 0;
        while (i < importedPackages.length) {
            String pkgName = importedPackages[i].getName();
            if (!availablePackages.contains(pkgName)) {
                if (removeImports) {
                    header.removePackage((PackageObject)importedPackages[i]);
                } else {
                    importedPackages[i].setOptional(true);
                }
            }
            ++i;
        }
    }

    private static final Set<String> getAvailableExportedPackages() {
        State state = TargetPlatformHelper.getState();
        ExportPackageDescription[] packages = state.getExportedPackages();
        HashSet<String> set = new HashSet<String>();
        int i = 0;
        while (i < packages.length) {
            set.add(packages[i].getName());
            ++i;
        }
        return set;
    }

    public static void removeUnneededLazyStart(IBundle bundle) {
        if (!(bundle instanceof Bundle)) {
            return;
        }
        if (bundle.getHeader("Bundle-Activator") == null && bundle.getHeader("Service-Component") == null) {
            String[] remove = new String[]{"Eclipse-LazyStart", "Eclipse-AutoStart", "Bundle-ActivationPolicy"};
            int i = 0;
            while (i < remove.length) {
                IManifestHeader lazy = ((Bundle)bundle).getManifestHeader(remove[i]);
                if (lazy instanceof SingleManifestHeader) {
                    ((SingleManifestHeader)lazy).setMainComponent(null);
                }
                ++i;
            }
        }
    }

    public static Change deleteUselessPluginFile(IProject project, IPluginModelBase modelBase) {
        if (modelBase == null) {
            return null;
        }
        IExtensions ext = modelBase.getExtensions();
        if (ext.getExtensionPoints().length > 0 || ext.getExtensions().length > 0) {
            return null;
        }
        IFile pluginFile = modelBase instanceof IBundleFragmentModel ? PDEProject.getFragmentXml((IProject)project) : PDEProject.getPluginXml((IProject)project);
        return new DeleteResourceChange(pluginFile.getFullPath(), true);
    }

    public static TextFileChange[] removeUnusedKeys(final IProject project, final IBundle bundle, final IPluginModelBase modelBase) {
        IFile propertiesFile;
        String localization = bundle.getLocalization();
        if (localization == null) {
            localization = "plugin";
        }
        if (!(propertiesFile = project.getFile(String.valueOf(localization) + ".properties")).exists()) {
            return new TextFileChange[0];
        }
        return PDEModelUtility.changesForModelModication(new ModelModification(propertiesFile){

            @Override
            protected void modifyModel(IBaseModel model, IProgressMonitor monitor) throws CoreException {
                if (!(model instanceof IBuildModel)) {
                    return;
                }
                IBuild build = ((IBuildModel)model).getBuild();
                IBuildEntry[] entries = build.getBuildEntries();
                ArrayList<String> allKeys = new ArrayList<String>(entries.length);
                int i = 0;
                while (i < entries.length) {
                    if (!allKeys.contains(entries[i].getName())) {
                        allKeys.add(entries[i].getName());
                    }
                    ++i;
                }
                ArrayList usedkeys = new ArrayList();
                OrganizeManifest.findTranslatedStrings(project, modelBase, bundle, usedkeys);
                int i2 = 0;
                while (i2 < usedkeys.size()) {
                    allKeys.remove(usedkeys.get(i2));
                    ++i2;
                }
                if (allKeys.size() == 0) {
                    return;
                }
                i2 = 0;
                while (i2 < entries.length) {
                    String[] tokens = entries[i2].getTokens();
                    if (tokens != null && tokens.length != 0) {
                        String entry = tokens[0];
                        int k = 1;
                        while (k < tokens.length) {
                            entry = String.valueOf(entry) + ',' + tokens[k];
                            ++k;
                        }
                        if (entry.indexOf(37) != entry.lastIndexOf(37)) {
                            int j = 0;
                            while (j < allKeys.size()) {
                                String akey = String.valueOf('%') + (String)allKeys.get(j) + '%';
                                if (entry.indexOf(akey) != -1) {
                                    allKeys.remove(allKeys.get(j--));
                                }
                                if (allKeys.size() == 0) {
                                    return;
                                }
                                ++j;
                            }
                        }
                    }
                    ++i2;
                }
                i2 = 0;
                while (i2 < allKeys.size()) {
                    IBuildEntry entry = build.getEntry((String)allKeys.get(i2));
                    build.remove(entry);
                    ++i2;
                }
            }
        }, null);
    }

    private static void findTranslatedStrings(IProject project, IPluginModelBase pluginModel, IBundle bundle, ArrayList<String> list) {
        OrganizeManifest.findTranslatedXMLStrings(pluginModel, list);
        OrganizeManifest.findTranslatedMFStrings(bundle, list);
        IPluginModelBase model = PluginRegistry.findModel((IProject)project);
        BundleDescription bundleDesc = model.getBundleDescription();
        HostSpecification hostSpec = bundleDesc.getHost();
        if (hostSpec != null) {
            BundleDescription[] hosts = hostSpec.getHosts();
            int i = 0;
            while (i < hosts.length) {
                IPluginModelBase hostModel = PluginRegistry.findModel((BundleDescription)hosts[i]);
                if (hostModel != null) {
                    OrganizeManifest.findTranslatedXMLStrings(OrganizeManifest.getTextModel(hostModel, false), list);
                    OrganizeManifest.findTranslatedMFStrings(OrganizeManifest.getTextBundle(hostModel), list);
                }
                ++i;
            }
        } else {
            IFragmentModel[] fragmentModels = PDEManager.findFragmentsFor((IPluginModelBase)model);
            int i = 0;
            while (i < fragmentModels.length) {
                OrganizeManifest.findTranslatedXMLStrings(OrganizeManifest.getTextModel((IPluginModelBase)fragmentModels[i], true), list);
                OrganizeManifest.findTranslatedMFStrings(OrganizeManifest.getTextBundle((IPluginModelBase)fragmentModels[i]), list);
                ++i;
            }
        }
    }

    private static IPluginModelBase getTextModel(IPluginModelBase model, boolean fragment) {
        if (model instanceof PluginModel || model instanceof FragmentModel) {
            return model;
        }
        if (model != null) {
            if (!OrganizeManifest.fileExists(model.getInstallLocation(), fragment ? "fragment.xml" : "plugin.xml")) {
                return null;
            }
            Document doc = CoreUtility.getTextDocument((File)new File(model.getInstallLocation()), (String)(fragment ? "fragment.xml" : "plugin.xml"));
            Object returnModel = fragment ? new FragmentModel((IDocument)doc, false) : new PluginModel((IDocument)doc, false);
            try {
                returnModel.load();
            }
            catch (CoreException coreException) {}
            if (returnModel.isLoaded()) {
                return returnModel;
            }
        }
        return null;
    }

    private static IBundle getTextBundle(IPluginModelBase model) {
        if (model != null) {
            if (!OrganizeManifest.fileExists(model.getInstallLocation(), "META-INF/MANIFEST.MF")) {
                return null;
            }
            Document doc = CoreUtility.getTextDocument((File)new File(model.getInstallLocation()), (String)"META-INF/MANIFEST.MF");
            BundleModel bundleModel = new BundleModel((IDocument)doc, false);
            try {
                bundleModel.load();
            }
            catch (CoreException coreException) {}
            if (bundleModel.isLoaded()) {
                return bundleModel.getBundle();
            }
        }
        return null;
    }

    private static void findTranslatedXMLStrings(IPluginModelBase model, ArrayList<String> list) {
        if (model == null) {
            return;
        }
        IPluginExtensionPoint[] points = model.getPluginBase().getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            String value = OrganizeManifest.getTranslatedKey(points[i].getName());
            if (value != null && !list.contains(value)) {
                list.add(value);
            }
            ++i;
        }
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i2 = 0;
        while (i2 < extensions.length) {
            if (extensions[i2] instanceof IDocumentElementNode) {
                OrganizeManifest.inspectElementForTranslation((IDocumentElementNode)extensions[i2], list);
            }
            ++i2;
        }
    }

    private static void inspectElementForTranslation(IDocumentElementNode parent, ArrayList<String> list) {
        IDocumentTextNode text = parent.getTextNode();
        String textValue = OrganizeManifest.getTranslatedKey(text != null ? text.getText() : null);
        if (textValue != null && !list.contains(textValue)) {
            list.add(textValue);
        }
        IDocumentAttributeNode[] attributes = parent.getNodeAttributes();
        int j = 0;
        while (j < attributes.length) {
            String attrValue = OrganizeManifest.getTranslatedKey(attributes[j].getAttributeValue());
            if (attrValue != null && !list.contains(attrValue)) {
                list.add(attrValue);
            }
            ++j;
        }
        if (!(parent instanceof IPluginParent)) {
            return;
        }
        IPluginObject[] children = ((IPluginParent)parent).getChildren();
        int i = 0;
        while (i < children.length) {
            if (children[i] instanceof IDocumentElementNode) {
                OrganizeManifest.inspectElementForTranslation((IDocumentElementNode)children[i], list);
            }
            ++i;
        }
    }

    private static void findTranslatedMFStrings(IBundle bundle, ArrayList<String> list) {
        if (bundle == null) {
            return;
        }
        int i = 0;
        while (i < ICoreConstants.TRANSLATABLE_HEADERS.length) {
            String key = OrganizeManifest.getTranslatedKey(bundle.getHeader(ICoreConstants.TRANSLATABLE_HEADERS[i]));
            if (key != null && !list.contains(key)) {
                list.add(key);
            }
            ++i;
        }
    }

    private static String getTranslatedKey(String value) {
        if (value != null && value.length() > 1 && value.charAt(0) == '%' && value.charAt(1) != '%') {
            return value.substring(1);
        }
        return null;
    }

    private static boolean fileExists(String container, String filename) {
        return new File(String.valueOf(container) + filename).exists();
    }

    public static void prefixIconPaths(IPluginModelBase model) {
        if (model == null) {
            return;
        }
        SchemaRegistry registry = PDECore.getDefault().getSchemaRegistry();
        IPluginExtension[] extensions = model.getPluginBase().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            ISchema schema = registry.getSchema(extensions[i].getPoint());
            if (schema != null) {
                OrganizeManifest.inspectElementsIconPaths(schema, (IPluginParent)extensions[i]);
            }
            ++i;
        }
    }

    private static void inspectElementsIconPaths(ISchema schema, IPluginParent parent) {
        IPluginObject[] children = parent.getChildren();
        int i = 0;
        while (i < children.length) {
            IPluginElement child = (IPluginElement)children[i];
            ISchemaElement schemaElement = schema.findElement(child.getName());
            if (schemaElement != null) {
                IPluginAttribute[] attributes = child.getAttributes();
                int j = 0;
                while (j < attributes.length) {
                    int fileExtIndex;
                    String value;
                    ISchemaAttribute attInfo = schemaElement.getAttribute(attributes[j].getName());
                    if (attInfo != null && attInfo.getKind() == 2 && !(value = attributes[j].getValue()).startsWith(F_NL_PREFIX) && (fileExtIndex = value.lastIndexOf(46)) != -1) {
                        value = value.substring(fileExtIndex + 1);
                        int e = 0;
                        while (e < F_ICON_EXTENSIONS.length) {
                            if (value.equalsIgnoreCase(F_ICON_EXTENSIONS[e])) {
                                Path path = new Path(F_NL_PREFIX);
                                String newValue = attributes[j].getValue();
                                if (newValue.charAt(0) != '/') {
                                    path = path.addTrailingSeparator();
                                }
                                newValue = String.valueOf(path.toString()) + newValue;
                                try {
                                    child.setAttribute(attributes[j].getName(), newValue);
                                }
                                catch (CoreException coreException) {}
                                break;
                            }
                            ++e;
                        }
                    }
                    ++j;
                }
            }
            OrganizeManifest.inspectElementsIconPaths(schema, (IPluginParent)child);
            ++i;
        }
    }

    protected static MultiTextEdit getTextEdit(IModelTextChangeListener listener) {
        if (listener == null) {
            return null;
        }
        TextEdit[] edits = listener.getTextOperations();
        if (edits.length == 0) {
            return null;
        }
        MultiTextEdit multiEdit = new MultiTextEdit();
        multiEdit.addChildren(edits);
        return multiEdit;
    }
}

