/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ecl.core.util;

import org.eclipse.rcptt.ecl.core.util.ICommandFormatter;
import org.eclipse.rcptt.ecl.internal.core.CorePlugin;

public class DefaultFormatter
implements ICommandFormatter {
    private static final String LINE_SEP = "\n";
    private static final String SPACE = " ";
    private static final String PIPE = "|";
    private static final String OPEN_BRACE = "{";
    private static final String CLOSE_BRACE = "}";
    private static final String OPEN_BRACKET = "[";
    private static final String CLOSE_BRACKET = "]";
    private static final String ATTR_PREFIX = "-";
    private final StringBuffer buffer = new StringBuffer();
    private int level;
    private int lineNumber = 0;
    private int posInLine = 0;
    private int possibleLineBreak;
    private String lineBreak;
    private boolean firstSequenceCommand = true;
    private boolean firstPipeCommand = true;
    private boolean firstPipeCommandInGroup = true;
    private boolean firstPipeCommandInExec = true;
    private final boolean wrap;
    private int indentSize = 4;
    private int lineWidth = 80;

    public DefaultFormatter() {
        this(true);
    }

    public DefaultFormatter(boolean wrap) {
        this.wrap = wrap;
        this.lineWidth = CorePlugin.getECLEditorLineWidth();
        this.indentSize = CorePlugin.getECLEditorIndent();
        this.resetLineBreak();
    }

    public void setLineWidth(int width) {
        this.lineWidth = width;
    }

    public void setIndentSize(int size) {
        this.indentSize = size;
    }

    @Override
    public void newPipeCommand() {
        if (!(this.firstPipeCommand || this.firstPipeCommandInExec || this.firstPipeCommandInGroup)) {
            this.append(SPACE);
            this.possibleLineBreak();
            this.append(PIPE).append(SPACE);
        }
        this.firstPipeCommandInGroup = false;
        this.firstPipeCommandInExec = false;
        this.firstPipeCommand = false;
    }

    @Override
    public void newSequenceCommand() {
        if (!this.firstSequenceCommand) {
            this.newLine();
        }
        this.addIndent();
        this.firstSequenceCommand = false;
        this.firstPipeCommand = true;
    }

    @Override
    public void addCommandName(String name) {
        this.append(name);
    }

    @Override
    public void addAttrName(String name, boolean forced) {
        if (forced) {
            this.append(SPACE);
            this.possibleLineBreak();
            this.append(ATTR_PREFIX).append(name);
        }
    }

    @Override
    public void addAttrValue(String value) {
        this.append(SPACE);
        if (value.startsWith("\"") && value.length() > 3) {
            if (value.contains("\\n")) {
                String[] parts = value.split("\\\\n");
                this.append(parts[0]);
                int i = 1;
                while (i < parts.length) {
                    this.append("\\n");
                    if (parts[i].length() > 1) {
                        this.lineBreak(this.posInLine, "\"\n+ \"");
                    }
                    this.append(parts[i]);
                    ++i;
                }
            } else {
                this.append(value.substring(0, 2));
                int i = 2;
                while (i + 1 < value.length()) {
                    this.append(value.substring(i, i + 1));
                    ++i;
                }
                this.append("\"");
            }
        } else {
            this.append(value);
        }
    }

    @Override
    public void openGroup(boolean singleLine) {
        this.firstPipeCommandInGroup = true;
        this.append(SPACE).append(OPEN_BRACE);
        if (!singleLine) {
            ++this.level;
        }
    }

    @Override
    public void closeGroup(boolean singleLine) {
        this.firstPipeCommandInGroup = false;
        if (!singleLine) {
            --this.level;
            this.newLine();
            this.addIndent();
        }
        this.append(CLOSE_BRACE);
    }

    @Override
    public void openExec() {
        this.firstPipeCommandInExec = true;
        this.append(SPACE).append(OPEN_BRACKET);
    }

    @Override
    public void closeExec() {
        this.firstPipeCommandInExec = false;
        this.append(CLOSE_BRACKET);
    }

    @Override
    public String toString() {
        return this.buffer.toString();
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    private void addIndent() {
        int i = 0;
        while (i < this.level * this.indentSize) {
            this.append(SPACE);
            ++i;
        }
    }

    private DefaultFormatter append(String s) {
        this.buffer.append(s);
        this.posInLine += s.length();
        if (this.posInLine > this.lineWidth && this.possibleLineBreak > 0 && this.possibleLineBreak < this.posInLine) {
            this.lineBreak(this.possibleLineBreak, this.lineBreak);
        }
        return this;
    }

    private void lineBreak(int pos, String lineBreak) {
        if (this.wrap) {
            int index = lineBreak.indexOf(10);
            StringBuilder sb = new StringBuilder(lineBreak.substring(0, index + 1));
            int i = 0;
            while (i < (this.level + 1) * this.indentSize) {
                sb.append(SPACE);
                ++i;
            }
            sb.append(lineBreak.substring(index + 1, lineBreak.length()));
            this.buffer.insert(this.buffer.length() - this.posInLine + pos, sb.toString());
            ++this.lineNumber;
            this.posInLine -= pos + 1;
            this.posInLine += sb.length() - index;
            this.resetLineBreak();
        }
    }

    private void resetLineBreak() {
        this.possibleLineBreak = -1;
        this.lineBreak = LINE_SEP;
    }

    private void newLine() {
        this.buffer.append(LINE_SEP);
        ++this.lineNumber;
        this.posInLine = 0;
        this.resetLineBreak();
    }

    private void possibleLineBreak() {
        this.possibleLineBreak = this.posInLine;
        this.lineBreak = LINE_SEP;
    }
}

