/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.aut;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.rcptt.internal.launching.Q7LaunchingPlugin;
import org.eclipse.rcptt.internal.launching.aut.OutputCaptureLaunchListener;
import org.eclipse.rcptt.launching.Aut;
import org.eclipse.rcptt.launching.AutLaunch;
import org.eclipse.rcptt.launching.AutListener;

public class OutputCaptureListener
implements AutListener {
    @Override
    public void autAdded(Aut aut) {
    }

    @Override
    public void autRemoved(Aut aut) {
    }

    @Override
    public void autChanged(Aut aut) {
    }

    @Override
    public void launchAdded(AutLaunch launch) {
        File logFile = this.getLogFile(launch);
        if (logFile == null) {
            return;
        }
        OutputCaptureLaunchListener listener = new OutputCaptureLaunchListener(logFile);
        launch.addListener(listener);
        listener.stateChanged(launch, launch.getState());
    }

    @Override
    public void launchRemoved(AutLaunch launch) {
    }

    private File getLogFile(AutLaunch launch) {
        File result;
        block13: {
            String logFilePath;
            block12: {
                logFilePath = launch.getLaunch().getLaunchConfiguration().getAttribute("org.eclipse.rcptt.launching.outFile", null);
                if (logFilePath != null) break block12;
                return null;
            }
            result = new File(VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(logFilePath));
            File resultDir = result.getParentFile();
            String error = null;
            if (resultDir == null) {
                error = String.format("Output file location '%s' is not absolute", result.getAbsolutePath());
            } else if (resultDir.isFile()) {
                error = String.format("'%s' is not a directory", resultDir.getAbsolutePath());
            } else if (!resultDir.exists() && !resultDir.mkdirs()) {
                error = String.format("Directory '%s' does not exist and cannot be created", resultDir.getAbsolutePath());
            } else if (!result.exists() && !result.createNewFile() || !result.canWrite()) {
                error = String.format("Cannot write to '%s'", result.getAbsolutePath());
            }
            if (error == null) break block13;
            Q7LaunchingPlugin.log(String.format("Cannot create output file: %s", error));
            return null;
        }
        try {
            return result;
        }
        catch (CoreException e) {
            Q7LaunchingPlugin.log(e.getStatus());
        }
        catch (Exception e) {
            Q7LaunchingPlugin.log("Unexpected error while creating log file", e);
        }
        return null;
    }
}

