/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.query.algebra.evaluation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.eclipse.rdf4j.common.annotation.InternalUseOnly;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.util.Values;
import org.eclipse.rdf4j.query.AbstractBindingSet;
import org.eclipse.rdf4j.query.Binding;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MutableBindingSet;
import org.eclipse.rdf4j.query.impl.SimpleBinding;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InternalUseOnly
public class ArrayBindingSet
extends AbstractBindingSet
implements MutableBindingSet {
    private static final long serialVersionUID = -1L;
    private static final Logger logger = LoggerFactory.getLogger(ArrayBindingSet.class);
    private static final Value NULL_VALUE = Values.iri((String)"urn:null:d57c56f3-41a9-468e-8dce-5706ebdef84c_e88d9e52-27cb-4056-a889-1ea353fa6f0c");
    private final String[] bindingNames;
    private Set<String> bindingNamesSetCache;
    private boolean empty;
    private final Value[] values;
    private int cachedHashCode;
    List<String> sortedBindingNames = null;

    public ArrayBindingSet(String ... names) {
        this.bindingNames = names;
        this.values = new Value[names.length];
        this.empty = true;
    }

    public ArrayBindingSet(BindingSet toCopy, Set<String> names, String[] namesArray) {
        assert (!(toCopy instanceof ArrayBindingSet));
        this.bindingNames = namesArray;
        this.values = new Value[this.bindingNames.length];
        for (int i = 0; i < this.bindingNames.length; ++i) {
            Binding binding = toCopy.getBinding(this.bindingNames[i]);
            if (binding != null) {
                this.values[i] = binding.getValue();
                if (this.values[i] != null) continue;
                this.values[i] = NULL_VALUE;
                continue;
            }
            if (!this.hasBinding(this.bindingNames[i])) continue;
            this.values[i] = NULL_VALUE;
        }
        this.empty = toCopy.isEmpty();
        assert (!this.empty || this.size() == 0);
    }

    public ArrayBindingSet(ArrayBindingSet toCopy, String ... names) {
        this.bindingNames = names;
        this.values = Arrays.copyOf(toCopy.values, toCopy.values.length);
        this.empty = toCopy.empty;
        assert (!this.empty || this.size() == 0);
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectSetBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            logger.error("Variable not known to ArrayBindingSet : " + bindingName);
            assert (false) : "Variable not known to ArrayBindingSet : " + bindingName;
            return null;
        }
        return (v, a) -> {
            a.values[index] = v == null ? NULL_VALUE : v;
            a.empty = false;
            a.clearCache();
        };
    }

    public BiConsumer<Value, ArrayBindingSet> getDirectAddBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            logger.error("Variable not known to ArrayBindingSet : " + bindingName);
            assert (false) : "Variable not known to ArrayBindingSet : " + bindingName;
            return null;
        }
        return (v, a) -> {
            assert (a.values[index] == null);
            a.values[index] = v == null ? NULL_VALUE : v;
            a.empty = false;
            a.clearCache();
        };
    }

    public Function<ArrayBindingSet, Binding> getDirectGetBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> {
            Value value = a.values[index];
            if (value != null && value != NULL_VALUE) {
                return new SimpleBinding(bindingName, value);
            }
            return null;
        };
    }

    public Function<ArrayBindingSet, Value> getDirectGetValue(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> a.values[index] == NULL_VALUE ? null : a.values[index];
    }

    public Function<ArrayBindingSet, Boolean> getDirectHasBinding(String bindingName) {
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return null;
        }
        return a -> a.values[index] != null;
    }

    private int getIndex(String bindingName) {
        int i;
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName) continue;
            return i;
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName)) continue;
            return i;
        }
        return -1;
    }

    public Set<String> getBindingNames() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        if (this.bindingNamesSetCache == null) {
            int size = this.size();
            if (size == 0) {
                this.bindingNamesSetCache = Collections.emptySet();
            } else if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.bindingNamesSetCache = Collections.singleton(this.bindingNames[i]);
                    break;
                }
                assert (this.bindingNamesSetCache != null);
            } else {
                LinkedHashSet<String> bindingNamesSetCache = new LinkedHashSet<String>(size * 2);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (this.values[i] == null) continue;
                    bindingNamesSetCache.add(this.bindingNames[i]);
                }
                this.bindingNamesSetCache = Collections.unmodifiableSet(bindingNamesSetCache);
            }
        }
        return this.bindingNamesSetCache;
    }

    public Value getValue(String bindingName) {
        int i;
        if (this.isEmpty()) {
            return null;
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (this.bindingNames[i] != bindingName || this.values[i] == null) continue;
            return this.values[i] == NULL_VALUE ? null : this.values[i];
        }
        for (i = 0; i < this.bindingNames.length; ++i) {
            if (!this.bindingNames[i].equals(bindingName) || this.values[i] == null) continue;
            return this.values[i] == NULL_VALUE ? null : this.values[i];
        }
        return null;
    }

    public Binding getBinding(String bindingName) {
        if (this.isEmpty()) {
            return null;
        }
        Value value = this.getValue(bindingName);
        if (value == NULL_VALUE) {
            value = null;
        }
        if (value != null) {
            return new SimpleBinding(bindingName, value);
        }
        return null;
    }

    public boolean hasBinding(String bindingName) {
        if (this.isEmpty()) {
            return false;
        }
        int index = this.getIndex(bindingName);
        if (index == -1) {
            return false;
        }
        return this.values[index] != null;
    }

    public Iterator<Binding> iterator() {
        if (this.isEmpty()) {
            return Collections.emptyIterator();
        }
        return new ArrayBindingSetIterator();
    }

    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        int size = 0;
        for (Value value : this.values) {
            if (value == null) continue;
            ++size;
        }
        return size;
    }

    public boolean isCompatible(BindingSet other) {
        if (this.isEmpty() || other.isEmpty()) {
            return true;
        }
        if (other instanceof ArrayBindingSet) {
            ArrayBindingSet o = (ArrayBindingSet)other;
            if (this.bindingNames == o.bindingNames) {
                return this.fastIsCompatible(o);
            }
        }
        return this.slowIsCompatible(other);
    }

    private boolean fastIsCompatible(ArrayBindingSet o) {
        for (int i = 0; i < this.values.length; ++i) {
            Value v2;
            Value v1 = this.values[i];
            if (v1 == null || v1 == NULL_VALUE || (v2 = o.values[i]) == null || v2 == NULL_VALUE) continue;
            if (v1.getType() != v2.getType()) {
                return false;
            }
            if (v1.equals((Object)v2)) continue;
            return false;
        }
        return true;
    }

    private boolean slowIsCompatible(BindingSet other) {
        for (int i = 0; i < this.bindingNames.length; ++i) {
            Value v2;
            Value v1 = this.values[i];
            if (v1 == null || v1 == NULL_VALUE || (v2 = other.getValue(this.bindingNames[i])) == null) continue;
            if (v1.getType() != v2.getType()) {
                return false;
            }
            if (v1.equals((Object)v2)) continue;
            return false;
        }
        return true;
    }

    public List<String> getSortedBindingNames() {
        if (this.sortedBindingNames == null) {
            int size = this.size();
            if (size == 1) {
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (this.values[i] == null) continue;
                    this.sortedBindingNames = Collections.singletonList(this.bindingNames[i]);
                }
            } else {
                ArrayList<String> names = new ArrayList<String>(size);
                for (int i = 0; i < this.bindingNames.length; ++i) {
                    if (this.values[i] == null) continue;
                    names.add(this.bindingNames[i]);
                }
                names.sort(String::compareTo);
                this.sortedBindingNames = names;
            }
        }
        return this.sortedBindingNames;
    }

    public void addBinding(Binding binding) {
        int index = this.getIndex(binding.getName());
        Value value = binding.getValue();
        if (index == -1) {
            logger.error("We don't actually support adding a binding. " + binding.getName() + " : " + String.valueOf(value));
            assert (false) : "We don't actually support adding a binding. " + binding.getName() + " : " + String.valueOf(value);
            return;
        }
        assert (this.values[index] == null);
        this.values[index] = value == null ? NULL_VALUE : value;
        this.empty = false;
        this.clearCache();
    }

    public void setBinding(Binding binding) {
        int index = this.getIndex(binding.getName());
        if (index == -1) {
            return;
        }
        Value value = binding.getValue();
        this.values[index] = value == null ? NULL_VALUE : value;
        this.empty = false;
        this.clearCache();
    }

    public void setBinding(String name, Value value) {
        int index = this.getIndex(name);
        if (index == -1) {
            return;
        }
        this.values[index] = value;
        if (value == null) {
            this.empty = true;
            for (Value value1 : this.values) {
                if (value1 == null) continue;
                this.empty = false;
                break;
            }
        } else {
            this.empty = false;
        }
        this.clearCache();
    }

    public boolean isEmpty() {
        return this.empty;
    }

    private void clearCache() {
        this.bindingNamesSetCache = null;
        this.cachedHashCode = 0;
    }

    public void addAll(ArrayBindingSet other) {
        if (other.bindingNames == this.bindingNames) {
            for (int i = 0; i < this.bindingNames.length; ++i) {
                if (other.values[i] == null) continue;
                this.values[i] = other.values[i];
                this.empty = false;
            }
        } else {
            for (int i = 0; i < this.bindingNames.length; ++i) {
                if (!other.hasBinding(this.bindingNames[i])) continue;
                Value value = other.getValue(this.bindingNames[i]);
                this.values[i] = value == null ? NULL_VALUE : value;
                this.empty = false;
            }
        }
        this.clearCache();
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = super.hashCode();
        }
        return this.cachedHashCode;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (other == this) {
            return true;
        }
        if (other.getClass() != ArrayBindingSet.class) {
            return super.equals(other);
        }
        ArrayBindingSet o = (ArrayBindingSet)((Object)other);
        if (this.empty && o.empty) {
            return true;
        }
        if (this.empty != o.empty) {
            return false;
        }
        if (this.size() != o.size()) {
            return false;
        }
        if (this.bindingNames == o.bindingNames) {
            for (int i = 0; i < this.values.length; ++i) {
                if (this.values[i] == o.values[i] || Objects.equals(this.values[i], o.values[i])) continue;
                return false;
            }
            return true;
        }
        return super.equals(other);
    }

    private class ArrayBindingSetIterator
    implements Iterator<Binding> {
        private int index = 0;

        @Override
        public boolean hasNext() {
            while (this.index < ArrayBindingSet.this.values.length) {
                if (ArrayBindingSet.this.values[this.index] != null && ArrayBindingSet.this.values[this.index] != NULL_VALUE) {
                    return true;
                }
                ++this.index;
            }
            return false;
        }

        @Override
        public Binding next() {
            if (this.hasNext()) {
                String name = ArrayBindingSet.this.bindingNames[this.index];
                Value value = ArrayBindingSet.this.values[this.index++];
                return new SimpleBinding(name, value);
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

