/*
 * Decompiled with CFR 0.152.
 */
package no.hasmac.jsonld.deseralization;

import jakarta.json.JsonArray;
import jakarta.json.JsonValue;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.IntStream;
import no.hasmac.jsonld.JsonLdError;
import no.hasmac.jsonld.JsonLdOptions;
import no.hasmac.jsonld.deseralization.ObjectToRdf;
import no.hasmac.jsonld.flattening.NodeMap;
import no.hasmac.jsonld.json.JsonUtils;
import no.hasmac.rdf.RdfValueFactory;

final class ListToRdf<Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> {
    private final RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory;
    private final JsonArray list;
    private final List<Triple> triples;
    private final NodeMap nodeMap;
    private final JsonLdOptions options;
    private JsonLdOptions.RdfDirection rdfDirection;
    private boolean uriValidation;

    private ListToRdf(JsonArray list, List<Triple> triples, NodeMap nodeMap, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory, JsonLdOptions options) {
        this.list = list;
        this.triples = triples;
        this.nodeMap = nodeMap;
        this.rdfValueFactory = rdfValueFactory;
        this.rdfDirection = null;
        this.uriValidation = true;
        this.options = options;
    }

    public static <Triple, Quad, Iri extends Resource, Bnode extends Resource, Resource extends Value, Literal extends Value, Value> ListToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> with(JsonArray list, List<Triple> triples, NodeMap nodeMap, RdfValueFactory<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfValueFactory, JsonLdOptions options) {
        return new ListToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value>(list, triples, nodeMap, rdfValueFactory, options);
    }

    public ListToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> rdfDirection(JsonLdOptions.RdfDirection rdfDirection) {
        this.rdfDirection = rdfDirection;
        return this;
    }

    public Value build() throws JsonLdError {
        if (JsonUtils.isEmptyArray((JsonValue)this.list)) {
            return (Value)this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
        }
        String[] bnodes = new String[this.list.size()];
        IntStream.range(0, bnodes.length).forEach(i -> {
            bnodes[i] = this.nodeMap.createIdentifier();
        });
        int index = 0;
        for (JsonValue item : this.list) {
            String subject = bnodes[index];
            ++index;
            ArrayList embeddedTriples = new ArrayList();
            Value rdfValue = ObjectToRdf.with(item.asJsonObject(), embeddedTriples, this.nodeMap, this.rdfValueFactory, this.options).rdfDirection(this.rdfDirection).uriValidation(this.uriValidation).build();
            if (rdfValue != null) {
                this.triples.add(this.rdfValueFactory.createTriple(this.rdfValueFactory.createBlankNode(subject), this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#first"), rdfValue));
            }
            Iri rest = index < bnodes.length ? this.rdfValueFactory.createBlankNode(bnodes[index]) : this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            this.triples.add(this.rdfValueFactory.createTriple(this.rdfValueFactory.createBlankNode(subject), this.rdfValueFactory.createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#rest"), rest));
            this.triples.addAll(embeddedTriples);
        }
        return (Value)this.rdfValueFactory.createBlankNode(bnodes[0]);
    }

    public ListToRdf<Triple, Quad, Iri, Bnode, Resource, Literal, Value> uriValidation(boolean uriValidation) {
        this.uriValidation = uriValidation;
        return this;
    }
}

