/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.helpers;

import java.lang.ref.Cleaner;
import org.eclipse.rdf4j.common.concurrent.locks.diagnostics.ConcurrentCleaner;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class CleanerIteration<E>
implements CloseableIteration<E> {
    private static final Logger logger = LoggerFactory.getLogger(CleanerIteration.class);
    private final CloseableIteration<E> delegate;
    private final Cleaner.Cleanable cleanable;
    private final CleanableState<E> state;

    public CleanerIteration(CloseableIteration<E> delegate, ConcurrentCleaner cleaner) {
        this.delegate = delegate;
        this.state = new CleanableState<E>(delegate);
        this.cleanable = cleaner.register(this, this.state);
    }

    public void close() {
        this.state.close();
        this.cleanable.clean();
    }

    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    public E next() {
        return (E)this.delegate.next();
    }

    public void remove() {
        this.delegate.remove();
    }

    private static final class CleanableState<E>
    implements Runnable {
        private final CloseableIteration<E> iteration;
        private boolean closed = false;

        public CleanableState(CloseableIteration<E> iteration) {
            this.iteration = iteration;
        }

        @Override
        public void run() {
            if (!this.closed) {
                logger.warn("Forced closing of unclosed iteration. Set the system property 'org.eclipse.rdf4j.repository.debug' to 'true' to get stack traces.");
                this.iteration.close();
            }
        }

        public void close() {
            this.closed = true;
            this.iteration.close();
        }
    }
}

