/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers;

import java.net.URI;
import java.net.URISyntaxException;
import javax.inject.Inject;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.repository.RepositoryConnection;
import org.polarsys.reqcycle.traceability.extenders.TTypeExtender;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.storage.sesame.storage.helpers.StorageHelpersProvider;
import org.polarsys.reqcycle.traceability.utils.SerializationUtils;
import org.polarsys.reqcycle.uri.IReachableCreator;
import org.polarsys.reqcycle.uri.model.Reachable;

public class KindStorageHelper {
    private static final ValueFactory valueFactory = ValueFactoryImpl.getInstance();
    @Inject
    protected IReachableCreator creator;

    KindStorageHelper(RepositoryConnection conn, StorageHelpersProvider storageHelpersProvider) {
    }

    public static org.openrdf.model.URI getURI(String id) {
        return valueFactory.createURI("http://www.polarsys.org/projects/polarsys.reqcycle/syntax#", "ttype?id=" + id);
    }

    public TType toTType(Reachable reachable) {
        if (reachable == null) {
            return null;
        }
        String serializedData = TTypeExtender.getData((Reachable)reachable);
        return (TType)SerializationUtils.deserialize((String)serializedData);
    }

    public Reachable toReachable(TType ttype) throws URISyntaxException {
        org.openrdf.model.URI kindUri = KindStorageHelper.getURI(ttype.getId());
        URI netUri = new URI(kindUri.stringValue());
        return this.creator.getReachable(netUri, (Object)ttype);
    }
}

