/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.traceability.types;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.polarsys.reqcycle.traceability.model.TType;
import org.polarsys.reqcycle.traceability.types.TAttributeProvider;
import org.polarsys.reqcycle.traceability.types.TTypeProvider;
import org.polarsys.reqcycle.traceability.types.configuration.typeconfiguration.RegisteredAttribute;

public class ExtensionPointReader {
    public static String EXT_ID_TTYPES = "ttypes";
    public static String EXT_ID_ATTRIBUTES = "tattributes";
    public static String ATT_CLASS_NAME = "provider";

    public Map<String, TType> readTTypes() {
        Iterable allConf = Iterables.filter(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.traceability.types", EXT_ID_TTYPES)), IConfigurationElement.class);
        Iterable allProviders = Iterables.transform((Iterable)allConf, (Function)new Conf2Provider());
        Iterable allTTypes = Iterables.transform((Iterable)allProviders, (Function)new Provider2TType());
        Iterable allTTypesFlattened = Iterables.concat((Iterable)allTTypes);
        return Maps.uniqueIndex((Iterable)allTTypesFlattened, (Function)new Function<TType, String>(){

            public String apply(TType arg0) {
                return arg0.getId();
            }
        });
    }

    public Map<String, RegisteredAttribute> readAttributes() {
        Iterable allConf = Iterables.filter(Arrays.asList(Platform.getExtensionRegistry().getConfigurationElementsFor("org.polarsys.reqcycle.traceability.types", EXT_ID_ATTRIBUTES)), IConfigurationElement.class);
        Iterable allProviders = Iterables.transform((Iterable)allConf, (Function)new Conf2AttProvider());
        Iterable allTTypes = Iterables.transform((Iterable)allProviders, (Function)new Provider2TAType());
        Iterable allTTypesFlattened = Iterables.concat((Iterable)allTTypes);
        return Maps.uniqueIndex((Iterable)allTTypesFlattened, (Function)new Function<RegisteredAttribute, String>(){

            public String apply(RegisteredAttribute arg0) {
                return arg0.getId();
            }
        });
    }

    private final class Conf2AttProvider
    implements Function<IConfigurationElement, TAttributeProvider> {
        private Conf2AttProvider() {
        }

        public TAttributeProvider apply(IConfigurationElement arg0) {
            TAttributeProvider t = null;
            try {
                t = (TAttributeProvider)arg0.createExecutableExtension(ATT_CLASS_NAME);
            }
            catch (CoreException coreException) {}
            return t;
        }
    }

    private final class Conf2Provider
    implements Function<IConfigurationElement, TTypeProvider> {
        private Conf2Provider() {
        }

        public TTypeProvider apply(IConfigurationElement arg0) {
            TTypeProvider t = null;
            try {
                t = (TTypeProvider)arg0.createExecutableExtension(ATT_CLASS_NAME);
            }
            catch (CoreException coreException) {}
            return t;
        }
    }

    private final class Provider2TAType
    implements Function<TAttributeProvider, Iterable<RegisteredAttribute>> {
        private Provider2TAType() {
        }

        public Iterable<RegisteredAttribute> apply(TAttributeProvider arg0) {
            return arg0.getAttributes();
        }
    }

    private final class Provider2TType
    implements Function<TTypeProvider, Iterable<TType>> {
        private Provider2TType() {
        }

        public Iterable<TType> apply(TTypeProvider arg0) {
            return arg0.getTTypes();
        }
    }
}

