/*
 * Decompiled with CFR 0.152.
 */
package org.polarsys.reqcycle.emf.traceability.sysml.types;

import javax.inject.Inject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.polarsys.reqcycle.emf.types.EMFTypeChecker;
import org.polarsys.reqcycle.types.IInjectedTypeChecker;
import org.polarsys.reqcycle.uri.IReachableManager;
import org.polarsys.reqcycle.uri.exceptions.IReachableHandlerException;
import org.polarsys.reqcycle.uri.exceptions.VisitableException;
import org.polarsys.reqcycle.uri.model.Reachable;
import org.polarsys.reqcycle.uri.model.ReachableObject;
import org.polarsys.reqcycle.uri.visitors.IVisitor;

public class UMLTypeChecker
implements IInjectedTypeChecker {
    @Inject
    IReachableManager manager;
    @IInjectedTypeChecker.InjectValue
    String stereotypeName;
    @IInjectedTypeChecker.InjectValue
    String elementName;

    public boolean apply(Reachable reachable) {
        EMFTypeChecker emfTypeChecker = new EMFTypeChecker();
        if (emfTypeChecker.apply(reachable)) {
            try {
                ReachableObject object = this.manager.getHandlerFromReachable(reachable).getFromReachable(reachable);
                IsUMLVisitor visitor = new IsUMLVisitor();
                object.getVisitable().accept((IVisitor)visitor);
                return visitor.found;
            }
            catch (IReachableHandlerException e) {
                e.printStackTrace();
            }
            catch (VisitableException e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public boolean isElementOK(Element e) {
        boolean isOK = true;
        if (this.elementName != null) {
            isOK = this.elementName.equalsIgnoreCase(e.eClass().getName());
        }
        return isOK;
    }

    public boolean isStereotypeOk(Element e) {
        boolean isOK = true;
        if (this.stereotypeName != null) {
            isOK = false;
            for (Stereotype s : e.getApplicableStereotypes()) {
                if (!this.stereotypeName.equalsIgnoreCase(s.getName())) continue;
                isOK = true;
                break;
            }
        }
        return isOK;
    }

    class IsUMLVisitor
    implements IVisitor {
        boolean found = false;

        IsUMLVisitor() {
        }

        public void start(IAdaptable adaptable) {
        }

        public boolean visit(Object o, IAdaptable adaptable) {
            if (o instanceof Element) {
                if (UMLTypeChecker.this.stereotypeName == null && UMLTypeChecker.this.elementName == null) {
                    this.found = true;
                } else {
                    this.found = false;
                    Element e = (Element)o;
                    if (UMLTypeChecker.this.isStereotypeOk(e) && UMLTypeChecker.this.isElementOK(e)) {
                        this.found = true;
                    }
                }
            }
            return false;
        }

        public void end(IAdaptable adaptable) {
        }

        boolean getResult() {
            return this.found;
        }
    }
}

