/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.events;

import org.eclipse.rwt.Adaptable;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.TypedEvent;
import org.eclipse.swt.internal.widgets.EventUtil;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;

public class KeyEvent
extends TypedEvent {
    private static final long serialVersionUID = 1L;
    public static final int KEY_PRESSED = 1;
    public static final int KEY_RELEASED = 2;
    private static final Class LISTENER;
    public char character;
    public int keyCode;
    public int stateMask;
    public boolean doit;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.swt.events.KeyListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LISTENER = clazz;
    }

    public KeyEvent(Event event) {
        super(event);
        this.character = event.character;
        this.keyCode = event.keyCode;
        this.stateMask = event.stateMask;
        this.doit = event.doit;
    }

    public KeyEvent(Control source, int id) {
        super(source, id);
        this.doit = true;
    }

    protected void dispatchToObserver(Object listener) {
        switch (this.getID()) {
            case 1: {
                ((KeyListener)listener).keyPressed(this);
                break;
            }
            case 2: {
                ((KeyListener)listener).keyReleased(this);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid event handler type.");
            }
        }
    }

    protected Class getListenerType() {
        return LISTENER;
    }

    protected boolean allowProcessing() {
        return EventUtil.isAccessible(this.widget);
    }

    public String toString() {
        String string = super.toString();
        return String.valueOf(string.substring(0, string.length() - 1)) + " character='" + (this.character == '\u0000' ? "\\0" : "" + this.character) + "'" + " keyCode=" + this.keyCode + " stateMask=" + this.stateMask + " doit=" + this.doit + "}";
    }

    public static void addListener(Adaptable adaptable, KeyListener listener) {
        KeyEvent.addListener(adaptable, LISTENER, listener);
    }

    public static void removeListener(Adaptable adaptable, KeyListener listener) {
        KeyEvent.removeListener(adaptable, LISTENER, listener);
    }

    public static boolean hasListener(Adaptable adaptable) {
        return KeyEvent.hasListener(adaptable, LISTENER);
    }
}

