/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.resources;

import com.yahoo.platform.yui.compressor.JavaScriptCompressor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import org.eclipse.rwt.internal.resources.QxCodeCleaner;
import org.eclipse.rwt.internal.resources.TokenList;
import org.mozilla.javascript.ErrorReporter;
import org.mozilla.javascript.EvaluatorException;

public class JSFile {
    private static final boolean PRESERVE_ALL_SEMICOLONS = false;
    private static final boolean DISABLE_OPTIMIZATIONS = false;
    private static final boolean VERBOSE = false;
    private static final ErrorReporter REPORTER = new SystemErrorReporter();
    private final JavaScriptCompressor compressor;
    private final TokenList tokens;

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public JSFile(String javaScript) throws IOException {
        StringReader inputReader = new StringReader(javaScript);
        try {
            this.compressor = new JavaScriptCompressor(inputReader, REPORTER);
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            ((Reader)inputReader).close();
            throw throwable;
        }
        {
            Object var3_5 = null;
        }
        ((Reader)inputReader).close();
        this.tokens = new TokenList(this.compressor.getTokens());
    }

    public TokenList getTokens() {
        return this.tokens;
    }

    public String compress() throws IOException {
        JSFile.cleanupCode(this.tokens);
        StringWriter stringWriter = new StringWriter();
        this.compressor.compress(stringWriter, -1, true, false, false, false);
        stringWriter.flush();
        String result = stringWriter.getBuffer().toString();
        stringWriter.close();
        return result;
    }

    private static void cleanupCode(TokenList tokens) {
        QxCodeCleaner codeCleaner = new QxCodeCleaner(tokens);
        codeCleaner.cleanupQxCode();
    }

    private static final class SystemErrorReporter
    implements ErrorReporter {
        private SystemErrorReporter() {
        }

        public void warning(String message, String sourceName, int line, String lineSource, int lineOffset) {
            System.out.println(this.getMessage("WARNING", message));
        }

        public void error(String message, String sourceName, int line, String lineSource, int lineOffset) {
            System.out.println(this.getMessage("ERROR", message));
        }

        public EvaluatorException runtimeError(String message, String sourceName, int line, String lineSource, int lineOffset) {
            this.error(message, sourceName, line, lineSource, lineOffset);
            return new EvaluatorException(message);
        }

        private String getMessage(String severity, String message) {
            StringBuffer result = new StringBuffer();
            result.append("\n[");
            result.append(severity);
            result.append("] ");
            result.append(message);
            return result.toString();
        }
    }
}

