/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rwt.internal.uicallback;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.eclipse.rwt.SessionSingletonBase;
import org.eclipse.rwt.internal.service.ContextProvider;
import org.eclipse.rwt.internal.uicallback.CallBackActivationTracker;
import org.eclipse.rwt.internal.uicallback.CallBackRequestTracker;
import org.eclipse.rwt.internal.util.SerializableLock;
import org.eclipse.rwt.service.IServiceStore;
import org.eclipse.rwt.service.ISessionStore;
import org.eclipse.rwt.service.SessionStoreEvent;
import org.eclipse.rwt.service.SessionStoreListener;
import org.eclipse.swt.internal.SerializableCompatibility;

public final class UICallBackManager
implements SerializableCompatibility {
    private static final int DEFAULT_REQUEST_CHECK_INTERVAL = 30000;
    private static final String FORCE_UI_CALLBACK = String.valueOf(UICallBackManager.class.getName()) + "#forceUICallBack";
    private final CallBackActivationTracker callBackActivationTracker;
    private final SerializableLock lock = new SerializableLock();
    private boolean uiThreadRunning = false;
    private boolean hasRunnables;
    private int requestCheckInterval = 30000;
    private transient CallBackRequestTracker callBackRequestTracker;

    public static UICallBackManager getInstance() {
        return SessionSingletonBase.getInstance(UICallBackManager.class);
    }

    private UICallBackManager() {
        this.callBackActivationTracker = new CallBackActivationTracker();
        this.callBackRequestTracker = new CallBackRequestTracker();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCallBackRequestBlocked() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return !this.callBackRequestTracker.hasActive();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeClient() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            if (!this.uiThreadRunning) {
                this.releaseBlockedRequest();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseBlockedRequest() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHasRunnables(boolean hasRunnables) {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.hasRunnables = hasRunnables;
        }
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        if (serviceStore != null && hasRunnables && this.isUICallBackActive()) {
            serviceStore.setAttribute(FORCE_UI_CALLBACK, Boolean.TRUE);
        }
    }

    public void setRequestCheckInterval(int requestCheckInterval) {
        this.requestCheckInterval = requestCheckInterval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUIThreadStart() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.uiThreadRunning = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUIThreadEnd() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            this.uiThreadRunning = false;
            if (this.hasRunnables) {
                this.wakeClient();
            }
        }
    }

    public void activateUICallBacksFor(String id) {
        this.callBackActivationTracker.activate(id);
    }

    public void deactivateUICallBacksFor(String id) {
        this.callBackActivationTracker.deactivate(id);
        if (!this.callBackActivationTracker.isActive()) {
            this.releaseBlockedRequest();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasRunnables() {
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            return this.hasRunnables;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean processRequest(HttpServletResponse response) {
        boolean result = true;
        SerializableLock serializableLock = this.lock;
        synchronized (serializableLock) {
            block12: {
                if (this.isCallBackRequestBlocked()) {
                    this.releaseBlockedRequest();
                }
                if (this.mustBlockCallBackRequest()) {
                    long requestStartTime = System.currentTimeMillis();
                    this.callBackRequestTracker.activate(Thread.currentThread());
                    SessionTerminationListener listener = UICallBackManager.attachSessionTerminationListener();
                    try {
                        try {
                            boolean canRelease = false;
                            while (!canRelease) {
                                this.lock.wait(this.requestCheckInterval);
                                canRelease = this.canReleaseBlockedRequest(response, requestStartTime);
                            }
                            result = this.callBackRequestTracker.isActive(Thread.currentThread());
                            if (UICallBackManager.isSessionExpired(requestStartTime)) {
                                result = false;
                            }
                        }
                        catch (InterruptedException interruptedException) {
                            result = false;
                            Thread.interrupted();
                            listener.detach();
                            this.callBackRequestTracker.deactivate(Thread.currentThread());
                            break block12;
                        }
                    }
                    catch (Throwable throwable) {
                        listener.detach();
                        this.callBackRequestTracker.deactivate(Thread.currentThread());
                        throw throwable;
                    }
                    listener.detach();
                    this.callBackRequestTracker.deactivate(Thread.currentThread());
                }
            }
        }
        return result;
    }

    private boolean canReleaseBlockedRequest(HttpServletResponse response, long requestStartTime) {
        boolean result = false;
        if (!this.mustBlockCallBackRequest()) {
            result = true;
        } else if (UICallBackManager.isSessionExpired(requestStartTime)) {
            result = true;
        } else if (!UICallBackManager.isConnectionAlive(response)) {
            result = true;
        } else if (!this.callBackRequestTracker.isActive(Thread.currentThread())) {
            result = true;
        }
        return result;
    }

    boolean mustBlockCallBackRequest() {
        return this.isUICallBackActive() && !this.hasRunnables;
    }

    boolean isUICallBackActive() {
        return this.callBackActivationTracker.isActive();
    }

    boolean needsActivation() {
        return this.isUICallBackActive() || UICallBackManager.forceUICallBackForPendingRunnables();
    }

    private Object readResolve() {
        this.callBackRequestTracker = new CallBackRequestTracker();
        return this;
    }

    private static SessionTerminationListener attachSessionTerminationListener() {
        ISessionStore sessionStore = ContextProvider.getSessionStore();
        SessionTerminationListener result = new SessionTerminationListener(sessionStore);
        result.attach();
        return result;
    }

    private static boolean isSessionExpired(long requestStartTime) {
        return UICallBackManager.isSessionExpired(requestStartTime, System.currentTimeMillis());
    }

    static boolean isSessionExpired(long requestStartTime, long currentTime) {
        boolean result = false;
        HttpSession httpSession = ContextProvider.getSessionStore().getHttpSession();
        int maxInactiveInterval = httpSession.getMaxInactiveInterval();
        if (maxInactiveInterval > 0) {
            result = currentTime > requestStartTime + (long)(maxInactiveInterval * 1000);
        }
        return result;
    }

    private static boolean isConnectionAlive(HttpServletResponse response) {
        boolean result;
        try {
            PrintWriter writer = response.getWriter();
            writer.write(" ");
            result = !writer.checkError();
        }
        catch (IOException iOException) {
            result = false;
        }
        return result;
    }

    private static boolean forceUICallBackForPendingRunnables() {
        boolean result = false;
        IServiceStore serviceStore = ContextProvider.getServiceStore();
        if (serviceStore != null) {
            result = Boolean.TRUE.equals(serviceStore.getAttribute(FORCE_UI_CALLBACK));
        }
        return result;
    }

    private static class SessionTerminationListener
    implements SessionStoreListener,
    SerializableCompatibility {
        private final transient Thread currentThread;
        private final transient ISessionStore sessionStore;

        private SessionTerminationListener(ISessionStore sessionStore) {
            this.sessionStore = sessionStore;
            this.currentThread = Thread.currentThread();
        }

        public void attach() {
            this.sessionStore.addSessionStoreListener(this);
        }

        public void detach() {
            this.sessionStore.removeSessionStoreListener(this);
        }

        public void beforeDestroy(SessionStoreEvent event) {
            this.currentThread.interrupt();
        }
    }
}

