/**
 * /**
 * Copyright (c) 2023 DB Netz AG and others.
 *  
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v2.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v20.html
 */
package org.eclipse.set.toolboxmodel.Block.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;

import org.eclipse.set.toolboxmodel.Block.util.BlockAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc -->
 * <!-- end-user-doc -->
 * @generated
 */
public class BlockItemProviderAdapterFactory extends BlockAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {
	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	public BlockItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Auto_Erlaubnisholen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Auto_Erlaubnisholen_TypeClassItemProvider auto_Erlaubnisholen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Auto_Erlaubnisholen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuto_Erlaubnisholen_TypeClassAdapter() {
		if (auto_Erlaubnisholen_TypeClassItemProvider == null) {
			auto_Erlaubnisholen_TypeClassItemProvider = new Auto_Erlaubnisholen_TypeClassItemProvider(this);
		}

		return auto_Erlaubnisholen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Auto_Erlaubnisruecklauf_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Auto_Erlaubnisruecklauf_TypeClassItemProvider auto_Erlaubnisruecklauf_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Auto_Erlaubnisruecklauf_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createAuto_Erlaubnisruecklauf_TypeClassAdapter() {
		if (auto_Erlaubnisruecklauf_TypeClassItemProvider == null) {
			auto_Erlaubnisruecklauf_TypeClassItemProvider = new Auto_Erlaubnisruecklauf_TypeClassItemProvider(this);
		}

		return auto_Erlaubnisruecklauf_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Betriebsfuehrung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Betriebsfuehrung_TypeClassItemProvider betriebsfuehrung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Betriebsfuehrung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBetriebsfuehrung_TypeClassAdapter() {
		if (betriebsfuehrung_TypeClassItemProvider == null) {
			betriebsfuehrung_TypeClassItemProvider = new Betriebsfuehrung_TypeClassItemProvider(this);
		}

		return betriebsfuehrung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Anlage} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_AnlageItemProvider block_AnlageItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Anlage}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_AnlageAdapter() {
		if (block_AnlageItemProvider == null) {
			block_AnlageItemProvider = new Block_AnlageItemProvider(this);
		}

		return block_AnlageItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Anlage_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_Anlage_Allg_AttributeGroupItemProvider block_Anlage_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Anlage_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_Anlage_Allg_AttributeGroupAdapter() {
		if (block_Anlage_Allg_AttributeGroupItemProvider == null) {
			block_Anlage_Allg_AttributeGroupItemProvider = new Block_Anlage_Allg_AttributeGroupItemProvider(this);
		}

		return block_Anlage_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Bauform_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_Bauform_TypeClassItemProvider block_Bauform_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Bauform_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_Bauform_TypeClassAdapter() {
		if (block_Bauform_TypeClassItemProvider == null) {
			block_Bauform_TypeClassItemProvider = new Block_Bauform_TypeClassItemProvider(this);
		}

		return block_Bauform_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Element} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_ElementItemProvider block_ElementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Element}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_ElementAdapter() {
		if (block_ElementItemProvider == null) {
			block_ElementItemProvider = new Block_ElementItemProvider(this);
		}

		return block_ElementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Element_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_Element_Allg_AttributeGroupItemProvider block_Element_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Element_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_Element_Allg_AttributeGroupAdapter() {
		if (block_Element_Allg_AttributeGroupItemProvider == null) {
			block_Element_Allg_AttributeGroupItemProvider = new Block_Element_Allg_AttributeGroupItemProvider(this);
		}

		return block_Element_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Element_Erlaubnis_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_Element_Erlaubnis_AttributeGroupItemProvider block_Element_Erlaubnis_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Element_Erlaubnis_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_Element_Erlaubnis_AttributeGroupAdapter() {
		if (block_Element_Erlaubnis_AttributeGroupItemProvider == null) {
			block_Element_Erlaubnis_AttributeGroupItemProvider = new Block_Element_Erlaubnis_AttributeGroupItemProvider(this);
		}

		return block_Element_Erlaubnis_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Strecke} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_StreckeItemProvider block_StreckeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Strecke}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_StreckeAdapter() {
		if (block_StreckeItemProvider == null) {
			block_StreckeItemProvider = new Block_StreckeItemProvider(this);
		}

		return block_StreckeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Block_Strecke_Allg_AttributeGroup} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Block_Strecke_Allg_AttributeGroupItemProvider block_Strecke_Allg_AttributeGroupItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Block_Strecke_Allg_AttributeGroup}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBlock_Strecke_Allg_AttributeGroupAdapter() {
		if (block_Strecke_Allg_AttributeGroupItemProvider == null) {
			block_Strecke_Allg_AttributeGroupItemProvider = new Block_Strecke_Allg_AttributeGroupItemProvider(this);
		}

		return block_Strecke_Allg_AttributeGroupItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Bremsweg_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Bremsweg_TypeClassItemProvider bremsweg_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Bremsweg_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createBremsweg_TypeClassAdapter() {
		if (bremsweg_TypeClassItemProvider == null) {
			bremsweg_TypeClassItemProvider = new Bremsweg_TypeClassItemProvider(this);
		}

		return bremsweg_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Erlaubnis_Staendig_Vorhanden_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Erlaubnis_Staendig_Vorhanden_TypeClassItemProvider erlaubnis_Staendig_Vorhanden_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Erlaubnis_Staendig_Vorhanden_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErlaubnis_Staendig_Vorhanden_TypeClassAdapter() {
		if (erlaubnis_Staendig_Vorhanden_TypeClassItemProvider == null) {
			erlaubnis_Staendig_Vorhanden_TypeClassItemProvider = new Erlaubnis_Staendig_Vorhanden_TypeClassItemProvider(this);
		}

		return erlaubnis_Staendig_Vorhanden_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Erlaubnisabgabespeicherung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Erlaubnisabgabespeicherung_TypeClassItemProvider erlaubnisabgabespeicherung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Erlaubnisabgabespeicherung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErlaubnisabgabespeicherung_TypeClassAdapter() {
		if (erlaubnisabgabespeicherung_TypeClassItemProvider == null) {
			erlaubnisabgabespeicherung_TypeClassItemProvider = new Erlaubnisabgabespeicherung_TypeClassItemProvider(this);
		}

		return erlaubnisabgabespeicherung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Erlaubnisholen_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Erlaubnisholen_TypeClassItemProvider erlaubnisholen_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Erlaubnisholen_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createErlaubnisholen_TypeClassAdapter() {
		if (erlaubnisholen_TypeClassItemProvider == null) {
			erlaubnisholen_TypeClassItemProvider = new Erlaubnisholen_TypeClassItemProvider(this);
		}

		return erlaubnisholen_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Rueckblockwecker_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Rueckblockwecker_TypeClassItemProvider rueckblockwecker_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Rueckblockwecker_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createRueckblockwecker_TypeClassAdapter() {
		if (rueckblockwecker_TypeClassItemProvider == null) {
			rueckblockwecker_TypeClassItemProvider = new Rueckblockwecker_TypeClassItemProvider(this);
		}

		return rueckblockwecker_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Schaltung_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schaltung_TypeClassItemProvider schaltung_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Schaltung_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchaltung_TypeClassAdapter() {
		if (schaltung_TypeClassItemProvider == null) {
			schaltung_TypeClassItemProvider = new Schaltung_TypeClassItemProvider(this);
		}

		return schaltung_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Schutzuebertrager_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Schutzuebertrager_TypeClassItemProvider schutzuebertrager_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Schutzuebertrager_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createSchutzuebertrager_TypeClassAdapter() {
		if (schutzuebertrager_TypeClassItemProvider == null) {
			schutzuebertrager_TypeClassItemProvider = new Schutzuebertrager_TypeClassItemProvider(this);
		}

		return schutzuebertrager_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Strecke_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Strecke_Art_TypeClassItemProvider strecke_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Strecke_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStrecke_Art_TypeClassAdapter() {
		if (strecke_Art_TypeClassItemProvider == null) {
			strecke_Art_TypeClassItemProvider = new Strecke_Art_TypeClassItemProvider(this);
		}

		return strecke_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Streckengeschwindigkeit_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Streckengeschwindigkeit_TypeClassItemProvider streckengeschwindigkeit_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Streckengeschwindigkeit_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createStreckengeschwindigkeit_TypeClassAdapter() {
		if (streckengeschwindigkeit_TypeClassItemProvider == null) {
			streckengeschwindigkeit_TypeClassItemProvider = new Streckengeschwindigkeit_TypeClassItemProvider(this);
		}

		return streckengeschwindigkeit_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Traktion_Art_Elektrisch_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Traktion_Art_Elektrisch_TypeClassItemProvider traktion_Art_Elektrisch_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Traktion_Art_Elektrisch_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createTraktion_Art_Elektrisch_TypeClassAdapter() {
		if (traktion_Art_Elektrisch_TypeClassItemProvider == null) {
			traktion_Art_Elektrisch_TypeClassItemProvider = new Traktion_Art_Elektrisch_TypeClassItemProvider(this);
		}

		return traktion_Art_Elektrisch_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Vorblockwecker_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Vorblockwecker_TypeClassItemProvider vorblockwecker_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Vorblockwecker_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createVorblockwecker_TypeClassAdapter() {
		if (vorblockwecker_TypeClassItemProvider == null) {
			vorblockwecker_TypeClassItemProvider = new Vorblockwecker_TypeClassItemProvider(this);
		}

		return vorblockwecker_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Zugbeeinflussung_Art_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zugbeeinflussung_Art_TypeClassItemProvider zugbeeinflussung_Art_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Zugbeeinflussung_Art_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZugbeeinflussung_Art_TypeClassAdapter() {
		if (zugbeeinflussung_Art_TypeClassItemProvider == null) {
			zugbeeinflussung_Art_TypeClassItemProvider = new Zugbeeinflussung_Art_TypeClassItemProvider(this);
		}

		return zugbeeinflussung_Art_TypeClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.set.toolboxmodel.Block.Zusatzinformation_TypeClass} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	protected Zusatzinformation_TypeClassItemProvider zusatzinformation_TypeClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.set.toolboxmodel.Block.Zusatzinformation_TypeClass}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter createZusatzinformation_TypeClassAdapter() {
		if (zusatzinformation_TypeClassItemProvider == null) {
			zusatzinformation_TypeClassItemProvider = new Zusatzinformation_TypeClassItemProvider(this);
		}

		return zusatzinformation_TypeClassItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if (isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if (!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if (parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory. 
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * @generated
	 */
	@Override
	public void dispose() {
		if (auto_Erlaubnisholen_TypeClassItemProvider != null) auto_Erlaubnisholen_TypeClassItemProvider.dispose();
		if (auto_Erlaubnisruecklauf_TypeClassItemProvider != null) auto_Erlaubnisruecklauf_TypeClassItemProvider.dispose();
		if (betriebsfuehrung_TypeClassItemProvider != null) betriebsfuehrung_TypeClassItemProvider.dispose();
		if (block_AnlageItemProvider != null) block_AnlageItemProvider.dispose();
		if (block_Anlage_Allg_AttributeGroupItemProvider != null) block_Anlage_Allg_AttributeGroupItemProvider.dispose();
		if (block_Bauform_TypeClassItemProvider != null) block_Bauform_TypeClassItemProvider.dispose();
		if (block_ElementItemProvider != null) block_ElementItemProvider.dispose();
		if (block_Element_Allg_AttributeGroupItemProvider != null) block_Element_Allg_AttributeGroupItemProvider.dispose();
		if (block_Element_Erlaubnis_AttributeGroupItemProvider != null) block_Element_Erlaubnis_AttributeGroupItemProvider.dispose();
		if (block_StreckeItemProvider != null) block_StreckeItemProvider.dispose();
		if (block_Strecke_Allg_AttributeGroupItemProvider != null) block_Strecke_Allg_AttributeGroupItemProvider.dispose();
		if (bremsweg_TypeClassItemProvider != null) bremsweg_TypeClassItemProvider.dispose();
		if (erlaubnis_Staendig_Vorhanden_TypeClassItemProvider != null) erlaubnis_Staendig_Vorhanden_TypeClassItemProvider.dispose();
		if (erlaubnisabgabespeicherung_TypeClassItemProvider != null) erlaubnisabgabespeicherung_TypeClassItemProvider.dispose();
		if (erlaubnisholen_TypeClassItemProvider != null) erlaubnisholen_TypeClassItemProvider.dispose();
		if (rueckblockwecker_TypeClassItemProvider != null) rueckblockwecker_TypeClassItemProvider.dispose();
		if (schaltung_TypeClassItemProvider != null) schaltung_TypeClassItemProvider.dispose();
		if (schutzuebertrager_TypeClassItemProvider != null) schutzuebertrager_TypeClassItemProvider.dispose();
		if (strecke_Art_TypeClassItemProvider != null) strecke_Art_TypeClassItemProvider.dispose();
		if (streckengeschwindigkeit_TypeClassItemProvider != null) streckengeschwindigkeit_TypeClassItemProvider.dispose();
		if (traktion_Art_Elektrisch_TypeClassItemProvider != null) traktion_Art_Elektrisch_TypeClassItemProvider.dispose();
		if (vorblockwecker_TypeClassItemProvider != null) vorblockwecker_TypeClassItemProvider.dispose();
		if (zugbeeinflussung_Art_TypeClassItemProvider != null) zugbeeinflussung_Art_TypeClassItemProvider.dispose();
		if (zusatzinformation_TypeClassItemProvider != null) zusatzinformation_TypeClassItemProvider.dispose();
	}

}
