/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.pages;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.search.internal.ui.SearchDialog;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.sphinx.emf.search.ui.internal.Activator;
import org.eclipse.sphinx.emf.search.ui.internal.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class ScopePart {
    private static final String DIALOG_SETTINGS_KEY = "SearchDialog.ScopePart";
    private static final String STORE_SCOPE = "scope";
    private IDialogSettings fSettingsStore;
    private Group fPart;
    private Button fUseWorkspace;
    private Button fUseSelection;
    private Button fUseProject;
    private int fScope;
    private boolean fCanSearchEnclosingProjects;
    private SearchDialog fSearchDialog;
    private boolean fActiveEditorCanProvideScopeSelection;

    public ScopePart(SearchDialog searchDialog, boolean searchEnclosingProjects) {
        this.fSearchDialog = searchDialog;
        this.fCanSearchEnclosingProjects = searchEnclosingProjects;
        this.fSettingsStore = Activator.getDefault().getDialogSettingsSection(DIALOG_SETTINGS_KEY);
        this.fScope = ScopePart.getStoredScope(this.fSettingsStore, searchEnclosingProjects);
    }

    private static int getStoredScope(IDialogSettings settingsStore, boolean canSearchEnclosingProjects) {
        int scope;
        try {
            scope = settingsStore.getInt(STORE_SCOPE);
        }
        catch (NumberFormatException ex) {
            scope = 0;
        }
        if (scope != 2 && scope != 1 && scope != 3 && scope != 0) {
            scope = 0;
        }
        if (!canSearchEnclosingProjects && scope == 3) {
            scope = 0;
        }
        return scope;
    }

    public int getSelectedScope() {
        return this.fScope;
    }

    public void setSelectedScope(int scope) {
        Assert.isLegal((scope >= 0 && scope <= 3 ? 1 : 0) != 0);
        Assert.isNotNull((Object)this.fUseWorkspace);
        Assert.isNotNull((Object)this.fUseSelection);
        Assert.isNotNull((Object)this.fUseProject);
        this.fSettingsStore.put(STORE_SCOPE, scope);
        if (scope == 3) {
            if (!this.fCanSearchEnclosingProjects) {
                SearchPlugin.log((IStatus)new Status(2, "org.eclipse.search", 2, "Enclosing projects scope set on search page that does not support it", null));
                scope = 0;
            } else if (!this.fUseProject.isEnabled()) {
                scope = 0;
            }
        } else if (scope == 1 && !this.fUseSelection.isEnabled()) {
            scope = this.fUseProject.isEnabled() ? 3 : 0;
        }
        this.fScope = scope;
        this.fUseWorkspace.setSelection(scope == 0);
        this.fUseSelection.setSelection(scope == 1);
        this.fUseProject.setSelection(scope == 3);
        this.updateSearchPageContainerActionPerformedEnablement();
    }

    public void setActiveEditorCanProvideScopeSelection(boolean state) {
        this.fActiveEditorCanProvideScopeSelection = state;
        this.fUseSelection.setEnabled(this.canSearchInSelection());
        this.fScope = ScopePart.getStoredScope(this.fSettingsStore, this.fCanSearchEnclosingProjects);
        this.setSelectedScope(this.fScope);
    }

    private void updateSearchPageContainerActionPerformedEnablement() {
        this.fSearchDialog.notifyScopeSelectionChanged();
    }

    public Composite createPart(Composite parent) {
        this.fPart = new Group(parent, 0);
        this.fPart.setText(Messages.ScopePart_group_text);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        this.fPart.setLayout((Layout)layout);
        this.fPart.setLayoutData((Object)new GridData(768));
        this.fUseWorkspace = new Button((Composite)this.fPart, 16);
        this.fUseWorkspace.setData((Object)new Integer(0));
        this.fUseWorkspace.setText(Messages.ScopePart_workspaceScope_text);
        this.fUseSelection = new Button((Composite)this.fPart, 16);
        this.fUseSelection.setData((Object)new Integer(1));
        this.fUseSelection.setText(Messages.ScopePart_selectedResourcesScope_text);
        boolean canSearchInSelection = this.canSearchInSelection();
        this.fUseSelection.setEnabled(canSearchInSelection);
        GridData gd = new GridData(32);
        gd.horizontalIndent = 8;
        this.fUseSelection.setLayoutData((Object)gd);
        this.fUseProject = new Button((Composite)this.fPart, 16);
        this.fUseProject.setData((Object)new Integer(3));
        this.fUseProject.setText(Messages.ScopePart_enclosingModelsScope_text);
        this.fUseProject.setEnabled(this.fSearchDialog.getEnclosingProjectNames().length > 0);
        gd = new GridData(32);
        gd.horizontalSpan = 2;
        gd.horizontalIndent = 8;
        this.fUseProject.setLayoutData((Object)gd);
        if (!this.fCanSearchEnclosingProjects) {
            this.fUseProject.setVisible(false);
        }
        SelectionAdapter scopeChangedLister = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ScopePart.this.handleScopeChanged(e);
            }
        };
        this.fUseWorkspace.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseSelection.addSelectionListener((SelectionListener)scopeChangedLister);
        this.fUseProject.addSelectionListener((SelectionListener)scopeChangedLister);
        this.setSelectedScope(this.fScope);
        return this.fPart;
    }

    private boolean canSearchInSelection() {
        ISelection selection = this.fSearchDialog.getSelection();
        return selection instanceof IStructuredSelection && !selection.isEmpty() || this.fActiveEditorCanProvideScopeSelection && this.fSearchDialog.getActiveEditorInput() != null;
    }

    private void handleScopeChanged(SelectionEvent e) {
        Button button;
        Object source = e.getSource();
        if (source instanceof Button && (button = (Button)source).getSelection()) {
            this.setSelectedScope((Integer)button.getData());
        }
    }

    void setVisible(boolean state) {
        if (state) {
            this.fPart.layout();
        }
        this.fPart.setVisible(state);
    }
}

