/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.resource;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.sphinx.emf.Activator;
import org.eclipse.sphinx.emf.resource.ExtendedResource;
import org.eclipse.sphinx.emf.resource.ExtendedResourceSet;
import org.eclipse.sphinx.emf.resource.OldResourceProviderAdapter;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.platform.util.ReflectUtil;

public class ExtendedResourceAdapter
extends AdapterImpl
implements ExtendedResource {
    private static final URI EMPTY_URI = URI.createURI((String)"");
    protected Map<Object, Object> problemHandlingOptions;
    private Boolean useContextAwareProxyURIs = null;

    @Override
    public Map<Object, Object> getDefaultLoadOptions() {
        Map defaultLoadOptions = null;
        Resource targetResource = (Resource)this.getTarget();
        if (targetResource instanceof XMLResource) {
            defaultLoadOptions = ((XMLResource)targetResource).getDefaultLoadOptions();
        } else {
            try {
                defaultLoadOptions = (Map)ReflectUtil.getInvisibleFieldValue((Object)targetResource, (String)"defaultLoadOptions");
            }
            catch (Exception exception) {}
        }
        return defaultLoadOptions != null ? defaultLoadOptions : new HashMap();
    }

    @Override
    public Map<Object, Object> getDefaultSaveOptions() {
        Map defaultSaveOptions = null;
        Resource targetResource = (Resource)this.getTarget();
        if (targetResource instanceof XMLResource) {
            defaultSaveOptions = ((XMLResource)targetResource).getDefaultLoadOptions();
        } else {
            try {
                defaultSaveOptions = (Map)ReflectUtil.getInvisibleFieldValue((Object)targetResource, (String)"defaultSaveOptions");
            }
            catch (Exception exception) {}
        }
        return defaultSaveOptions != null ? defaultSaveOptions : new HashMap();
    }

    @Override
    public Map<Object, Object> getProblemHandlingOptions() {
        if (this.problemHandlingOptions == null) {
            this.problemHandlingOptions = new HashMap<Object, Object>();
            this.problemHandlingOptions.put("MAX_PROBLEM_MARKER_COUNT", OPTION_MAX_PROBLEM_MARKER_COUNT_DEFAULT);
            this.problemHandlingOptions.put("XML_WELLFORMEDNESS_PROBLEM_FORMAT_STRING", OPTION_XML_WELLFORMEDNESS_PROBLEM_FORMAT_STRING_DEFAULT);
            this.problemHandlingOptions.put("XML_VALIDITY_PROBLEM_FORMAT_STRING", OPTION_XML_VALIDITY_PROBLEM_FORMAT_STRING_DEFAULT);
        }
        return this.problemHandlingOptions;
    }

    protected boolean isUseContextAwareProxyURIs() {
        if (this.useContextAwareProxyURIs == null) {
            Map<Object, Object> loadOptions = this.getDefaultLoadOptions();
            this.useContextAwareProxyURIs = !Boolean.FALSE.equals(loadOptions.get("USE_CONTEXT_AWARE_PROXY_URIS"));
        }
        return this.useContextAwareProxyURIs;
    }

    @Override
    public void unloaded(EObject eObject) {
        eObject.eAdapters().clear();
        if (this.getDefaultLoadOptions().get("UNLOAD_MEMORY_OPTIMIZED") == Boolean.TRUE) {
            ((InternalEObject)eObject).eSetProxyURI(EMPTY_URI);
        } else {
            URI uri = this.getURI(eObject);
            if (!eObject.eIsProxy()) {
                ((InternalEObject)eObject).eSetProxyURI(uri);
            }
            if (uri != null && uri.segmentCount() == 0) {
                eObject.eAdapters().add((Object)new OldResourceProviderAdapter((Resource)this.getTarget()));
            }
        }
    }

    @Override
    public URI getURI(EObject eObject) {
        return this.getURI(null, null, eObject, false);
    }

    @Override
    public URI getURI(EObject eObject, boolean resolve) {
        return this.getURI(null, null, eObject, resolve);
    }

    @Override
    public URI getURI(EObject oldOwner, EStructuralFeature oldFeature, EObject eObject) {
        return this.getURI(oldOwner, oldFeature, eObject, false);
    }

    @Override
    public URI getURI(EObject oldOwner, EStructuralFeature oldFeature, EObject eObject, boolean resolve) {
        Assert.isNotNull((Object)eObject);
        if (eObject.eIsProxy()) {
            URI uri = ((InternalEObject)eObject).eProxyURI();
            if (resolve) {
                return this.resolveURI(uri);
            }
            return uri;
        }
        if (eObject.eResource() == null) {
            return this.getOldURI(oldOwner, oldFeature, eObject, resolve);
        }
        Resource resource = eObject.eResource();
        return this.getURI(resource.getURI(), resource.getURIFragment(eObject), resolve);
    }

    protected URI getURI(URI resourceURI, String eObjectURIFragment, boolean resolve) {
        return this.getURI(resourceURI, eObjectURIFragment);
    }

    protected URI getURI(URI resourceURI, String eObjectURIFragment) {
        return resourceURI == null ? URI.createURI((String)("#" + eObjectURIFragment)) : resourceURI.appendFragment(eObjectURIFragment);
    }

    protected URI getOldURI(EObject oldOwner, EStructuralFeature oldFeature, EObject eObject, boolean resolve) {
        Assert.isNotNull((Object)eObject);
        if (oldOwner != null && oldFeature != null) {
            URI oldOwnerURI = EcoreResourceUtil.getURI(oldOwner);
            String oldOwnerURIFragment = oldOwnerURI.fragment();
            EObject eObjectRootContainer = EcoreUtil.getRootContainer((EObject)eObject);
            String eObjectRootContainerURIFragmentSegment = ((InternalEObject)oldOwner).eURIFragmentSegment(oldFeature, eObjectRootContainer);
            ArrayList<String> eObjectURIFragmentSegments = new ArrayList<String>();
            InternalEObject internalEObject = (InternalEObject)eObject;
            InternalEObject container = internalEObject.eInternalContainer();
            while (container != null) {
                eObjectURIFragmentSegments.add(container.eURIFragmentSegment(internalEObject.eContainingFeature(), (EObject)internalEObject));
                internalEObject = container;
                container = internalEObject.eInternalContainer();
            }
            StringBuilder oldEObjectURIFragment = new StringBuilder();
            oldEObjectURIFragment.append(oldOwnerURIFragment);
            oldEObjectURIFragment.append("/");
            oldEObjectURIFragment.append(eObjectRootContainerURIFragmentSegment);
            int i = eObjectURIFragmentSegments.size() - 1;
            while (i >= 0) {
                oldEObjectURIFragment.append("/");
                oldEObjectURIFragment.append((String)eObjectURIFragmentSegments.get(i));
                --i;
            }
            return this.getURI(oldOwnerURI.trimFragment(), oldEObjectURIFragment.toString(), resolve);
        }
        Resource oldResource = (Resource)this.getTarget();
        return this.getURI(oldResource.getURI(), oldResource.getURIFragment(eObject), resolve);
    }

    protected URI resolveURI(URI uri) {
        Assert.isNotNull((Object)uri);
        if (uri.segmentCount() == 0) {
            Resource resource = (Resource)this.getTarget();
            URI resourceURI = resource.getURI();
            String eObjectURIFragment = uri.fragment();
            return this.getURI(resourceURI, eObjectURIFragment);
        }
        return uri;
    }

    @Override
    public URI createURI(String uriLiteral, EClass eClass) {
        return URI.createURI((String)uriLiteral);
    }

    @Override
    public URI getHREF(EObject eObject) {
        return this.getURI(eObject);
    }

    @Override
    public String nomalizeURIFragment(String uriFragment) {
        return uriFragment;
    }

    @Override
    public Diagnostic validateURI(String uri) {
        Assert.isNotNull((Object)uri);
        try {
            URI.createURI((String)uri, (boolean)true);
        }
        catch (IllegalArgumentException ex) {
            return new BasicDiagnostic(Activator.getPlugin().getSymbolicName(), 4, ex.getMessage(), new Object[0]);
        }
        return Diagnostic.OK_INSTANCE;
    }

    @Override
    public void augmentToContextAwareProxy(EObject proxy) {
        Resource contextResource;
        ResourceSet resourceSet;
        if (this.isUseContextAwareProxyURIs() && (resourceSet = (contextResource = (Resource)this.getTarget()).getResourceSet()) instanceof ExtendedResourceSet) {
            ((ExtendedResourceSet)resourceSet).augmentToContextAwareProxy(proxy, contextResource);
        }
    }

    @Override
    public URI trimProxyContextInfo(URI proxyURI) {
        Resource contextResource;
        ResourceSet resourceSet;
        if (this.isUseContextAwareProxyURIs() && (resourceSet = (contextResource = (Resource)this.getTarget()).getResourceSet()) instanceof ExtendedResourceSet) {
            return ((ExtendedResourceSet)resourceSet).trimProxyContextInfo(proxyURI);
        }
        return proxyURI;
    }

    public boolean isAdapterForType(Object type) {
        return type == ExtendedResource.class;
    }

    public void setTarget(Notifier newTarget) {
        Assert.isLegal((newTarget == null || newTarget instanceof Resource ? 1 : 0) != 0);
        super.setTarget(newTarget);
    }
}

