/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.providers;

import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.sphinx.emf.util.WorkspaceEditingDomainUtil;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class ModelSearchLabelProvider
implements ILabelProvider {
    public static final String PROPERTY_MATCH_COUNT = "org.eclipse.sphinx.emf.search.ui.matchCount";
    protected Map<TransactionalEditingDomain, AdapterFactoryLabelProvider> modelLabelProviders = new WeakHashMap<TransactionalEditingDomain, AdapterFactoryLabelProvider>();

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return PROPERTY_MATCH_COUNT.equals(property);
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Image getImage(Object element) {
        AdapterFactoryLabelProvider labelProvider = this.getModelLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getImage(element);
        }
        return null;
    }

    public String getText(Object element) {
        AdapterFactoryLabelProvider labelProvider = this.getModelLabelProvider(element);
        if (labelProvider != null) {
            return labelProvider.getText(element);
        }
        return element.toString();
    }

    protected AdapterFactoryLabelProvider getModelLabelProvider(Object element) {
        TransactionalEditingDomain editingDomain = WorkspaceEditingDomainUtil.getEditingDomain((Object)element);
        if (editingDomain != null) {
            AdapterFactoryLabelProvider modelLabelProvider = this.modelLabelProviders.get(editingDomain);
            if (modelLabelProvider == null) {
                modelLabelProvider = this.createModelLabelProvider(editingDomain);
                this.modelLabelProviders.put(editingDomain, modelLabelProvider);
            }
            return modelLabelProvider;
        }
        return null;
    }

    protected AdapterFactoryLabelProvider createModelLabelProvider(TransactionalEditingDomain editingDomain) {
        Assert.isNotNull((Object)editingDomain);
        AdapterFactory adapterFactory = ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(adapterFactory);
        Font defaultFont = JFaceResources.getDefaultFont();
        labelProvider.setDefaultFont(defaultFont);
        return labelProvider;
    }
}

