/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.validation.ui.views;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.validation.markers.ValidationMarkerManager;
import org.eclipse.sphinx.emf.validation.ui.views.ConcreteMarker;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerList;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerMessages;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerType;
import org.eclipse.sphinx.emf.validation.ui.views.MarkerTypesModel;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;

public class MarkerFilter
implements Cloneable {
    static final String TAG_ENABLED = "enabled";
    private static final String TAG_ON_RESOURCE = "onResource";
    private static final String TAG_SELECTED_TYPES = "selectedType";
    private static final String TAG_WORKING_SET = "workingSet";
    private static final String TAG_TYPES_DELIMITER = ":";
    private static final String TAG_SELECTION_STATUS = "selectionStatus";
    private static final String SELECTED_FALSE = "false";
    private static final String SELECTED_TRUE = "true";
    public static final int ON_ANY = 0;
    public static final int ON_SELECTED_ONLY = 1;
    public static final int ON_SELECTED_AND_CHILDREN = 2;
    public static final int ON_ANY_IN_SAME_CONTAINER = 3;
    public static final int ON_WORKING_SET = 4;
    static final int DEFAULT_ON_RESOURCE = 0;
    static final boolean DEFAULT_ACTIVATION_STATUS = true;
    protected List rootTypes = new ArrayList();
    protected List selectedTypes = new ArrayList();
    protected IWorkingSet workingSet;
    protected int onResource;
    protected boolean enabled;
    private Object[] focusSelection;
    private Set cachedWorkingSet;
    private String name;

    MarkerFilter(String filterName, String[] rootTypes) {
        this.name = filterName;
        String[] stringArray = rootTypes;
        int n = rootTypes.length;
        int n2 = 0;
        while (n2 < n) {
            String element = stringArray[n2];
            MarkerType type = MarkerTypesModel.getInstance().getType(element);
            if (!this.rootTypes.contains(type)) {
                this.rootTypes.add(type);
            }
            ++n2;
        }
        this.resetState();
    }

    public void addAllSubTypes(List types) {
        int i = 0;
        while (i < this.rootTypes.size()) {
            MarkerType rootType = (MarkerType)this.rootTypes.get(i);
            this.addAllSubTypes(types, rootType);
            ++i;
        }
    }

    private void addAllSubTypes(List types, MarkerType type) {
        MarkerType[] subTypes;
        if (type == null) {
            return;
        }
        if (!types.contains(type)) {
            types.add(type);
        }
        MarkerType[] markerTypeArray = subTypes = type.getSubtypes();
        int n = subTypes.length;
        int n2 = 0;
        while (n2 < n) {
            MarkerType element = markerTypeArray[n2];
            this.addAllSubTypes(types, element);
            ++n2;
        }
    }

    /*
     * Unable to fully structure code
     */
    private List findMarkers(Object[] objects, int depth, int limit, IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        if (objects == null || objects.length < 1) {
            return Collections.EMPTY_LIST;
        }
        resultList = new ArrayList<ConcreteMarker>(objects.length * 2);
        typesToSearch = new HashSet<E>(this.selectedTypes.size());
        includeAllSubtypes = new HashSet<MarkerType>(this.selectedTypes.size());
        typesToSearch.addAll(this.selectedTypes);
        for (MarkerType type : this.selectedTypes) {
            subtypes = Arrays.asList(type.getAllSubTypes());
            if (!this.selectedTypes.containsAll(subtypes)) continue;
            typesToSearch.removeAll(subtypes);
            includeAllSubtypes.add(type);
        }
        mon.beginTask(MarkerMessages.MarkerFilter_searching, typesToSearch.size() * objects.length);
        resourcesToSearch = new HashSet<Object>();
        var14_12 = objects;
        var13_14 = objects.length;
        var12_15 = 0;
        while (var12_15 < var13_14) {
            next = var14_12[var12_15];
            if (!(next instanceof IResource == false ? next instanceof EObject != false && (EcorePlatformUtil.getFile((EObject)((EObject)next)) == null || EcorePlatformUtil.getFile((EObject)((EObject)next)).exists() == false) : ((IResource)next).exists() == false)) {
                if (resourcesToSearch.contains(next)) {
                    mon.worked(typesToSearch.size());
                } else {
                    resourcesToSearch.add(next);
                }
            }
            ++var12_15;
        }
        resource = null;
        var15_17 = objects;
        var14_13 = objects.length;
        var13_14 = 0;
        while (var13_14 < var14_13) {
            block27: {
                object = var15_17[var13_14];
                iter = typesToSearch.iterator();
                if (object instanceof IResource) {
                    resource = (IResource)object;
                } else if (object instanceof EObject) {
                    resource = EcorePlatformUtil.getFile((EObject)((EObject)object));
                }
                if (resource == null || !resource.isAccessible()) break block27;
                if (!(object instanceof IResource) || depth != 2) ** GOTO lbl92
                parent = resource.getParent();
                found = false;
                while (parent != null) {
                    if (resourcesToSearch.contains(parent)) {
                        found = true;
                    }
                    parent = parent.getParent();
                }
                if (!found) ** GOTO lbl92
                break block27;
lbl-1000:
                // 1 sources

                {
                    markerType = (MarkerType)iter.next();
                    markers = new IMarker[]{};
                    if (object instanceof IResource) {
                        markers = resource.findMarkers(markerType.getId(), includeAllSubtypes.contains(markerType), depth);
                    } else if (object instanceof EObject) {
                        depthValidation = 2;
                        switch (depth) {
                            case 0: 
                            case 1: {
                                depthValidation = 0;
                                break;
                            }
                            case 2: {
                                depthValidation = 2;
                                break;
                            }
                            default: {
                                depthValidation = 2;
                            }
                        }
                        markers = ValidationMarkerManager.getInstance().getValidationMarkersList((EObject)object, depthValidation);
                    }
                    mon.worked(1);
                    var21_25 = markers;
                    var20_24 = markers.length;
                    var19_23 = 0;
                    while (var19_23 < var20_24) {
                        block26: {
                            element = var21_25[var19_23];
                            try {
                                marker = MarkerList.createMarker(element);
                            }
                            catch (CoreException e) {
                                if (!ignoreExceptions) {
                                    throw e;
                                }
                                break block26;
                            }
                            if (limit != -1 && resultList.size() >= limit) {
                                return resultList;
                            }
                            if (this.selectMarker(marker)) {
                                resultList.add(marker);
                            }
                        }
                        ++var19_23;
                    }
lbl92:
                    // 3 sources

                    ** while (iter.hasNext())
                }
            }
            ++var13_14;
        }
        mon.done();
        return resultList;
    }

    protected boolean selectMarker(ConcreteMarker marker) {
        return true;
    }

    Collection findMarkers(IProgressMonitor mon, boolean ignoreExceptions) throws CoreException {
        List unfiltered = Collections.EMPTY_LIST;
        if (!this.isEnabled()) {
            unfiltered = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, -1, mon, ignoreExceptions);
        } else {
            int limit = -1;
            switch (this.getOnResource()) {
                case 0: {
                    unfiltered = this.findMarkers(new IResource[]{ResourcesPlugin.getWorkspace().getRoot()}, 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 1: {
                    unfiltered = this.findMarkers(this.focusSelection, 0, limit, mon, ignoreExceptions);
                    break;
                }
                case 2: {
                    unfiltered = this.findMarkers(this.focusSelection, 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 3: {
                    unfiltered = this.findMarkers(MarkerFilter.getProjects(this.focusSelection), 2, limit, mon, ignoreExceptions);
                    break;
                }
                case 4: {
                    unfiltered = this.findMarkers(this.getResourcesInWorkingSet(), 2, limit, mon, ignoreExceptions);
                }
            }
        }
        if (unfiltered == null) {
            unfiltered = Collections.EMPTY_LIST;
        }
        return unfiltered;
    }

    IResource[] getResourcesInWorkingSet() {
        if (this.workingSet == null) {
            return new IResource[0];
        }
        if (this.workingSet.isEmpty()) {
            return new IResource[]{ResourcesPlugin.getWorkspace().getRoot()};
        }
        IAdaptable[] elements = this.workingSet.getElements();
        ArrayList<IResource> result = new ArrayList<IResource>(elements.length);
        IAdaptable[] iAdaptableArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IAdaptable element = iAdaptableArray[n2];
            IResource next = (IResource)element.getAdapter(IResource.class);
            if (next != null) {
                result.add(next);
            }
            ++n2;
        }
        return result.toArray(new IResource[result.size()]);
    }

    private Set getWorkingSetAsSetOfPaths() {
        if (this.cachedWorkingSet == null) {
            HashSet result = new HashSet();
            this.addResourcesAndChildren(result, this.getResourcesInWorkingSet());
            this.cachedWorkingSet = result;
        }
        return this.cachedWorkingSet;
    }

    private void addResourcesAndChildren(HashSet result, IResource[] resources) {
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource currentResource = iResourceArray[n2];
            result.add(currentResource.getFullPath().toString());
            if (currentResource instanceof IContainer) {
                IContainer cont = (IContainer)currentResource;
                try {
                    this.addResourcesAndChildren(result, cont.members());
                }
                catch (CoreException coreException) {}
            }
            ++n2;
        }
    }

    static IProject[] getProjects(IResource[] resources) {
        if (resources == null) {
            return new IProject[0];
        }
        Collection projects = MarkerFilter.getProjectsAsCollection(resources);
        return projects.toArray(new IProject[projects.size()]);
    }

    static IProject[] getProjects(Object[] objects) {
        if (objects == null || objects.length < 1) {
            return new IProject[0];
        }
        Collection projects = MarkerFilter.getProjectsAsCollection(objects);
        return projects.toArray(new IProject[projects.size()]);
    }

    static Collection getProjectsAsCollection(Object[] elements) {
        HashSet<IProject> projects = new HashSet<IProject>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof IResource) {
                projects.add(((IResource)element).getProject());
            } else if (element instanceof EObject) {
                IFile resource = EcorePlatformUtil.getFile((EObject)((EObject)element));
                if (resource != null) {
                    projects.add(resource.getProject());
                }
            } else {
                IProject[] mappingProjects;
                IProject[] iProjectArray = mappingProjects = ((ResourceMapping)element).getProjects();
                int n3 = mappingProjects.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProject element2 = iProjectArray[n4];
                    projects.add(element2);
                    ++n4;
                }
            }
            ++n2;
        }
        return projects;
    }

    public boolean select(ConcreteMarker marker) {
        if (!this.isEnabled()) {
            return true;
        }
        return this.selectByType(marker) && this.selectBySelection(marker) && this.selectMarker(marker);
    }

    private boolean selectByType(ConcreteMarker marker) {
        return this.selectedTypes.contains(MarkerTypesModel.getInstance().getType(marker.getType()));
    }

    private boolean selectBySelection(ConcreteMarker marker) {
        block16: {
            IResource resource;
            block18: {
                block17: {
                    block15: {
                        if (this.onResource == 0 || marker == null) {
                            return true;
                        }
                        if (this.focusSelection == null) {
                            return true;
                        }
                        resource = marker.getResource();
                        if (this.onResource != 4) break block15;
                        if (resource != null) {
                            return this.isEnclosed(resource);
                        }
                        break block16;
                    }
                    if (this.onResource != 3) break block17;
                    IProject project = resource.getProject();
                    if (project == null) {
                        return false;
                    }
                    IProject selectedProject = null;
                    Object[] objectArray = this.focusSelection;
                    int n = this.focusSelection.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFile res;
                        Object element = objectArray[n2];
                        if (element instanceof IResource) {
                            selectedProject = ((IResource)element).getProject();
                        } else if (element instanceof EObject && (res = EcorePlatformUtil.getFile((EObject)((EObject)element))) != null) {
                            selectedProject = res.getProject();
                        }
                        if (selectedProject != null && project.equals((Object)selectedProject)) {
                            return true;
                        }
                        ++n2;
                    }
                    break block16;
                }
                if (this.onResource != 1) break block18;
                Object[] objectArray = this.focusSelection;
                int n = this.focusSelection.length;
                int n3 = 0;
                while (n3 < n) {
                    Object element = objectArray[n3];
                    if (element instanceof IResource && resource.equals(element)) {
                        return true;
                    }
                    ++n3;
                }
                break block16;
            }
            if (this.onResource != 2) break block16;
            Object[] objectArray = this.focusSelection;
            int n = this.focusSelection.length;
            int n4 = 0;
            while (n4 < n) {
                Object element = objectArray[n4];
                if (element instanceof IResource) {
                    IResource parentResource = resource;
                    while (parentResource != null) {
                        if (parentResource.equals(element)) {
                            return true;
                        }
                        parentResource = parentResource.getParent();
                    }
                }
                ++n4;
            }
        }
        return false;
    }

    private boolean isEnclosed(IResource element) {
        if (this.workingSet == null) {
            return false;
        }
        if (this.workingSet.isEmpty()) {
            return true;
        }
        Set workingSetPaths = this.getWorkingSetAsSetOfPaths();
        return workingSetPaths.contains(element.getFullPath().toString());
    }

    public int getOnResource() {
        return this.onResource;
    }

    void setOnResource(int onResource) {
        if (onResource >= 0 && onResource <= 4) {
            this.onResource = onResource;
        }
    }

    Object[] getFocusObject() {
        return this.focusSelection;
    }

    public void setFocusSelection(Object[] objects) {
        this.focusSelection = objects;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List getRootTypes() {
        return this.rootTypes;
    }

    public List getSelectedTypes() {
        return this.selectedTypes;
    }

    public MarkerType getMarkerType(String id) {
        return MarkerTypesModel.getInstance().getType(id);
    }

    IWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    void setWorkingSet(IWorkingSet workingSet) {
        this.workingSet = workingSet;
        this.cachedWorkingSet = null;
    }

    void resetState() {
        this.enabled = true;
        this.onResource = 0;
        this.selectedTypes.clear();
        this.addAllSubTypes(this.selectedTypes);
        this.setWorkingSet(null);
    }

    public final void restoreState(IMemento memento) {
        this.resetState();
        this.restoreFilterSettings(memento);
    }

    public void restoreFilterSettings(IDialogSettings settings) {
        this.resetState();
        String setting = settings.get(TAG_ENABLED);
        if (setting != null) {
            this.enabled = Boolean.valueOf(setting);
        }
        if ((setting = settings.get(TAG_ON_RESOURCE)) != null) {
            try {
                this.onResource = Integer.parseInt(setting);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        if ((setting = settings.get(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList newTypes = new ArrayList();
            this.addAllSubTypes(newTypes);
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(id)) == null) continue;
                newTypes.remove(markerType);
                if (SELECTED_FALSE.equals(status) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int i = 0;
            while (i < newTypes.size()) {
                this.selectedTypes.add(newTypes.get(i));
                ++i;
            }
        } else {
            setting = settings.get(TAG_SELECTED_TYPES);
            if (setting != null) {
                this.generateSelectedTypes(setting);
            }
        }
        setting = settings.get(TAG_WORKING_SET);
        if (setting != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setting));
        }
    }

    void generateSelectedTypes(String selectedTypesValue) {
        this.selectedTypes.clear();
        StringTokenizer stringTokenizer = new StringTokenizer(selectedTypesValue);
        while (stringTokenizer.hasMoreTokens()) {
            MarkerType markerType = this.getMarkerType(stringTokenizer.nextToken(TAG_TYPES_DELIMITER));
            if (markerType == null || this.selectedTypes.contains(markerType)) continue;
            this.selectedTypes.add(markerType);
        }
    }

    MarkerType findMarkerType(String typeName) {
        return MarkerTypesModel.getInstance().getType(typeName);
    }

    protected void restoreFilterSettings(IMemento memento) {
        Integer resourceSetting;
        String setting = memento.getString(TAG_ENABLED);
        if (setting != null) {
            this.enabled = Boolean.valueOf(setting);
        }
        if ((resourceSetting = memento.getInteger(TAG_ON_RESOURCE)) != null) {
            this.onResource = resourceSetting;
        }
        if ((setting = memento.getString(TAG_SELECTION_STATUS)) != null) {
            this.selectedTypes.clear();
            ArrayList newTypes = new ArrayList();
            this.addAllSubTypes(newTypes);
            StringTokenizer stringTokenizer = new StringTokenizer(setting);
            while (stringTokenizer.hasMoreTokens()) {
                MarkerType markerType;
                String id = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                String status = null;
                if (stringTokenizer.hasMoreTokens()) {
                    status = stringTokenizer.nextToken(TAG_TYPES_DELIMITER);
                }
                if ((markerType = MarkerTypesModel.getInstance().getType(id)) == null) continue;
                newTypes.remove(markerType);
                if (SELECTED_FALSE.equals(status) || this.selectedTypes.contains(markerType)) continue;
                this.selectedTypes.add(markerType);
            }
            int i = 0;
            while (i < newTypes.size()) {
                this.selectedTypes.add(newTypes.get(i));
                ++i;
            }
        } else {
            setting = memento.getString(TAG_SELECTED_TYPES);
            if (setting != null) {
                this.generateSelectedTypes(setting);
            }
        }
        setting = memento.getString(TAG_WORKING_SET);
        if (setting != null) {
            this.setWorkingSet(PlatformUI.getWorkbench().getWorkingSetManager().getWorkingSet(setting));
        }
    }

    public void saveFilterSettings(IMemento settings) {
        settings.putString(TAG_ENABLED, String.valueOf(this.enabled));
        settings.putInteger(TAG_ON_RESOURCE, this.onResource);
        String markerTypeIds = "";
        ArrayList includedTypes = new ArrayList();
        this.addAllSubTypes(includedTypes);
        int i = 0;
        while (i < includedTypes.size()) {
            MarkerType markerType = (MarkerType)includedTypes.get(i);
            markerTypeIds = String.valueOf(markerTypeIds) + markerType.getId() + TAG_TYPES_DELIMITER;
            markerTypeIds = this.selectedTypes.contains(markerType) ? String.valueOf(markerTypeIds) + "true:" : String.valueOf(markerTypeIds) + "false:";
            ++i;
        }
        settings.putString(TAG_SELECTION_STATUS, markerTypeIds);
        if (this.workingSet != null) {
            settings.putString(TAG_WORKING_SET, this.workingSet.getName());
        }
    }

    public String getName() {
        return this.name;
    }

    public MarkerFilter makeClone() throws CloneNotSupportedException {
        return (MarkerFilter)this.clone();
    }

    public void setSelectedTypes(List selectedTypes) {
        this.selectedTypes = selectedTypes;
    }
}

