/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.sphinx.jdt.jobs.ConvertProjectToJavaProjectJob;
import org.eclipse.sphinx.jdt.util.JavaExtensions;
import org.eclipse.sphinx.pde.jobs.ConvertProjectToPluginProjectJob;
import org.eclipse.sphinx.platform.util.ExtendedPlatform;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.internal.messages.Messages;

public class ConvertToXtendXpandEnabledPluginProjectJob
extends WorkspaceJob {
    private static final String PROJECT_RELATIVE_JAVA_SOURCE_DEFAULT_PATH = "src";
    private static final String JAVA_EXTENSIONS_PACKAGE_DEFAULT_NAME = "extensions";
    private static final List<String> PDE_DEFAULT_REQUIRED_BUNDLES_IDS = Arrays.asList("org.eclipse.xtend.util.stdlib");
    private static final String PDE_EXECUTION_ENVIRONMENT_J2SE_15 = "J2SE-1.5";
    private static final String PDE_EXECUTION_ENVIRONMENT_JavaSE_16 = "JavaSE-1.6";
    private static final String PDE_EXECUTION_ENVIRONMENT_JavaSE_17 = "JavaSE-1.7";
    private static final String PDE_EXECUTION_ENVIRONMENT_JavaSE_18 = "JavaSE-1.8";
    private IProject project;
    private String projectRelativeJavaSourcePath = "src";
    private String compilerCompliance;
    private String javaExtensionsPackageName;
    private List<String> enabledMetaModelContributorTypeNames = null;

    public ConvertToXtendXpandEnabledPluginProjectJob(String name, IProject project) {
        super(name);
        this.project = project;
        this.compilerCompliance = JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.compliance");
        this.javaExtensionsPackageName = String.valueOf(project.getName().toLowerCase()) + "." + JAVA_EXTENSIONS_PACKAGE_DEFAULT_NAME;
        this.setPriority(40);
        this.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
    }

    public String getProjectRelativeJavaSourcePath() {
        return this.projectRelativeJavaSourcePath;
    }

    public void setProjectRelativeJavaSourcePath(String projectRelativeJavaSourcePath) {
        this.projectRelativeJavaSourcePath = projectRelativeJavaSourcePath;
    }

    public String getCompilerCompliance() {
        return this.compilerCompliance;
    }

    public void setCompilerCompliance(String compilerCompliance) {
        JavaExtensions.validateCompilerCompliance((String)compilerCompliance);
        this.compilerCompliance = compilerCompliance;
    }

    public String getJavaExtensionsPackageName() {
        return this.javaExtensionsPackageName;
    }

    public void setJavaExtensionsPackageName(String javaExtensionsPackageName) {
        this.javaExtensionsPackageName = javaExtensionsPackageName;
    }

    public List<String> getEnabledMetamodelContributorTypeNames() {
        if (this.enabledMetaModelContributorTypeNames == null) {
            this.enabledMetaModelContributorTypeNames = new ArrayList<String>();
        }
        return this.enabledMetaModelContributorTypeNames;
    }

    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToXtendXpandEnabledPluginProject, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            this.convertToJavaProject((IProgressMonitor)progress.newChild(30));
            this.convertToPluginProject((IProgressMonitor)progress.newChild(35));
            this.convertToXtendXpandProject((IProgressMonitor)progress.newChild(35));
        }
        catch (OperationCanceledException operationCanceledException) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
        }
        return Status.OK_STATUS;
    }

    protected void convertToJavaProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToJavaProject, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            ConvertProjectToJavaProjectJob convertProjectToJavaProjectJob = new ConvertProjectToJavaProjectJob(this.project);
            convertProjectToJavaProjectJob.runInWorkspace((IProgressMonitor)progress);
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
            throw new CoreException(status);
        }
    }

    protected void convertToPluginProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToPluginProject, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            ConvertProjectToPluginProjectJob convertProjectToPluginOperation = new ConvertProjectToPluginProjectJob(Collections.singletonList(this.project), this.getRequiredBundleIds(), this.getRequiredExecutionEnvironment());
            convertProjectToPluginOperation.runInWorkspace((IProgressMonitor)progress);
        }
        catch (Exception ex) {
            IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
            throw new CoreException(status);
        }
    }

    protected void convertToXtendXpandProject(IProgressMonitor monitor) throws CoreException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_ConvertingToXtendXpandProject, (int)3);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        if (!this.project.hasNature("org.eclipse.xtend.shared.ui.xtendXPandNature")) {
            ExtendedPlatform.addNature((IProject)this.project, (String)"org.eclipse.xtend.shared.ui.xtendXPandNature", (IProgressMonitor)progress.newChild(1));
        }
        if (!this.getEnabledMetamodelContributorTypeNames().isEmpty()) {
            StringBuilder enabledMetaModelContributorTypeNamesStr = new StringBuilder();
            Iterator<String> iter = this.getEnabledMetamodelContributorTypeNames().iterator();
            while (iter.hasNext()) {
                String contributorTypeName = iter.next();
                enabledMetaModelContributorTypeNamesStr.append(contributorTypeName);
                if (!iter.hasNext()) continue;
                enabledMetaModelContributorTypeNamesStr.append(",");
            }
            IEclipsePreferences prefs = new ProjectScope(this.project).getNode("org.eclipse.xtend.shared.ui");
            prefs.put("project.specific.metamodel", Boolean.TRUE.toString());
            prefs.put("metamodelContributor", enabledMetaModelContributorTypeNamesStr.toString());
            try {
                prefs.flush();
            }
            catch (Exception ex) {
                IStatus status = StatusUtil.createErrorStatus((Plugin)Activator.getDefault(), (Object)ex);
                throw new CoreException(status);
            }
        }
        progress.worked(1);
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IPackageFragmentRoot rootPackageFragmentRoot = javaProject.getPackageFragmentRoot((IResource)this.project.getFolder(this.getProjectRelativeJavaSourcePath()));
        rootPackageFragmentRoot.createPackageFragment(this.getJavaExtensionsPackageName(), true, (IProgressMonitor)progress.newChild(1));
    }

    protected List<String> getRequiredBundleIds() {
        return new ArrayList<String>(PDE_DEFAULT_REQUIRED_BUNDLES_IDS);
    }

    protected String getRequiredExecutionEnvironment() {
        String requiredExecutionEnvironment = null;
        String compilerCompliance = this.getCompilerCompliance();
        if ("1.5".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_J2SE_15;
        } else if ("1.6".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_JavaSE_16;
        } else if ("1.7".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_JavaSE_17;
        } else if ("1.8".equals(compilerCompliance)) {
            requiredExecutionEnvironment = PDE_EXECUTION_ENVIRONMENT_JavaSE_18;
        }
        return requiredExecutionEnvironment;
    }
}

