/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.handlers;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sphinx.emf.splitting.IModelSplitOperation;
import org.eclipse.sphinx.emf.splitting.IModelSplitPolicy;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.operations.BasicModelSplitOperation;
import org.eclipse.sphinx.platform.jobs.WorkspaceOperationWorkspaceJob;
import org.eclipse.sphinx.platform.operations.IWorkspaceOperation;
import org.eclipse.sphinx.platform.ui.operations.RunnableWithProgressAdapter;
import org.eclipse.sphinx.platform.ui.util.ExtendedPlatformUI;
import org.eclipse.sphinx.platform.ui.util.SelectionUtil;
import org.eclipse.ui.handlers.HandlerUtil;

public class BasicModelSplitHandler
extends AbstractHandler {
    protected URI resourceURI;
    protected IModelSplitPolicy modelSplitPolicy;
    private boolean runInBackground;

    public BasicModelSplitHandler(IModelSplitPolicy modelSplitPolicy) {
        Assert.isNotNull((Object)modelSplitPolicy);
        this.modelSplitPolicy = modelSplitPolicy;
        this.setRunInBackground(false);
    }

    public boolean isRunInBackground() {
        return this.runInBackground;
    }

    public void setRunInBackground(boolean runInBackground) {
        this.runInBackground = runInBackground;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        Object selected;
        this.resourceURI = null;
        if (selection.size() == 1 && (selected = selection.getFirstElement()) instanceof IFile) {
            this.resourceURI = EcorePlatformUtil.createURI((IPath)((IFile)selected).getFullPath());
        }
        return this.resourceURI != null;
    }

    protected IModelSplitOperation createModelSplitOperation() {
        return new BasicModelSplitOperation(this.resourceURI, this.modelSplitPolicy);
    }

    protected WorkspaceOperationWorkspaceJob createWorkspaceOperationJob(IModelSplitOperation operation) {
        return new WorkspaceOperationWorkspaceJob((IWorkspaceOperation)operation);
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        IStructuredSelection selection = SelectionUtil.getStructuredSelection((ISelection)HandlerUtil.getActiveMenuSelection((ExecutionEvent)event));
        if (!this.updateSelection(selection)) {
            return null;
        }
        IModelSplitOperation operation = this.createModelSplitOperation();
        if (this.isRunInBackground()) {
            WorkspaceOperationWorkspaceJob job = this.createWorkspaceOperationJob(operation);
            job.schedule();
        } else {
            try {
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(ExtendedPlatformUI.getActiveShell());
                dialog.run(true, true, (IRunnableWithProgress)new RunnableWithProgressAdapter((IWorkspaceOperation)operation));
            }
            catch (InterruptedException dialog) {
            }
            catch (InvocationTargetException ex) {
                throw new ExecutionException(ex.getMessage(), (Throwable)ex);
            }
        }
        return null;
    }
}

