/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.ITreeViewerState;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.TreeViewerState;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.ITreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TreeElementStateProviderFactory;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.navigator.IMementoAware;

public class TreeViewerStateRecorder
implements IMementoAware {
    protected TreeViewer viewer;
    protected ITreeViewerState deferredState;

    public void setViewer(TreeViewer viewer) {
        this.viewer = viewer;
    }

    public ITreeViewerState getDeferredState() {
        return this.deferredState;
    }

    protected void setDeferredState(ITreeViewerState deferredState) {
        if (deferredState != null) {
            for (ITreeElementStateProvider provider : deferredState.getExpandedElements()) {
                if (!provider.canUnderlyingModelBeLoaded() || provider.isUnderlyingModelLoaded()) continue;
                provider.loadUnderlyingModel();
            }
        }
        this.deferredState = deferredState != null && !deferredState.isEmpty() ? deferredState : null;
    }

    public void restoreState(IMemento memento) {
        if (memento != null) {
            IMemento selectedMemento;
            int n;
            TreeViewerState state = new TreeViewerState();
            TreeElementStateProviderFactory factory = new TreeElementStateProviderFactory(this.viewer);
            IMemento expandedMemento = memento.getChild(TreeElementStateProviderFactory.MEMENTO_TYPE_GROUP_EXPANDED);
            if (expandedMemento != null) {
                IMemento[] iMementoArray = expandedMemento.getChildren();
                n = iMementoArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IMemento elementMemento = iMementoArray[n2];
                    ITreeElementStateProvider provider = factory.createFromMemento(elementMemento);
                    if (provider != null) {
                        state.getExpandedElements().add(provider);
                    }
                    ++n2;
                }
            }
            if ((selectedMemento = memento.getChild(TreeElementStateProviderFactory.MEMENTO_TYPE_GROUP_SELECTED)) != null) {
                IMemento[] iMementoArray = selectedMemento.getChildren();
                int n3 = iMementoArray.length;
                n = 0;
                while (n < n3) {
                    IMemento elementMemento = iMementoArray[n];
                    ITreeElementStateProvider provider = factory.createFromMemento(elementMemento);
                    if (provider != null) {
                        state.getSelectedElements().add(provider);
                    }
                    ++n;
                }
            }
            this.applyState(state);
        }
    }

    public boolean canApplyState() {
        return this.viewer != null && this.viewer.getInput() != null;
    }

    public void applyState(ITreeViewerState state) {
        if (this.canApplyState() && state != null && !state.isEmpty() && !state.isApplying()) {
            ITreeElementStateProvider provider;
            state.setApplying(true);
            ArrayList<ITreeElementStateProvider> expandableProviders = new ArrayList<ITreeElementStateProvider>();
            Iterator<ITreeElementStateProvider> iter = state.getExpandedElements().iterator();
            while (iter.hasNext()) {
                ITreeElementStateProvider provider2 = iter.next();
                if (provider2.hasUnderlyingModel() && !provider2.isUnderlyingModelLoaded()) continue;
                expandableProviders.add(provider2);
                iter.remove();
            }
            int i = expandableProviders.size();
            while (!expandableProviders.isEmpty() && i > 0) {
                iter = expandableProviders.iterator();
                while (iter.hasNext()) {
                    provider = iter.next();
                    if (!provider.isResolved()) continue;
                    if (provider.isStale()) {
                        iter.remove();
                        continue;
                    }
                    if (!provider.canBeExpanded()) {
                        iter.remove();
                        continue;
                    }
                    if (!provider.isExpanded()) continue;
                    iter.remove();
                }
                this.setExpandedElements(expandableProviders);
                --i;
            }
            ArrayList<ITreeElementStateProvider> selectableProviders = new ArrayList<ITreeElementStateProvider>();
            iter = state.getSelectedElements().iterator();
            while (iter.hasNext()) {
                provider = iter.next();
                if (provider.hasUnderlyingModel() && !provider.isUnderlyingModelLoaded()) continue;
                selectableProviders.add(provider);
                iter.remove();
            }
            this.setSelectedElements(selectableProviders);
            state.setApplying(false);
        }
        this.setDeferredState(state);
    }

    protected void setExpandedElements(List<ITreeElementStateProvider> expandableProviders) {
        for (ITreeElementStateProvider provider : expandableProviders) {
            try {
                Object element = provider.getTreeElement();
                if (element == null) continue;
                this.viewer.setExpandedState(element, true);
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }

    protected void setSelectedElements(List<ITreeElementStateProvider> selectableProviders) {
        ArrayList<Object> selectableElements = new ArrayList<Object>();
        for (ITreeElementStateProvider provider : selectableProviders) {
            Object element = provider.getTreeElement();
            if (element == null) continue;
            selectableElements.add(element);
        }
        if (!selectableElements.isEmpty()) {
            try {
                this.viewer.setSelection((ISelection)new StructuredSelection(selectableElements));
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)ex);
            }
        }
    }

    public boolean canRecordState() {
        return this.viewer != null;
    }

    public ITreeViewerState recordState() {
        if (this.canRecordState()) {
            Object[] selectedElements;
            int n;
            TreeViewerState state = new TreeViewerState();
            TreeElementStateProviderFactory factory = new TreeElementStateProviderFactory(this.viewer);
            TreePath[] expandedTreePaths = this.viewer.getExpandedTreePaths();
            if (expandedTreePaths.length > 0) {
                TreePath[] treePathArray = expandedTreePaths;
                n = expandedTreePaths.length;
                int n2 = 0;
                while (n2 < n) {
                    TreePath expandedTreePath = treePathArray[n2];
                    ITreeElementStateProvider provider = factory.create(expandedTreePath);
                    if (provider != null) {
                        state.getExpandedElements().add(provider);
                    }
                    ++n2;
                }
            }
            if ((selectedElements = ((IStructuredSelection)this.viewer.getSelection()).toArray()).length > 0) {
                Object[] objectArray = selectedElements;
                int n3 = selectedElements.length;
                n = 0;
                while (n < n3) {
                    Object selectedElement = objectArray[n];
                    ITreeElementStateProvider provider = factory.create(selectedElement);
                    if (provider != null) {
                        state.getSelectedElements().add(provider);
                    }
                    ++n;
                }
            }
            return state;
        }
        return null;
    }

    public void saveState(IMemento memento) {
        ITreeViewerState state;
        if (memento != null && (state = this.recordState()) != null && !state.isEmpty()) {
            if (!state.getExpandedElements().isEmpty()) {
                IMemento expandedMemento = memento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_GROUP_EXPANDED);
                for (ITreeElementStateProvider provider : state.getExpandedElements()) {
                    provider.appendToMemento(expandedMemento);
                }
            }
            if (!state.getSelectedElements().isEmpty()) {
                IMemento selectedMemento = memento.createChild(TreeElementStateProviderFactory.MEMENTO_TYPE_GROUP_SELECTED);
                for (ITreeElementStateProvider provider : state.getSelectedElements()) {
                    provider.appendToMemento(selectedMemento);
                }
            }
        }
    }
}

