/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.emf.transaction.RunnableWithResult;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.util.TransactionUtil;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ITreePathContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.sphinx.emf.edit.TransientItemProvider;
import org.eclipse.sphinx.emf.util.EcoreResourceUtil;
import org.eclipse.sphinx.emf.workspace.ui.internal.Activator;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.EObjectElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.FileElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.FolderElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.ITreeElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.ProjectElementStateProvider;
import org.eclipse.sphinx.emf.workspace.ui.viewers.state.providers.TransientElementStateProvider;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.ui.IMemento;

public class TreeElementStateProviderFactory {
    public static final String MEMENTO_TYPE_GROUP_SELECTED = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".selected";
    public static final String MEMENTO_TYPE_GROUP_EXPANDED = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".expanded";
    public static final String MEMENTO_TYPE_ELEMENT_PROJECT = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".project";
    public static final String MEMENTO_TYPE_ELEMENT_FOLDER = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".folder";
    public static final String MEMENTO_TYPE_ELEMENT_FILE = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".file";
    public static final String MEMENTO_TYPE_ELEMENT_EOBJECT = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".eObject";
    public static final String MEMENTO_TYPE_ELEMENT_TRANSIENT = String.valueOf(Activator.getPlugin().getSymbolicName()) + ".transient";
    public static final String MEMENTO_KEY_NAME = "name";
    public static final String MEMENTO_KEY_PATH = "path";
    public static final String MEMENTO_KEY_URI = "uri";
    public static final String MEMENTO_KEY_PARENT_URI = "parentURI";
    public static final String MEMENTO_KEY_TRANSIENT_CHILDREN = "transientChildren";
    private TreeViewer viewer;

    public TreeElementStateProviderFactory(TreeViewer viewer) {
        Assert.isNotNull((Object)viewer);
        this.viewer = viewer;
    }

    public ITreeElementStateProvider create(Object element) {
        return this.create(this.getParentPath(element), element);
    }

    public ITreeElementStateProvider create(TreePath treePath) {
        Assert.isNotNull((Object)treePath);
        return this.create(treePath.getParentPath(), treePath.getLastSegment());
    }

    protected ITreeElementStateProvider create(TreePath parentPath, Object element) {
        Assert.isNotNull((Object)(parentPath != null ? 1 : 0));
        if (element instanceof IProject) {
            return new ProjectElementStateProvider(this.viewer, (IProject)element);
        }
        if (element instanceof IFolder) {
            return new FolderElementStateProvider(this.viewer, (IFolder)element);
        }
        if (element instanceof IFile) {
            return new FileElementStateProvider(this.viewer, (IFile)element);
        }
        if (element instanceof EObject) {
            URI uri = this.getURI((EObject)element);
            return new EObjectElementStateProvider(this.viewer, uri);
        }
        if (this.isTransientElement(element)) {
            Object eObjectParent = null;
            ArrayList<Object> transientChildren = new ArrayList<Object>();
            transientChildren.add(element);
            int i = parentPath.getSegmentCount() - 1;
            while (i >= 0) {
                Object parent = parentPath.getSegment(i);
                if (!this.isTransientElement(parent)) {
                    eObjectParent = parent;
                    break;
                }
                transientChildren.add(parent);
                --i;
            }
            Collections.reverse(transientChildren);
            if (eObjectParent instanceof EObject) {
                URI eObjectParentURI = this.getURI((EObject)eObjectParent);
                return this.createTransientElementProvider(eObjectParentURI, transientChildren);
            }
        }
        return null;
    }

    public ITreeElementStateProvider createFromMemento(IMemento elementMemento) {
        if (MEMENTO_TYPE_ELEMENT_PROJECT.equals(elementMemento.getType())) {
            return new ProjectElementStateProvider(this.viewer, elementMemento);
        }
        if (MEMENTO_TYPE_ELEMENT_FOLDER.equals(elementMemento.getType())) {
            return new FolderElementStateProvider(this.viewer, elementMemento);
        }
        if (MEMENTO_TYPE_ELEMENT_FILE.equals(elementMemento.getType())) {
            return new FileElementStateProvider(this.viewer, elementMemento);
        }
        if (MEMENTO_TYPE_ELEMENT_EOBJECT.equals(elementMemento.getType())) {
            return new EObjectElementStateProvider(this.viewer, elementMemento);
        }
        if (MEMENTO_TYPE_ELEMENT_TRANSIENT.equals(elementMemento.getType())) {
            return this.createTransientElementStateProvider(elementMemento);
        }
        return null;
    }

    protected boolean isTransientElement(Object element) {
        return element instanceof TransientItemProvider || element instanceof IWrapperItemProvider;
    }

    protected TransientElementStateProvider createTransientElementProvider(URI eObjectParentURI, List<Object> transientChildren) {
        return new TransientElementStateProvider(this.viewer, eObjectParentURI, transientChildren);
    }

    protected TransientElementStateProvider createTransientElementStateProvider(IMemento elementMemento) {
        return new TransientElementStateProvider(this.viewer, elementMemento);
    }

    protected TreePath getParentPath(Object element) {
        TreePath[] parents;
        IContentProvider contentProvider = this.viewer.getContentProvider();
        if (contentProvider instanceof ITreePathContentProvider && (parents = ((ITreePathContentProvider)contentProvider).getParents(element)).length > 0) {
            return parents[0];
        }
        return TreePath.EMPTY;
    }

    protected URI getURI(final EObject eObject) {
        if (eObject != null) {
            TransactionalEditingDomain editingDomain = TransactionUtil.getEditingDomain((EObject)eObject);
            if (editingDomain != null) {
                try {
                    return (URI)TransactionUtil.runExclusive((TransactionalEditingDomain)editingDomain, (RunnableWithResult)new RunnableWithResult.Impl<URI>(){

                        public void run() {
                            this.setResult(EcoreResourceUtil.getURI((EObject)eObject, (boolean)true));
                        }
                    });
                }
                catch (InterruptedException ex) {
                    PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
                }
            } else {
                return EcoreResourceUtil.getURI((EObject)eObject, (boolean)true);
            }
        }
        return null;
    }
}

