/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.xtendxpand.jobs;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.sphinx.platform.IExtendedPlatformConstants;
import org.eclipse.sphinx.platform.util.StatusUtil;
import org.eclipse.sphinx.xtendxpand.internal.Activator;
import org.eclipse.sphinx.xtendxpand.jobs.CheckJob;
import org.eclipse.sphinx.xtendxpand.jobs.XtendJob;

public class M2MJob
extends Job {
    private CheckJob checkJob;
    private XtendJob xtendJob;

    public M2MJob(String name, XtendJob xtendJob) {
        this(name, xtendJob, null);
    }

    public M2MJob(String name, XtendJob xtendJob, CheckJob checkJob) {
        super(name);
        this.xtendJob = xtendJob;
        this.checkJob = checkJob;
    }

    public IStatus run(IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        try {
            IStatus status;
            if (this.checkJob != null && ((status = this.checkJob.run((IProgressMonitor)progress.newChild(50))).getSeverity() == 4 || progress.isCanceled())) {
                throw new OperationCanceledException();
            }
            return this.xtendJob.run((IProgressMonitor)progress.newChild(50));
        }
        catch (OperationCanceledException ex) {
            return Status.CANCEL_STATUS;
        }
        catch (Exception ex) {
            return StatusUtil.createErrorStatus((Plugin)Activator.getPlugin(), (Object)ex);
        }
    }

    public boolean belongsTo(Object family) {
        return IExtendedPlatformConstants.FAMILY_LONG_RUNNING.equals(family);
    }

    public CheckJob getCheckJob() {
        return this.checkJob;
    }

    public XtendJob getXtendJob() {
        return this.xtendJob;
    }
}

