/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.serialization.generators.xsd;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EEnumLiteral;
import org.eclipse.emf.ecore.ENamedElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.MetaModelDescriptorRegistry;
import org.eclipse.sphinx.emf.serialization.XMLPersistenceMappingExtendedMetaData;
import org.eclipse.sphinx.emf.serialization.generators.util.Ecore2XSDUtil;
import org.eclipse.sphinx.emf.serialization.generators.util.IGeneratorConstants;
import org.eclipse.sphinx.emf.serialization.generators.util.JavaXSDPrimitiveTypeMapping;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.xsd.XSDAttributeDeclaration;
import org.eclipse.xsd.XSDAttributeUse;
import org.eclipse.xsd.XSDAttributeUseCategory;
import org.eclipse.xsd.XSDComplexTypeContent;
import org.eclipse.xsd.XSDComplexTypeDefinition;
import org.eclipse.xsd.XSDCompositor;
import org.eclipse.xsd.XSDDerivationMethod;
import org.eclipse.xsd.XSDElementDeclaration;
import org.eclipse.xsd.XSDEnumerationFacet;
import org.eclipse.xsd.XSDFactory;
import org.eclipse.xsd.XSDForm;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDModelGroup;
import org.eclipse.xsd.XSDModelGroupDefinition;
import org.eclipse.xsd.XSDParticle;
import org.eclipse.xsd.XSDParticleContent;
import org.eclipse.xsd.XSDPatternFacet;
import org.eclipse.xsd.XSDProcessContents;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;
import org.eclipse.xsd.XSDTypeDefinition;
import org.eclipse.xsd.XSDWildcard;
import org.eclipse.xsd.ecore.NameMangler;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class Ecore2XSDFactory
extends NameMangler {
    protected String defaultXMLSchemaNamespace = "http://www.w3.org/2001/XMLSchema";
    protected String defaultXMLNamespace = "http://www.w3.org/XML/1998/namespace";
    protected XMLPersistenceMappingExtendedMetaData xsdExtendedMetaData = XMLPersistenceMappingExtendedMetaData.INSTANCE;
    protected static XSDFactory xsdFactory = XSDFactory.eINSTANCE;
    public Set<String> patternCaseSet = new HashSet<String>();
    public Set<EPackage> referencedEcores = new HashSet<EPackage>();
    public Map<String, String> nsSchemaLocations = new HashMap<String, String>();
    protected String defaultUserSchemaNamespace;
    public EPackage ecoreModel;
    private final HashMap<ArrayList<?>, XSDImport> _createCache_createXSDImport = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDComplexTypeDefinition> _createCache_createClassTypeDefinition5 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDSimpleTypeDefinition> _createCache_createEnumSchema6 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDSimpleTypeDefinition> _createCache_createSimpleType8 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0010 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0012 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0013 = CollectionLiterals.newHashMap();
    private final HashMap<ArrayList<?>, XSDParticle> _createCache_createXSDParticleForFeatureCase0023 = CollectionLiterals.newHashMap();

    public Ecore2XSDFactory(EPackage ecoreModel) {
        this.ecoreModel = ecoreModel;
    }

    public XSDSchema initSchema(EPackage ePackage, ResourceSet resourceSet, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        progress.subTask("Initialize XSD schema");
        XSDSchema xsdSchema = XSDFactory.eINSTANCE.createXSDSchema();
        String targetNamespace = this.xsdExtendedMetaData.getNamespace(ePackage);
        xsdSchema.setTargetNamespace(targetNamespace);
        Map namespaces = xsdSchema.getQNamePrefixToNamespaceMap();
        xsdSchema.setSchemaForSchemaQNamePrefix("xsd");
        namespaces.put("xsd", this.defaultXMLSchemaNamespace);
        String nsPrefix = this.getRootNsPrefix(ePackage);
        Ecore2XSDUtil.handlePrefix(namespaces, nsPrefix, targetNamespace);
        xsdSchema.setElementFormDefault(XSDForm.QUALIFIED_LITERAL);
        xsdSchema.setAttributeFormDefault(XSDForm.UNQUALIFIED_LITERAL);
        xsdSchema.updateElement();
        this.initSchemaImports(ePackage, xsdSchema, monitor);
        this.defaultUserSchemaNamespace = targetNamespace;
        progress.done();
        return xsdSchema;
    }

    protected void initSchemaImports(EPackage ePackage, final XSDSchema xsdSchema, IProgressMonitor monitor) {
        Map externalSchemaLocations = this.xsdExtendedMetaData.getXMLExternalSchemaLocations(ePackage);
        Set<EPackage> referencedEcores = this.getReferencedEcoreRootPackages(monitor);
        Consumer<EPackage> _function = new Consumer<EPackage>(){

            @Override
            public void accept(EPackage it) {
                String namespace = Ecore2XSDFactory.this.getGlobalXSDSchemaNamespace(it);
                String schemaLocation = Ecore2XSDFactory.this.getSchemaLocation(it);
                Ecore2XSDFactory.this.nsSchemaLocations.put(namespace, schemaLocation);
            }
        };
        referencedEcores.forEach(_function);
        this.nsSchemaLocations.putAll(externalSchemaLocations);
        ArrayList<String> orderedNs = new ArrayList<String>();
        orderedNs.addAll(this.nsSchemaLocations.keySet());
        Collections.sort(orderedNs);
        Consumer<String> _function_1 = new Consumer<String>(){

            @Override
            public void accept(String it) {
                xsdSchema.getContents().add((Object)Ecore2XSDFactory.this.createXSDImport(it, Ecore2XSDFactory.this.nsSchemaLocations.get(it)));
            }
        };
        orderedNs.forEach(_function_1);
    }

    protected String getRootNsPrefix(EPackage ePackage) {
        return ePackage.getNsPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDImport createXSDImport(String nameSpace, String schemaLocation) {
        XSDImport _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new String[]{nameSpace, schemaLocation});
        HashMap<ArrayList<?>, XSDImport> hashMap = this._createCache_createXSDImport;
        synchronized (hashMap) {
            XSDImport _createXSDImport;
            if (this._createCache_createXSDImport.containsKey(_cacheKey)) {
                return this._createCache_createXSDImport.get(_cacheKey);
            }
            _result = _createXSDImport = xsdFactory.createXSDImport();
            this._createCache_createXSDImport.put(_cacheKey, _result);
        }
        this._init_createXSDImport(_result, nameSpace, schemaLocation);
        return _result;
    }

    private void _init_createXSDImport(XSDImport xsdImport, String nameSpace, String schemaLocation) {
        xsdImport.setNamespace(nameSpace);
        xsdImport.setSchemaLocation(schemaLocation);
    }

    protected String getTypeXMLName(String xmlName, ENamedElement eElement) {
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)eElement);
        EPackage rootPackage = (EPackage)_rootContainer;
        String nsURI = rootPackage.getNsURI();
        boolean _equals = nsURI.equals(this.xsdExtendedMetaData.getNamespace(this.ecoreModel));
        if (_equals) {
            return xmlName;
        }
        boolean _equals_1 = nsURI.equals("http://www.eclipse.org/emf/2002/Ecore");
        if (_equals_1) {
            return xmlName;
        }
        boolean _contains = this.referencedEcores.contains(rootPackage);
        if (_contains) {
            String result = Ecore2XSDUtil.getSingularName(eElement);
            return result;
        }
        return Ecore2XSDUtil.getSingularName(eElement);
    }

    protected String getGlobalXSDSchemaNamespace(EPackage rootPackage) {
        try {
            boolean _notEquals;
            String namespace = rootPackage.getNsURI();
            java.net.URI namespaceURI = new java.net.URI(namespace);
            IMetaModelDescriptor mmDescriptor = MetaModelDescriptorRegistry.INSTANCE.getDescriptor(namespaceURI);
            boolean bl = _notEquals = !Objects.equal((Object)mmDescriptor, null);
            if (_notEquals) {
                namespace = mmDescriptor.getNamespaceURI().toString();
            }
            return namespace;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    protected String getSchemaLocation(EPackage referencedRootPackage) {
        String namespace = this.getGlobalXSDSchemaNamespace(referencedRootPackage);
        String schemaLocation = this.xsdExtendedMetaData.getXMLSchemaLocation(referencedRootPackage);
        boolean _equals = Objects.equal(null, (Object)schemaLocation);
        if (_equals) {
            boolean _equals_1 = namespace.equals("http://www.eclipse.org/emf/2002/Ecore");
            if (_equals_1) {
                schemaLocation = "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.xsd";
            } else {
                boolean _notEquals;
                URI uri = this.getXSDSchemaFileURIFromNsURI(namespace);
                boolean bl = _notEquals = !Objects.equal((Object)uri, null);
                if (_notEquals) {
                    schemaLocation = uri.toString();
                } else {
                    String _plus;
                    String _name = referencedRootPackage.getName();
                    schemaLocation = _plus = String.valueOf(_name) + "xsd";
                }
            }
        }
        return schemaLocation;
    }

    protected void loadImportReferencedXSD(EPackage referencedRootPackage, XSDSchema xsdSchema, ResourceSet resourceSet) {
        String namespace = this.getGlobalXSDSchemaNamespace(referencedRootPackage);
        String schemaLocation = this.xsdExtendedMetaData.getXMLSchemaLocation(referencedRootPackage);
        boolean _equals = Objects.equal(null, (Object)schemaLocation);
        if (_equals) {
            boolean _equals_1 = namespace.equals("http://www.eclipse.org/emf/2002/Ecore");
            if (_equals_1) {
                schemaLocation = "platform:/plugin/org.eclipse.emf.ecore/model/Ecore.xsd";
            } else {
                boolean _notEquals;
                URI uri = this.getXSDSchemaFileURIFromNsURI(namespace);
                boolean bl = _notEquals = !Objects.equal((Object)uri, null);
                if (_notEquals) {
                    schemaLocation = uri.toString();
                } else {
                    String _plus;
                    String _name = referencedRootPackage.getName();
                    schemaLocation = _plus = String.valueOf(_name) + "xsd";
                }
            }
        }
        XSDImport xsdImport = this.createXSDImport(namespace, schemaLocation);
        xsdSchema.getContents().add((Object)xsdImport);
    }

    protected URI getXSDSchemaFileURIFromNsURI(String nsURI) {
        Path path = new Path("C:/Work/Eclipse-Kepler/runtime-EclipseApplication-Kepler/xsd.generator.test/model/referenced/hummingbird20.xsd");
        return EcorePlatformUtil.createURI((IPath)path);
    }

    protected Set<EPackage> getReferencedEcoreRootPackages(IProgressMonitor monitor) {
        final SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        final String targetNamespace = this.xsdExtendedMetaData.getNamespace(this.ecoreModel);
        Procedures.Procedure1<EObject> _function = new Procedures.Procedure1<EObject>(){

            public void apply(EObject it) {
                EClassifier eType;
                EObject container;
                if (it instanceof EClass) {
                    Consumer<EClass> _function = new Consumer<EClass>(){

                        @Override
                        public void accept(EClass it) {
                            boolean _notEquals;
                            EObject _rootContainer = EcoreUtil.getRootContainer((EObject)it);
                            EPackage rootEPackage = (EPackage)_rootContainer;
                            String uri = rootEPackage.getNsURI();
                            boolean bl = _notEquals = !Objects.equal((Object)uri, (Object)targetNamespace);
                            if (_notEquals) {
                                (this).Ecore2XSDFactory.this.referencedEcores.add(rootEPackage);
                            }
                        }
                    };
                    ((EClass)it).getESuperTypes().forEach((Consumer)_function);
                } else if (it instanceof EStructuralFeature && (container = EcoreUtil.getRootContainer((EObject)(eType = ((EStructuralFeature)it).getEType()))) instanceof EPackage) {
                    boolean _notEquals;
                    String uri = ((EPackage)container).getNsURI();
                    boolean bl = _notEquals = !Objects.equal((Object)uri, (Object)targetNamespace);
                    if (_notEquals && !uri.equals("http://www.eclipse.org/emf/2002/Ecore") && !"http://www.eclipse.org/emf/2003/XMLType".equals(uri)) {
                        Ecore2XSDFactory.this.referencedEcores.add((EPackage)container);
                    }
                }
                progress.worked(1);
                boolean _isCanceled = progress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        IteratorExtensions.forEach((Iterator)this.ecoreModel.eAllContents(), (Procedures.Procedure1)_function);
        return this.referencedEcores;
    }

    protected String getElementXSDURI(EClassifier eClassifier) {
        boolean _notEquals;
        EObject _rootContainer = EcoreUtil.getRootContainer((EObject)eClassifier);
        EPackage rootEPackage = (EPackage)_rootContainer;
        String namespace = this.xsdExtendedMetaData.getNamespace(rootEPackage);
        String result = this.xsdExtendedMetaData.getXMLName(eClassifier);
        result = this.getTypeXMLName(result, (ENamedElement)eClassifier);
        boolean bl = _notEquals = !Objects.equal((Object)namespace, null);
        if (_notEquals) {
            result = String.valueOf(namespace) + "#" + result;
        }
        return result;
    }

    protected String getQualifiedRootPackageName(EPackage ePackage) {
        return this.ecoreModel.getName();
    }

    protected List<EStructuralFeature> getEAllRelevantStructuralFeatures(EClass eClass) {
        return eClass.getEAllStructuralFeatures();
    }

    public void createGlobalElement3(EPackage rootEPackageModel, final XSDSchema xsdSchema) {
        List<EClassifier> globalEClassifiers = Ecore2XSDUtil.getGlobalElements(rootEPackageModel);
        Consumer<EClassifier> _function = new Consumer<EClassifier>(){

            @Override
            public void accept(EClassifier it) {
                XSDElementDeclaration xsdGlobalElement = xsdFactory.createXSDElementDeclaration();
                xsdGlobalElement.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName(it));
                String uri = Ecore2XSDFactory.this.getElementXSDURI(it);
                XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
                xsdGlobalElement.setTypeDefinition(xsdTypeDefinition);
                xsdSchema.getContents().add((Object)xsdGlobalElement);
            }
        };
        globalEClassifiers.forEach(_function);
    }

    public void createFixedRefTypes4(XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition simpleTypeLocal = xsdFactory.createXSDSimpleTypeDefinition();
        simpleTypeLocal.setName("LOCAL-REF");
        XSDTypeDefinition baseTypeLocal = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#IDREF");
        simpleTypeLocal.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseTypeLocal);
        xsdSchema.getContents().add((Object)simpleTypeLocal);
        XSDSimpleTypeDefinition simpleTypeGlobal = xsdFactory.createXSDSimpleTypeDefinition();
        simpleTypeGlobal.setName("GLOBAL-REF");
        XSDTypeDefinition baseTypeGlobal = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        simpleTypeGlobal.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseTypeGlobal);
        xsdSchema.getContents().add((Object)simpleTypeGlobal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDComplexTypeDefinition createClassTypeDefinition5(EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass, IProgressMonitor monitor) {
        XSDComplexTypeDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new Object[]{eClass, xsdSchema, referencedClass, monitor});
        HashMap<ArrayList<?>, XSDComplexTypeDefinition> hashMap = this._createCache_createClassTypeDefinition5;
        synchronized (hashMap) {
            XSDComplexTypeDefinition _createXSDComplexTypeDefinition;
            if (this._createCache_createClassTypeDefinition5.containsKey(_cacheKey)) {
                return this._createCache_createClassTypeDefinition5.get(_cacheKey);
            }
            _result = _createXSDComplexTypeDefinition = xsdFactory.createXSDComplexTypeDefinition();
            this._createCache_createClassTypeDefinition5.put(_cacheKey, _result);
        }
        this._init_createClassTypeDefinition5(_result, eClass, xsdSchema, referencedClass, monitor);
        return _result;
    }

    private void _init_createClassTypeDefinition5(final XSDComplexTypeDefinition xsdComplexTypeDefinition, final EClass eClass, final XSDSchema xsdSchema, final ArrayList<EClass> referencedClass, IProgressMonitor monitor) {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        boolean _isCanceled = progress.isCanceled();
        if (_isCanceled) {
            throw new OperationCanceledException();
        }
        String _name = eClass.getName();
        String _plus = "create XSD Complex Type Definition for " + _name;
        progress.subTask(_plus);
        xsdComplexTypeDefinition.setName(this.xsdExtendedMetaData.getXMLName((EClassifier)eClass));
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle);
        final XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        xsdParticle.setContent((XSDParticleContent)xsdModelGroup);
        List<EStructuralFeature> relevantStructuralFeatures = this.getEAllRelevantStructuralFeatures(eClass);
        final SubMonitor subProgress = progress.newChild(100).setWorkRemaining(relevantStructuralFeatures.size());
        Consumer<EStructuralFeature> _function = new Consumer<EStructuralFeature>(){

            @Override
            public void accept(EStructuralFeature it) {
                XSDParticle xsdParticleForFeature = null;
                boolean _equals = Integer.valueOf(4).equals(ExtendedMetaData.INSTANCE.getFeatureKind(it));
                if (_equals) {
                    boolean _notEquals;
                    if (it instanceof EAttribute) {
                        XSDParticle _switchResult = null;
                        int _xMLPersistenceMappingStrategy = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                        switch (_xMLPersistenceMappingStrategy) {
                            case 4: {
                                _switchResult = Ecore2XSDFactory.this.createClassElementAttribute5a((EAttribute)it, xsdSchema);
                                break;
                            }
                            case 12: {
                                _switchResult = Ecore2XSDFactory.this.createEAttributeContained1100((EAttribute)it, xsdSchema);
                                break;
                            }
                            default: {
                                Object _xblockexpression = null;
                                int _xMLPersistenceMappingStrategy_1 = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                                String _plus = "Not supported: EAttribute " + Integer.valueOf(_xMLPersistenceMappingStrategy_1);
                                System.err.println(_plus);
                                _xblockexpression = null;
                                _switchResult = _xblockexpression;
                            }
                        }
                        xsdParticleForFeature = _switchResult;
                    } else if (it instanceof EReference) {
                        boolean _isContainment = ((EReference)it).isContainment();
                        if (_isContainment) {
                            XSDParticle _switchResult_1 = null;
                            int _xMLPersistenceMappingStrategy_1 = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                            switch (_xMLPersistenceMappingStrategy_1) {
                                case 4: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained0100(it, eClass, xsdSchema);
                                    break;
                                }
                                case 5: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained0101(it, eClass, xsdSchema);
                                    break;
                                }
                                case 9: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained1001(it, eClass, xsdSchema);
                                    break;
                                }
                                case 12: {
                                    _switchResult_1 = Ecore2XSDFactory.this.create_EReference_contained1100(it, eClass, xsdSchema);
                                    break;
                                }
                                default: {
                                    _switchResult_1 = null;
                                }
                            }
                            xsdParticleForFeature = _switchResult_1;
                        } else {
                            XSDParticle _switchResult_2 = null;
                            int _xMLPersistenceMappingStrategy_2 = Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(it);
                            switch (_xMLPersistenceMappingStrategy_2) {
                                case 9: {
                                    _switchResult_2 = Ecore2XSDFactory.this.createClassComposition5b(it, eClass);
                                    break;
                                }
                                case 12: {
                                    _switchResult_2 = Ecore2XSDFactory.this.create_EReference_referenced1100Many_5l(it, eClass, xsdSchema, referencedClass);
                                    break;
                                }
                                case 4: {
                                    _switchResult_2 = Ecore2XSDFactory.this.create_EReference_referenced0100Many_5m(it, eClass, xsdSchema, referencedClass);
                                    break;
                                }
                                default: {
                                    _switchResult_2 = null;
                                }
                            }
                            xsdParticleForFeature = _switchResult_2;
                        }
                    }
                    boolean bl = _notEquals = !Objects.equal(null, xsdParticleForFeature);
                    if (_notEquals) {
                        xsdModelGroup.getContents().add(xsdParticleForFeature);
                    }
                } else {
                    boolean _equals_1 = Integer.valueOf(2).equals(ExtendedMetaData.INSTANCE.getFeatureKind(it));
                    if (_equals_1 && it instanceof EAttribute) {
                        XSDAttributeUse xsdAttributeUse = Ecore2XSDFactory.this.createClassAttribute5d((EAttribute)it, eClass, xsdSchema);
                        xsdComplexTypeDefinition.getAttributeContents().add((Object)xsdAttributeUse);
                    }
                }
                subProgress.worked(1);
                boolean _isCanceled = subProgress.isCanceled();
                if (_isCanceled) {
                    throw new OperationCanceledException();
                }
            }
        };
        relevantStructuralFeatures.forEach(_function);
        xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
    }

    public XSDParticle createClassElementAttribute5a(EAttribute eAttribute, XSDSchema xsdSchema) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        xsdParticle.setMinOccurs(eAttribute.getLowerBound());
        xsdParticle.setMaxOccurs(eAttribute.getUpperBound());
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLName((EStructuralFeature)eAttribute));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        EDataType baseType = eAttribute.getEAttributeType();
        if (baseType instanceof EDataType && this.isXMLPrimitiveXsdType(baseType).booleanValue()) {
            String xsdSimpleType = this.getXsdSimpleType((EClassifier)baseType);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            String uri = this.getElementXSDURI((EClassifier)baseType);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement.setTypeDefinition(xsdTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle createEAttributeContained1100(EAttribute eAttribute, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = eAttribute.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLWrapperName((EStructuralFeature)eAttribute));
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(eAttribute.getUpperBound());
        xsdParticle2.setMinOccurs(eAttribute.getLowerBound());
        XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EDataType datatype = eAttribute.getEAttributeType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getXMLName((EStructuralFeature)eAttribute));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        Boolean _isXMLPrimitiveXsdType = this.isXMLPrimitiveXsdType(datatype);
        if (_isXMLPrimitiveXsdType.booleanValue()) {
            String xsdSimpleType = this.getXsdSimpleType((EClassifier)datatype);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            String uri = this.getElementXSDURI((EClassifier)datatype);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle createClassComposition5b(EStructuralFeature feature, EClass eClass) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLName(feature));
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(feature.getUpperBound());
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeeClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName("xxxxxxxx");
        String typeeClassifierURI = this.getElementXSDURI(typeeClassifier);
        XSDTypeDefinition xsdTypeDefinition = xsdElement2.resolveTypeDefinitionURI(typeeClassifierURI);
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        if (typeeClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    xsdElementSubType.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it));
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeeClassifier).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_contained1001(final EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLWrapperName(feature));
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(feature.getUpperBound());
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String subClassXMLName = Ecore2XSDFactory.this.getTypeXMLName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it, feature), (ENamedElement)it);
                    xsdElementSubType.setName(subClassXMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findAllConcreteTypes((EClass)typeEClassifier, null).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle createClassComposition5c0101(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        xsdParticle.setMinOccurs(feature.getLowerBound());
        xsdParticle.setMaxOccurs(feature.getUpperBound());
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLWrapperName(feature));
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        xsdParticle2.setMaxOccurs(1);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getName(typeEClassifier));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        if (typeEClassifier instanceof EDataType && this.isXMLPrimitiveXsdType((EDataType)typeEClassifier).booleanValue()) {
            String xsdSimpleType = this.getXsdSimpleType(typeEClassifier);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            String uri = this.getElementXSDURI(typeEClassifier);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    xsdElementSubType.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it));
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDAttributeUse createClassAttribute5d(EAttribute attribute, EClass eClass, XSDSchema xsdSchema) {
        boolean _equals;
        XSDAttributeUse xsdAttributeUse = xsdFactory.createXSDAttributeUse();
        XSDAttributeDeclaration attributeDeclaration = XSDFactory.eINSTANCE.createXSDAttributeDeclaration();
        attributeDeclaration.setName(this.xsdExtendedMetaData.getXMLName((EStructuralFeature)attribute));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        EClassifier baseType = attribute.getEType();
        if (baseType instanceof EDataType && this.isXMLPrimitiveXsdType((EDataType)baseType).booleanValue()) {
            String xsdSimpleType = this.getXsdSimpleType(baseType);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            String uri = this.getElementXSDURI(baseType);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        attributeDeclaration.setTypeDefinition((XSDSimpleTypeDefinition)xsdTypeDefinition);
        xsdAttributeUse.setContent(attributeDeclaration);
        int _upperBound = attribute.getUpperBound();
        boolean bl = _equals = _upperBound == 0;
        if (_equals) {
            xsdAttributeUse.setUse(XSDAttributeUseCategory.PROHIBITED_LITERAL);
        } else {
            boolean _equals_1;
            int _lowerBound = attribute.getLowerBound();
            boolean bl2 = _equals_1 = _lowerBound == 0;
            if (_equals_1) {
                xsdAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
            } else {
                xsdAttributeUse.setUse(XSDAttributeUseCategory.REQUIRED_LITERAL);
            }
        }
        return xsdAttributeUse;
    }

    public XSDParticle create_EReference_contained1100(final EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLWrapperName(feature));
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(feature.getUpperBound());
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getXMLName(feature));
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        if (typeEClassifier instanceof EDataType && this.isXMLPrimitiveXsdType((EDataType)typeEClassifier).booleanValue()) {
            String xsdSimpleType = this.getXsdSimpleType(typeEClassifier);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            String uri = this.getElementXSDURI(typeEClassifier);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    xsdElementSubType.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName(feature));
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_contained0101(final EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        boolean _greaterThan;
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(feature.getUpperBound());
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        xsdElement.setName(this.xsdExtendedMetaData.getXMLName(feature));
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    String subClassXMLName = Ecore2XSDFactory.this.getTypeXMLName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it, feature), (ENamedElement)it);
                    xsdElementSubType.setName(subClassXMLName);
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findAllConcreteTypes((EClass)typeEClassifier, null).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        return xsdParticle;
    }

    public XSDParticle create_EReference_contained0100(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        xsdParticle.setMinOccurs(feature.getLowerBound());
        xsdParticle.setMaxOccurs(feature.getUpperBound());
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(this.xsdExtendedMetaData.getXMLName(feature));
        EClassifier typeeClassifier = feature.getEType();
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        if (typeeClassifier instanceof EDataType && this.isXMLPrimitiveXsdType((EDataType)typeeClassifier).booleanValue()) {
            String xsdSimpleType = this.getXsdSimpleType(typeeClassifier);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#" + xsdSimpleType);
        } else {
            String uri = this.getElementXSDURI(typeeClassifier);
            xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        }
        xsdElement.setTypeDefinition(xsdTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced1100Many_5l(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        boolean _not;
        boolean _equals = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature).equals("xsi:type");
        boolean bl = _not = !_equals;
        if (_not) {
            return this.create_EReference_referenced1100Many_5l_XSITypeFalse(feature, eClass, xsdSchema, referencedClass);
        }
        return this.create_EReference_referenced1100Many_5l_XSITypeTrue(feature, eClass, xsdSchema, referencedClass);
    }

    public XSDParticle create_EReference_referenced1100Many_5l_XSITypeFalse(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        int lowerBound = feature.getLowerBound();
        if (lowerBound > 1) {
            lowerBound = 1;
        }
        xsdParticle.setMinOccurs(lowerBound);
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(feature.getUpperBound());
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getXMLName(feature));
        XSDComplexTypeDefinition xsdComplexTypeDefinition2 = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition2.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDSimpleTypeDefinition simpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        XSDTypeDefinition baseTypeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdComplexTypeDefinition2.setBaseTypeDefinition(baseTypeDef);
        xsdComplexTypeDefinition2.setContent((XSDComplexTypeContent)simpleTypeDefinition);
        XSDAttributeUse simpleAttributeUse = xsdFactory.createXSDAttributeUse();
        XSDAttributeDeclaration xsdAttribute = xsdFactory.createXSDAttributeDeclaration();
        xsdAttribute.setName(this.xsdExtendedMetaData.getXMLTypeAttributeName(feature));
        EClassifier baseType = feature.getEType();
        referencedClass.add((EClass)baseType);
        String _elementXSDURI = this.getElementXSDURI(baseType);
        String uri = String.valueOf(_elementXSDURI) + "--SUBTYPES-ENUM";
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        xsdAttribute.setTypeDefinition((XSDSimpleTypeDefinition)xsdTypeDefinition);
        simpleAttributeUse.setContent(xsdAttribute);
        simpleAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        xsdComplexTypeDefinition2.getAttributeContents().add((Object)simpleAttributeUse);
        xsdElement2.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition2);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced1100Many_5l_XSITypeTrue(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        int lowerBound = feature.getLowerBound();
        if (lowerBound > 1) {
            lowerBound = 1;
        }
        xsdParticle.setMinOccurs(lowerBound);
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(feature.getUpperBound());
        xsdParticle2.setMinOccurs(feature.getLowerBound());
        XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getXMLName(feature));
        XSDTypeDefinition typeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdElement2.setTypeDefinition(typeDef);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced0100Many_5m(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        boolean _not;
        boolean _equals = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature).equals("xsi:type");
        boolean bl = _not = !_equals;
        if (_not) {
            return this.create_EReference_referenced0100Many_5m_XSITypeFalse(feature, eClass, xsdSchema, referencedClass);
        }
        return this.create_EReference_referenced0100Many_5m_XSITypeTrue(feature, eClass, xsdSchema, referencedClass);
    }

    public XSDParticle create_EReference_referenced0100Many_5m_XSITypeFalse(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdParticle.setMinOccurs(feature.getLowerBound());
        xsdParticle.setMaxOccurs(feature.getUpperBound());
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDSimpleTypeDefinition simpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        XSDTypeDefinition baseTypeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdComplexTypeDefinition.setBaseTypeDefinition(baseTypeDef);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)simpleTypeDefinition);
        XSDAttributeUse simpleAttributeUse = xsdFactory.createXSDAttributeUse();
        XSDAttributeDeclaration xsdAttribute = xsdFactory.createXSDAttributeDeclaration();
        String typeAttributeName = this.xsdExtendedMetaData.getXMLTypeAttributeName(feature);
        xsdAttribute.setName(typeAttributeName);
        EClassifier baseType = feature.getEType();
        referencedClass.add((EClass)baseType);
        String _elementXSDURI = this.getElementXSDURI(baseType);
        String uri = String.valueOf(_elementXSDURI) + "--SUBTYPES-ENUM";
        XSDTypeDefinition xsdTypeDefinition = xsdSchema.resolveTypeDefinitionURI(uri);
        xsdAttribute.setTypeDefinition((XSDSimpleTypeDefinition)xsdTypeDefinition);
        simpleAttributeUse.setContent(xsdAttribute);
        simpleAttributeUse.setUse(XSDAttributeUseCategory.OPTIONAL_LITERAL);
        xsdComplexTypeDefinition.getAttributeContents().add((Object)simpleAttributeUse);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced0100Many_5m_XSITypeTrue(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        XSDParticle xsdParticle = xsdFactory.createXSDParticle();
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdParticle.setMinOccurs(feature.getLowerBound());
        xsdParticle.setMaxOccurs(feature.getUpperBound());
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDTypeDefinition typeDef = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdElement.setTypeDefinition(typeDef);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
        return xsdParticle;
    }

    public XSDParticle create_EReference_referenced0100Single_5n(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema, ArrayList<EClass> referencedClass) {
        return this.create_EReference_referenced0100Many_5m(feature, eClass, xsdSchema, referencedClass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSimpleTypeDefinition createEnumSchema6(EEnum eEnum, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{eEnum, xsdSchema});
        HashMap<ArrayList<?>, XSDSimpleTypeDefinition> hashMap = this._createCache_createEnumSchema6;
        synchronized (hashMap) {
            XSDSimpleTypeDefinition _createXSDSimpleTypeDefinition;
            if (this._createCache_createEnumSchema6.containsKey(_cacheKey)) {
                return this._createCache_createEnumSchema6.get(_cacheKey);
            }
            _result = _createXSDSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
            this._createCache_createEnumSchema6.put(_cacheKey, _result);
        }
        this._init_createEnumSchema6(_result, eEnum, xsdSchema);
        return _result;
    }

    private void _init_createEnumSchema6(final XSDSimpleTypeDefinition xsdSimpleTypeDefinition, EEnum eEnum, XSDSchema xsdSchema) {
        xsdSimpleTypeDefinition.setName(this.xsdExtendedMetaData.getXMLName((EClassifier)eEnum));
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        Consumer<EEnumLiteral> _function = new Consumer<EEnumLiteral>(){

            @Override
            public void accept(EEnumLiteral it) {
                XSDEnumerationFacet xsdEnum = xsdFactory.createXSDEnumerationFacet();
                xsdEnum.setLexicalValue(it.getName().toUpperCase());
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdEnum);
            }
        };
        eEnum.getELiterals().forEach((Consumer)_function);
        xsdSchema.getContents().add((Object)xsdSimpleTypeDefinition);
    }

    public XSDComplexTypeDefinition createDataTypeSchema7a(EDataType eDataType, XSDSchema xsdSchema) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = xsdFactory.createXSDComplexTypeDefinition();
        xsdComplexTypeDefinition.setName(this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType));
        XSDParticle xsdParticle = XSDFactory.eINSTANCE.createXSDParticle();
        XSDModelGroup xsdModelGroup = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup.setCompositor(XSDCompositor.SEQUENCE_LITERAL);
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDWildcard xsdAny = XSDFactory.eINSTANCE.createXSDWildcard();
        xsdAny.setStringLexicalNamespaceConstraint("##any");
        xsdAny.setProcessContents(XSDProcessContents.LAX_LITERAL);
        xsdParticle2.setMinOccurs(0);
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setContent((XSDParticleContent)xsdAny);
        xsdModelGroup.getContents().add((Object)xsdParticle2);
        xsdParticle.setContent((XSDParticleContent)xsdModelGroup);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle);
        xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        return xsdComplexTypeDefinition;
    }

    public XSDSimpleTypeDefinition createDataTypeSchema7b(EDataType eDataType, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        xsdSimpleTypeDefinition.setName(this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType));
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        List patternValue = ExtendedMetaData.INSTANCE.getPatternFacet(eDataType);
        if (!Objects.equal((Object)patternValue, null) && !IterableExtensions.isNullOrEmpty((Iterable)patternValue)) {
            String pattern = (String)patternValue.get(0);
            XSDPatternFacet xsdPattern = xsdFactory.createXSDPatternFacet();
            xsdPattern.setLexicalValue(pattern);
            xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdPattern);
        }
        xsdSchema.getContents().add((Object)xsdSimpleTypeDefinition);
        return xsdSimpleTypeDefinition;
    }

    public XSDSimpleTypeDefinition createDataTypeSimpleType7b(EDataType eDataType, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition xsdSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        xsdSimpleTypeDefinition.setName(this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType));
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        XSDPatternFacet xsdPattern = xsdFactory.createXSDPatternFacet();
        List patternValue = ExtendedMetaData.INSTANCE.getPatternFacet(eDataType);
        xsdPattern.setLexicalValue((String)patternValue.get(0));
        xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdPattern);
        xsdSchema.getContents().add((Object)xsdSimpleTypeDefinition);
        return xsdSimpleTypeDefinition;
    }

    public XSDComplexTypeDefinition createDataTypeComplexType7c(EDataType eDataType, XSDSchema xsdSchema) {
        XSDComplexTypeDefinition xsdComplexTypeDefinition = xsdFactory.createXSDComplexTypeDefinition();
        String xmlName = this.xsdExtendedMetaData.getXMLName((EClassifier)eDataType);
        xsdComplexTypeDefinition.setName(xmlName);
        xsdComplexTypeDefinition.setDerivationMethod(XSDDerivationMethod.EXTENSION_LITERAL);
        XSDSimpleTypeDefinition simpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
        String typeURI = String.valueOf(this.defaultUserSchemaNamespace) + "#" + xmlName + "--SIMPLE";
        XSDTypeDefinition baseTypeDef = xsdSchema.resolveTypeDefinitionURI(typeURI);
        xsdComplexTypeDefinition.setBaseTypeDefinition(baseTypeDef);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)simpleTypeDefinition);
        xsdSchema.getContents().add((Object)xsdComplexTypeDefinition);
        return xsdComplexTypeDefinition;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDSimpleTypeDefinition createSimpleType8(EClass eClass, XSDSchema xsdSchema) {
        XSDSimpleTypeDefinition _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{eClass, xsdSchema});
        HashMap<ArrayList<?>, XSDSimpleTypeDefinition> hashMap = this._createCache_createSimpleType8;
        synchronized (hashMap) {
            XSDSimpleTypeDefinition _createXSDSimpleTypeDefinition;
            if (this._createCache_createSimpleType8.containsKey(_cacheKey)) {
                return this._createCache_createSimpleType8.get(_cacheKey);
            }
            _result = _createXSDSimpleTypeDefinition = xsdFactory.createXSDSimpleTypeDefinition();
            this._createCache_createSimpleType8.put(_cacheKey, _result);
        }
        this._init_createSimpleType8(_result, eClass, xsdSchema);
        return _result;
    }

    private void _init_createSimpleType8(final XSDSimpleTypeDefinition xsdSimpleTypeDefinition, EClass eClass, XSDSchema xsdSchema) {
        String _xMLName = this.xsdExtendedMetaData.getXMLName((EClassifier)eClass);
        String _plus = String.valueOf(_xMLName) + "--SUBTYPES-ENUM";
        xsdSimpleTypeDefinition.setName(_plus);
        XSDTypeDefinition baseType = xsdSchema.resolveTypeDefinitionURI(String.valueOf(this.defaultXMLSchemaNamespace) + "#string");
        xsdSimpleTypeDefinition.setBaseTypeDefinition((XSDSimpleTypeDefinition)baseType);
        XSDEnumerationFacet xsdEnumFacet = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
        xsdEnumFacet.setLexicalValue(this.xsdExtendedMetaData.getXMLName((EClassifier)eClass));
        xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdEnumFacet);
        Consumer<EClass> _function = new Consumer<EClass>(){

            @Override
            public void accept(EClass it) {
                XSDEnumerationFacet xsdEnum = XSDFactory.eINSTANCE.createXSDEnumerationFacet();
                xsdEnum.setLexicalValue(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it));
                xsdSimpleTypeDefinition.getFacetContents().add((Object)xsdEnum);
            }
        };
        Ecore2XSDUtil.findESubTypesOf(eClass).forEach(_function);
        xsdSchema.getContents().add((Object)xsdSimpleTypeDefinition);
    }

    public XSDParticle generateXSDParticleForFeature(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        int xmlPersistenceStrategy = this.xsdExtendedMetaData.getXMLPersistenceMappingStrategy(feature);
        XSDParticle xsdParticle = null;
        if (9 == xmlPersistenceStrategy) {
            xsdParticle = this.createXSDParticleForFeatureCase0010(feature, eClass);
            this.patternCaseSet.add("0010");
        } else if (5 == xmlPersistenceStrategy) {
            xsdParticle = this.createXSDParticleForFeatureCase0012(feature, eClass);
            this.patternCaseSet.add("0012");
        } else if (4 == xmlPersistenceStrategy) {
            xsdParticle = this.createXSDParticleForFeatureCase0013(feature, eClass, xsdSchema);
            this.patternCaseSet.add("0013");
        } else if (12 == xmlPersistenceStrategy) {
            xsdParticle = this.createXSDParticleForFeatureCase0023(feature, eClass, xsdSchema);
            this.patternCaseSet.add("0023");
        } else if (8 == xmlPersistenceStrategy) {
            xsdParticle = this.createXSDParticleForFeatureCase0010(feature, eClass);
            this.patternCaseSet.add("case not allowed, handled as pattern 0010 (the same way in EAST-ADL)");
        } else {
            xsdParticle = this.createXSDParticleForFeatureCase0012(feature, eClass);
            this.patternCaseSet.add("unsupported_mapping_strategy" + Integer.valueOf(xmlPersistenceStrategy));
            String _name = eClass.getName();
            String _plus = "\n eClass = " + _name;
            String _plus_1 = String.valueOf(_plus) + " feature = ";
            String _name_1 = feature.getName();
            String _plus_2 = String.valueOf(_plus_1) + _name_1;
            System.out.print(_plus_2);
        }
        return xsdParticle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0010(EStructuralFeature feature, EClass eClass) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ENamedElement[]{feature, eClass});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0010;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0010.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0010.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0010.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0010(_result, feature, eClass);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0010(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass) {
        boolean _greaterThan;
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        int _lowerBound = feature.getLowerBound();
        boolean bl = _greaterThan = _lowerBound > 0;
        if (_greaterThan) {
            xsdParticle.setMinOccurs(1);
        } else {
            xsdParticle.setMinOccurs(0);
        }
        xsdParticle.setMaxOccurs(1);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getName(typeEClassifier));
        String typeeClassifierURI = this.getElementXSDURI(typeEClassifier);
        XSDTypeDefinition xsdTypeDefinition = xsdElement2.resolveTypeDefinitionURI(typeeClassifierURI);
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    xsdElementSubType.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLName((EClassifier)it));
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0012(EStructuralFeature feature, EClass eClass) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new ENamedElement[]{feature, eClass});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0012;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0012.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0012.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0012.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0012(_result, feature, eClass);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0012(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass) {
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdParticle.setMinOccurs(0);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
        XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement2.setName(this.xsdExtendedMetaData.getXMLName(typeEClassifier));
        String typeeClassifierURI = this.getElementXSDURI(typeEClassifier);
        XSDTypeDefinition xsdTypeDefinition = xsdElement2.resolveTypeDefinitionURI(typeeClassifierURI);
        xsdElement2.setTypeDefinition(xsdTypeDefinition);
        xsdParticle3.setContent((XSDParticleContent)xsdElement2);
        xsdModelGroup2.getContents().add((Object)xsdParticle3);
        if (typeEClassifier instanceof EClass) {
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration xsdElementSubType = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    xsdElementSubType.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getName((EClassifier)it));
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDTypeDefinition xsdTypeDefinitionSubType = xsdElementSubType.resolveTypeDefinitionURI(subTypeURI);
                    xsdElementSubType.setTypeDefinition(xsdTypeDefinitionSubType);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdElementSubType);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0013(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{feature, eClass, xsdSchema});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0013;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0013.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0013.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0013.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0013(_result, feature, eClass, xsdSchema);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0013(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        String roleName = this.xsdExtendedMetaData.getXMLName(feature);
        xsdParticle.setMinOccurs(0);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDModelGroupDefinition xsdModelGroupdefinitionRef = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
            String refGroupURI = this.getElementXSDURI(typeEClassifier);
            XSDModelGroupDefinition xsdModelGroupDef = xsdModelGroupdefinitionRef.resolveModelGroupDefinitionURI(refGroupURI);
            xsdModelGroupdefinitionRef.setResolvedModelGroupDefinition(xsdModelGroupDef);
            xsdParticle3.setContent((XSDParticleContent)xsdModelGroupdefinitionRef);
            xsdParticle3.setContent((XSDParticleContent)xsdModelGroupdefinitionRef);
            xsdModelGroup2.getContents().add((Object)xsdParticle3);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle xsdParticleSubType = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDModelGroupDefinition xsdModelGroupdefSubTypeRef = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDModelGroupDefinition subTypeModelGroupDef = xsdModelGroupdefSubTypeRef.resolveModelGroupDefinitionURI(subTypeURI);
                    xsdModelGroupdefSubTypeRef.setResolvedModelGroupDefinition(subTypeModelGroupDef);
                    xsdParticleSubType.setContent((XSDParticleContent)xsdModelGroupdefSubTypeRef);
                    xsdModelGroup2.getContents().add((Object)xsdParticleSubType);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier).forEach(_function);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XSDParticle createXSDParticleForFeatureCase0023(EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        XSDParticle _result;
        ArrayList _cacheKey = CollectionLiterals.newArrayList((Object[])new EObject[]{feature, eClass, xsdSchema});
        HashMap<ArrayList<?>, XSDParticle> hashMap = this._createCache_createXSDParticleForFeatureCase0023;
        synchronized (hashMap) {
            XSDParticle _createXSDParticle;
            if (this._createCache_createXSDParticleForFeatureCase0023.containsKey(_cacheKey)) {
                return this._createCache_createXSDParticleForFeatureCase0023.get(_cacheKey);
            }
            _result = _createXSDParticle = xsdFactory.createXSDParticle();
            this._createCache_createXSDParticleForFeatureCase0023.put(_cacheKey, _result);
        }
        this._init_createXSDParticleForFeatureCase0023(_result, feature, eClass, xsdSchema);
        return _result;
    }

    private void _init_createXSDParticleForFeatureCase0023(XSDParticle xsdParticle, EStructuralFeature feature, EClass eClass, XSDSchema xsdSchema) {
        String roleName = this.xsdExtendedMetaData.getXMLWrapperName(feature);
        xsdParticle.setMinOccurs(0);
        XSDElementDeclaration xsdElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
        xsdElement.setName(roleName);
        XSDComplexTypeDefinition xsdComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
        XSDParticle xsdParticle2 = XSDFactory.eINSTANCE.createXSDParticle();
        xsdParticle2.setMaxOccurs(1);
        xsdParticle2.setMinOccurs(0);
        final XSDModelGroup xsdModelGroup2 = XSDFactory.eINSTANCE.createXSDModelGroup();
        xsdModelGroup2.setCompositor(XSDCompositor.CHOICE_LITERAL);
        EClassifier typeEClassifier = feature.getEType();
        if (typeEClassifier instanceof EClass) {
            XSDParticle xsdParticle3 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDElementDeclaration xsdElement2 = XSDFactory.eINSTANCE.createXSDElementDeclaration();
            xsdElement2.setName(this.xsdExtendedMetaData.getXMLWrapperName(typeEClassifier));
            XSDComplexTypeDefinition xsdComplexTypeDefinition2 = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
            XSDParticle xsdParticle4 = XSDFactory.eINSTANCE.createXSDParticle();
            xsdParticle4.setMaxOccurs(1);
            xsdParticle4.setMinOccurs(0);
            XSDModelGroup xsdModelGroup3 = XSDFactory.eINSTANCE.createXSDModelGroup();
            xsdModelGroup3.setCompositor(XSDCompositor.CHOICE_LITERAL);
            XSDParticle xsdParticle5 = XSDFactory.eINSTANCE.createXSDParticle();
            XSDModelGroupDefinition xsdModelGroupdefinitionRef = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
            String typeURI = this.getElementXSDURI(typeEClassifier);
            XSDModelGroupDefinition typeModelGroupDef = xsdModelGroupdefinitionRef.resolveModelGroupDefinitionURI(typeURI);
            xsdModelGroupdefinitionRef.setResolvedModelGroupDefinition(typeModelGroupDef);
            xsdParticle5.setContent((XSDParticleContent)xsdModelGroupdefinitionRef);
            Consumer<EClass> _function = new Consumer<EClass>(){

                @Override
                public void accept(EClass it) {
                    XSDParticle subTypeXSDParticle = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDElementDeclaration subTypeXSDElement = XSDFactory.eINSTANCE.createXSDElementDeclaration();
                    subTypeXSDElement.setName(Ecore2XSDFactory.this.xsdExtendedMetaData.getXMLWrapperName((EClassifier)it));
                    XSDComplexTypeDefinition subTypeXSDComplexTypeDefinition = XSDFactory.eINSTANCE.createXSDComplexTypeDefinition();
                    XSDParticle xsdParticle6 = XSDFactory.eINSTANCE.createXSDParticle();
                    xsdParticle6.setMaxOccurs(1);
                    xsdParticle6.setMinOccurs(0);
                    XSDModelGroup xsdModelGroup4 = XSDFactory.eINSTANCE.createXSDModelGroup();
                    xsdModelGroup4.setCompositor(XSDCompositor.CHOICE_LITERAL);
                    XSDParticle xsdParticle7 = XSDFactory.eINSTANCE.createXSDParticle();
                    XSDModelGroupDefinition xsdModelGroupdefinitionRef2 = XSDFactory.eINSTANCE.createXSDModelGroupDefinition();
                    String subTypeURI = Ecore2XSDFactory.this.getElementXSDURI((EClassifier)it);
                    XSDModelGroupDefinition subTypeModelGroupDef = xsdModelGroupdefinitionRef2.resolveModelGroupDefinitionURI(subTypeURI);
                    xsdModelGroupdefinitionRef2.setResolvedModelGroupDefinition(subTypeModelGroupDef);
                    xsdParticle7.setContent((XSDParticleContent)xsdModelGroupdefinitionRef2);
                    xsdModelGroup4.getContents().add((Object)xsdParticle7);
                    xsdParticle6.setContent((XSDParticleContent)xsdModelGroup4);
                    subTypeXSDComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle6);
                    subTypeXSDElement.setAnonymousTypeDefinition((XSDTypeDefinition)subTypeXSDComplexTypeDefinition);
                    subTypeXSDParticle.setContent((XSDParticleContent)subTypeXSDElement);
                    xsdModelGroup2.getContents().add((Object)subTypeXSDParticle);
                }
            };
            Ecore2XSDUtil.findESubTypesOf((EClass)typeEClassifier).forEach(_function);
            xsdModelGroup3.getContents().add((Object)xsdParticle5);
            xsdParticle4.setContent((XSDParticleContent)xsdModelGroup3);
            xsdComplexTypeDefinition2.setContent((XSDComplexTypeContent)xsdParticle4);
            xsdElement2.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition2);
            xsdParticle3.setContent((XSDParticleContent)xsdElement2);
            xsdModelGroup2.getContents().add((Object)xsdParticle3);
        }
        xsdParticle2.setContent((XSDParticleContent)xsdModelGroup2);
        xsdComplexTypeDefinition.setContent((XSDComplexTypeContent)xsdParticle2);
        xsdElement.setAnonymousTypeDefinition((XSDTypeDefinition)xsdComplexTypeDefinition);
        xsdParticle.setContent((XSDParticleContent)xsdElement);
    }

    public Boolean isXMLPrimitiveXsdType(EDataType dataType) {
        boolean _not;
        Boolean isPrimitive = true;
        String _xMLXsdSimpleType = this.xsdExtendedMetaData.getXMLXsdSimpleType((EClassifier)dataType);
        Boolean isXsdTypeDefined = !Objects.equal((Object)_xMLXsdSimpleType, (Object)"uninitialized");
        Boolean isCustomSimpleTypeDefined = IGeneratorConstants.BOOLEAN_TRUE.equals(this.xsdExtendedMetaData.getXMLCustomSimpleType((EClassifier)dataType));
        Boolean isPatternDefined = false;
        List patterns = ExtendedMetaData.INSTANCE.getPatternFacet(dataType);
        boolean _isEmpty = patterns.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            String _get = (String)patterns.get(0);
            boolean _notEquals = !Objects.equal((Object)_get, null);
            isPatternDefined = _notEquals;
        }
        if (isPrimitive.booleanValue() && isXsdTypeDefined.booleanValue() && !isCustomSimpleTypeDefined.booleanValue() && !isPatternDefined.booleanValue()) {
            return true;
        }
        return false;
    }

    protected String getXsdSimpleType(EClassifier typeeClassifier) {
        String xsdSimpleType = this.xsdExtendedMetaData.getXMLXsdSimpleType(typeeClassifier);
        boolean _equals = Objects.equal((Object)xsdSimpleType, null);
        if (_equals) {
            Class instanceClass = typeeClassifier.getInstanceClass();
            xsdSimpleType = JavaXSDPrimitiveTypeMapping.javaXsdPrimitiveTypeMapping.get(instanceClass);
        }
        return xsdSimpleType;
    }
}

