/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.workspace.loading.operations;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.util.EcorePlatformUtil;
import org.eclipse.sphinx.emf.workspace.Activator;
import org.eclipse.sphinx.emf.workspace.internal.messages.Messages;
import org.eclipse.sphinx.emf.workspace.loading.operations.AbstractLoadOperation;
import org.eclipse.sphinx.emf.workspace.loading.operations.IModelLoadOperation;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;

public class DefaultModelLoadOperation
extends AbstractLoadOperation
implements IModelLoadOperation {
    private IModelDescriptor modelDescriptor;
    private boolean includeReferencedScopes;
    private Collection<IFile> persistedFiles;

    public DefaultModelLoadOperation(IModelDescriptor modelDescriptor, boolean includeReferencedScopes) {
        super(Messages.job_loadingModelResources, modelDescriptor.getMetaModelDescriptor());
        this.modelDescriptor = modelDescriptor;
        this.includeReferencedScopes = includeReferencedScopes;
        this.persistedFiles = this.getModelDescriptor().getPersistedFiles(includeReferencedScopes);
    }

    public void run(IProgressMonitor monitor) throws CoreException {
        if (!this.persistedFiles.isEmpty()) {
            this.runCollectAndLoadModelFiles(this.getModelDescriptor().getEditingDomain(), this.persistedFiles, monitor);
        }
    }

    @Override
    public IModelDescriptor getModelDescriptor() {
        return this.modelDescriptor;
    }

    @Override
    public boolean isIncludeReferencedScopes() {
        return this.includeReferencedScopes;
    }

    protected void runCollectAndLoadModelFiles(TransactionalEditingDomain editingDomain, Collection<IFile> files, IProgressMonitor monitor) throws OperationCanceledException {
        Assert.isNotNull(files);
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (String)Messages.task_loadingModelFiles, (int)100);
        if (progress.isCanceled()) {
            throw new OperationCanceledException();
        }
        SubMonitor collectProgress = progress.newChild(1).setWorkRemaining(files.size());
        HashMap<TransactionalEditingDomain, Collection<IFile>> filesToLoad = new HashMap<TransactionalEditingDomain, Collection<IFile>>();
        for (IFile file : files) {
            try {
                if (file.isAccessible() && !EcorePlatformUtil.isFileLoaded((IFile)file)) {
                    HashSet<IFile> filesToLoadInEditingDomain = (HashSet<IFile>)filesToLoad.get(editingDomain);
                    if (filesToLoadInEditingDomain == null) {
                        filesToLoadInEditingDomain = new HashSet<IFile>();
                        filesToLoad.put(editingDomain, filesToLoadInEditingDomain);
                    }
                    filesToLoadInEditingDomain.add(file);
                }
            }
            catch (Exception ex) {
                PlatformLogUtil.logAsWarning((Plugin)Activator.getPlugin(), (Object)ex);
            }
            collectProgress.worked(1);
            if (!collectProgress.isCanceled()) continue;
            throw new OperationCanceledException();
        }
        if (filesToLoad.size() == 0) {
            progress.done();
            return;
        }
        this.runLoadModelFiles(filesToLoad, (IProgressMonitor)progress.newChild(99));
    }

    public ISchedulingRule getRule() {
        return this.getSchedulingRuleFactory().createLoadSchedulingRule(this.persistedFiles);
    }

    @Override
    public boolean covers(Collection<IProject> projects, boolean includeReferencedProjects, IMetaModelDescriptor mmDescriptor) {
        return false;
    }

    @Override
    public boolean covers(Collection<IFile> files, IMetaModelDescriptor mmDescriptor) {
        int filesComparison = this.compare(this.persistedFiles, files);
        int mmDescriptorsComparison = this.compare(this.getMetaModelDescriptor(), mmDescriptor);
        return filesComparison == EQUAL ? mmDescriptorsComparison == EQUAL || mmDescriptorsComparison == GREATER_THAN : filesComparison == GREATER_THAN && (mmDescriptorsComparison == EQUAL || mmDescriptorsComparison == GREATER_THAN);
    }
}

