/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.gmf.runtime.ui.editor;

import java.util.ArrayList;
import org.eclipse.core.commands.operations.IUndoContext;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.diagram.ui.resources.editor.parts.DiagramDocumentEditor;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.sphinx.emf.editors.ModelEditorUndoContextManager;
import org.eclipse.sphinx.emf.workspace.ui.saving.BasicModelSaveablesProvider;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.ISaveablesLifecycleListener;
import org.eclipse.ui.ISaveablesSource;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.Saveable;
import org.eclipse.ui.SaveablesLifecycleEvent;
import org.eclipse.ui.navigator.SaveablesProvider;

public class BasicDiagramDocumentEditor
extends DiagramDocumentEditor
implements ISaveablesSource {
    protected SaveablesProvider modelSaveablesProvider;
    protected ModelEditorUndoContextManager undoContextManager;

    public BasicDiagramDocumentEditor() {
        super(true);
    }

    public BasicDiagramDocumentEditor(boolean hasFlyoutPalette) {
        super(hasFlyoutPalette);
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.modelSaveablesProvider = this.createModelSaveablesProvider();
        this.modelSaveablesProvider.init(this.createModelSaveablesLifecycleListener());
        this.undoContextManager = new ModelEditorUndoContextManager((IWorkbenchPartSite)site, (IWorkbenchPart)this, this.getEditingDomain());
    }

    protected SaveablesProvider createModelSaveablesProvider() {
        return new BasicModelSaveablesProvider();
    }

    protected ISaveablesLifecycleListener createModelSaveablesLifecycleListener() {
        return new BasicModelSaveablesProvider.SiteNotifyingSaveablesLifecycleListener((IWorkbenchPart)this){

            public void handleLifecycleEvent(SaveablesLifecycleEvent event) {
                super.handleLifecycleEvent(event);
                if (event.getEventType() == 4) {
                    BasicDiagramDocumentEditor.this.firePropertyChange(257);
                }
            }
        };
    }

    public boolean isSaveOnCloseNeeded() {
        return super.isSaveOnCloseNeeded();
    }

    public Saveable[] getActiveSaveables() {
        return this.getSaveables();
    }

    public Saveable[] getSaveables() {
        if (this.modelSaveablesProvider != null) {
            Saveable domainModelSaveable;
            ArrayList<Saveable> saveables = new ArrayList<Saveable>(2);
            Diagram diagram = this.getDiagram();
            Saveable diagramSaveable = this.modelSaveablesProvider.getSaveable((Object)diagram);
            if (diagramSaveable != null) {
                saveables.add(diagramSaveable);
            }
            if ((domainModelSaveable = this.modelSaveablesProvider.getSaveable((Object)diagram.getElement())) != null) {
                saveables.add(domainModelSaveable);
            }
            return saveables.toArray(new Saveable[saveables.size()]);
        }
        return new Saveable[0];
    }

    public Object getAdapter(Class key) {
        if (key.equals(AdapterFactory.class)) {
            return this.getAdapterFactory();
        }
        if (key.equals(IUndoContext.class)) {
            return this.undoContextManager.getUndoContext();
        }
        return super.getAdapter(key);
    }

    public AdapterFactory getAdapterFactory() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        AdapterFactory customAdapterFactory = this.getCustomAdapterFactory();
        if (customAdapterFactory != null) {
            return customAdapterFactory;
        }
        if (editingDomain != null) {
            return ((AdapterFactoryEditingDomain)editingDomain).getAdapterFactory();
        }
        return null;
    }

    protected AdapterFactory getCustomAdapterFactory() {
        return null;
    }

    protected void enableSanityChecking(boolean enable) {
        super.enableSanityChecking(false);
    }

    public void dispose() {
        if (this.undoContextManager != null) {
            this.undoContextManager.dispose();
        }
        if (this.modelSaveablesProvider != null) {
            this.modelSaveablesProvider.dispose();
        }
        super.dispose();
    }
}

