/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.search.ui.services;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.sphinx.emf.metamodel.IMetaModelDescriptor;
import org.eclipse.sphinx.emf.metamodel.services.AbstractMetaModelService;
import org.eclipse.sphinx.emf.model.IModelDescriptor;
import org.eclipse.sphinx.emf.search.ui.ModelSearchMatch;
import org.eclipse.sphinx.emf.search.ui.QuerySpecification;
import org.eclipse.sphinx.emf.search.ui.services.IModelSearchService;
import org.eclipse.sphinx.emf.ui.util.RetrieveNameAttributeHelper;

public class BasicModelSearchService
extends AbstractMetaModelService
implements IModelSearchService {
    protected RetrieveNameAttributeHelper helper = new RetrieveNameAttributeHelper();
    private Map<Character, String> replacementMap = null;

    public BasicModelSearchService(Collection<IMetaModelDescriptor> mmDescriptors) {
        super(mmDescriptors);
    }

    @Override
    public List<ModelSearchMatch> getMatches(IModelDescriptor modelDescriptor, QuerySpecification spec) {
        return this.getMatches(modelDescriptor.getLoadedResources(true), spec);
    }

    @Override
    public List<ModelSearchMatch> getMatches(Collection<Resource> resources, QuerySpecification spec) {
        ArrayList<ModelSearchMatch> result = new ArrayList<ModelSearchMatch>();
        this.initReplacementMap();
        for (Resource resource : resources) {
            TreeIterator allContents = resource.getAllContents();
            while (allContents.hasNext()) {
                Object nameObj;
                EObject eObject = (EObject)allContents.next();
                EAttribute nameAttribute = this.helper.getNameAttribute(eObject);
                if (nameAttribute == null || (nameObj = eObject.eGet((EStructuralFeature)nameAttribute)) == null || !this.isMatchingPattern(spec, nameObj.toString())) continue;
                result.add(this.createModelSearchMatch(eObject));
            }
        }
        return result;
    }

    private boolean isMatchingPattern(QuerySpecification spec, String content) {
        if (spec == null) {
            return false;
        }
        String specificationPattern = spec.getPattern();
        if (specificationPattern == null) {
            return false;
        }
        String regularExpression = this.getRegularExpression(specificationPattern);
        int flag = spec.isCaseSensitive() ? 0 : 2;
        return Pattern.compile(regularExpression, flag).matcher(content).find();
    }

    private String getRegularExpression(String globInput) {
        StringBuilder sb = new StringBuilder();
        char[] cArray = globInput.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char character = cArray[n2];
            String replacement = this.replacementMap.get(Character.valueOf(character));
            if (replacement == null) {
                sb.append(character);
            } else {
                sb.append(replacement);
            }
            ++n2;
        }
        return sb.toString();
    }

    private void initReplacementMap() {
        if (this.replacementMap != null) {
            return;
        }
        this.replacementMap = new HashMap<Character, String>();
        this.replacementMap.put(Character.valueOf('*'), ".*");
        this.replacementMap.put(Character.valueOf('?'), ".");
        this.replacementMap.put(Character.valueOf('('), "\\(");
        this.replacementMap.put(Character.valueOf(')'), "\\)");
        this.replacementMap.put(Character.valueOf('['), "\\[");
        this.replacementMap.put(Character.valueOf(']'), "\\]");
        this.replacementMap.put(Character.valueOf('{'), "\\}");
        this.replacementMap.put(Character.valueOf('.'), "\\.");
        this.replacementMap.put(Character.valueOf('$'), "\\$");
        this.replacementMap.put(Character.valueOf('^'), "\\^");
    }

    private ModelSearchMatch createModelSearchMatch(EObject eObject) {
        ModelSearchMatch match = new ModelSearchMatch(eObject);
        return match;
    }
}

