/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.launching;

import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.internal.launching.DLTKLaunchingPlugin;
import org.eclipse.dltk.internal.launching.InterpreterRuntimeBuildpathEntryResolver;
import org.eclipse.dltk.launching.IInterpreterInstall;
import org.eclipse.dltk.launching.IInterpreterRunner;
import org.eclipse.dltk.launching.IRuntimeBuildpathEntry;
import org.eclipse.dltk.launching.InterpreterConfig;
import org.eclipse.dltk.launching.LaunchingMessages;
import org.eclipse.dltk.launching.LibraryLocation;
import org.eclipse.dltk.launching.ScriptRuntime;

public abstract class AbstractScriptLaunchConfigurationDelegate
extends LaunchConfigurationDelegate {
    private IProject[] fOrderedProjects;

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    protected void abort(String message, Throwable exception, int code) throws CoreException {
        throw new CoreException((IStatus)new Status(4, DLTKLaunchingPlugin.getUniqueIdentifier(), code, message, exception));
    }

    public IInterpreterInstall getInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
        return ScriptRuntime.computeInterpreterInstall(configuration);
    }

    public IInterpreterInstall verifyInterpreterInstall(ILaunchConfiguration configuration) throws CoreException {
        File location;
        IInterpreterInstall Interpreter = this.getInterpreterInstall(configuration);
        if (Interpreter == null) {
            this.abort(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_The_specified_InterpreterEnvironment_installation_does_not_exist_4, null, 105);
        }
        if ((location = Interpreter.getInstallLocation()) == null) {
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_InterpreterEnvironment_home_directory_not_specified_for__0__5, (Object[])new String[]{Interpreter.getName()}), null, 105);
        }
        if (!location.exists()) {
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_InterpreterEnvironment_home_directory_for__0__does_not_exist___1__6, (Object[])new String[]{Interpreter.getName(), location.getAbsolutePath()}), null, 105);
        }
        return Interpreter;
    }

    public String getDebugConnectorId(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("debugConnector", null);
    }

    public String[] getBuildpath(ILaunchConfiguration configuration) throws CoreException {
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(configuration);
        entries = ScriptRuntime.resolveRuntimeBuildpath(entries, configuration);
        HashSet<String> userEntries = new HashSet<String>();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getBuildpathProperty() == 3) {
                userEntries.add(entries[i].getLocation());
            }
            ++i;
        }
        return userEntries.toArray(new String[userEntries.size()]);
    }

    public String[] getBootpath(ILaunchConfiguration configuration) throws CoreException {
        String[][] paths = this.getBootpathExt(configuration);
        String[] pre = paths[0];
        String[] main = paths[1];
        String[] app = paths[2];
        if (pre == null && main == null && app == null) {
            return null;
        }
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(configuration);
        entries = ScriptRuntime.resolveRuntimeBuildpath(entries, configuration);
        ArrayList<String> bootEntries = new ArrayList<String>(entries.length);
        boolean empty = true;
        boolean allStandard = true;
        int i = 0;
        while (i < entries.length) {
            String location;
            if (entries[i].getBuildpathProperty() != 3 && (location = entries[i].getLocation()) != null) {
                empty = false;
                bootEntries.add(location);
                allStandard = allStandard && entries[i].getBuildpathProperty() == 1;
            }
            ++i;
        }
        if (empty) {
            return new String[0];
        }
        if (allStandard) {
            return null;
        }
        return bootEntries.toArray(new String[bootEntries.size()]);
    }

    public String[][] getBootpathExt(ILaunchConfiguration configuration) throws CoreException {
        String[][] bootpathInfo = new String[3][];
        IRuntimeBuildpathEntry[] entries = ScriptRuntime.computeUnresolvedRuntimeBuildpath(configuration);
        ArrayList<IRuntimeBuildpathEntry> bootEntriesPrepend = new ArrayList<IRuntimeBuildpathEntry>();
        int index = 0;
        IRuntimeBuildpathEntry InterpreterEnvironmentEntry = null;
        while (InterpreterEnvironmentEntry == null && index < entries.length) {
            IRuntimeBuildpathEntry entry;
            if ((entry = entries[index++]).getBuildpathProperty() != 2 && entry.getBuildpathProperty() != 1) continue;
            if (ScriptRuntime.isInterpreterInstallReference(this.getLanguageId(), entry)) {
                InterpreterEnvironmentEntry = entry;
                continue;
            }
            bootEntriesPrepend.add(entry);
        }
        IRuntimeBuildpathEntry[] bootEntriesPrep = ScriptRuntime.resolveRuntimeBuildpath(bootEntriesPrepend.toArray(new IRuntimeBuildpathEntry[bootEntriesPrepend.size()]), configuration);
        String[] entriesPrep = null;
        if (bootEntriesPrep.length > 0) {
            entriesPrep = new String[bootEntriesPrep.length];
            int i = 0;
            while (i < bootEntriesPrep.length) {
                entriesPrep[i] = bootEntriesPrep[i].getLocation();
                ++i;
            }
        }
        if (InterpreterEnvironmentEntry != null) {
            IInterpreterInstall install;
            LibraryLocation[] libraryLocations;
            ArrayList<IRuntimeBuildpathEntry> bootEntriesAppend = new ArrayList<IRuntimeBuildpathEntry>();
            while (index < entries.length) {
                IRuntimeBuildpathEntry entry = entries[index];
                if (entry.getBuildpathProperty() == 2) {
                    bootEntriesAppend.add(entry);
                }
                ++index;
            }
            bootpathInfo[0] = entriesPrep;
            IRuntimeBuildpathEntry[] bootEntriesApp = ScriptRuntime.resolveRuntimeBuildpath(bootEntriesAppend.toArray(new IRuntimeBuildpathEntry[bootEntriesAppend.size()]), configuration);
            if (bootEntriesApp.length > 0) {
                bootpathInfo[2] = new String[bootEntriesApp.length];
                int i = 0;
                while (i < bootEntriesApp.length) {
                    bootpathInfo[2][i] = bootEntriesApp[i].getLocation();
                    ++i;
                }
            }
            if ((libraryLocations = (install = this.getInterpreterInstall(configuration)).getLibraryLocations()) != null && !InterpreterRuntimeBuildpathEntryResolver.isSameArchives(libraryLocations, install.getInterpreterInstallType().getDefaultLibraryLocations(install.getInstallLocation()))) {
                IRuntimeBuildpathEntry[] bootEntries = null;
                if (InterpreterEnvironmentEntry.getType() == 4) {
                    IRuntimeBuildpathEntry bootEntry = ScriptRuntime.newRuntimeContainerBuildpathEntry(InterpreterEnvironmentEntry.getPath(), 2, AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration));
                    bootEntries = ScriptRuntime.resolveRuntimeBuildpathEntry(bootEntry, configuration);
                } else {
                    bootEntries = ScriptRuntime.resolveRuntimeBuildpathEntry(InterpreterEnvironmentEntry, configuration);
                }
                String[] bootpath = new String[bootEntriesPrep.length + bootEntries.length + bootEntriesApp.length];
                if (bootEntriesPrep.length > 0) {
                    System.arraycopy(bootpathInfo[0], 0, bootpath, 0, bootEntriesPrep.length);
                }
                int dest = bootEntriesPrep.length;
                int i = 0;
                while (i < bootEntries.length) {
                    bootpath[dest] = bootEntries[i].getLocation();
                    ++dest;
                    ++i;
                }
                if (bootEntriesApp.length > 0) {
                    System.arraycopy(bootpathInfo[2], 0, bootpath, dest, bootEntriesApp.length);
                }
                bootpathInfo[0] = null;
                bootpathInfo[1] = bootpath;
                bootpathInfo[2] = null;
            }
        } else {
            bootpathInfo[1] = entriesPrep == null ? new String[0] : entriesPrep;
        }
        return bootpathInfo;
    }

    public static IScriptProject getScriptProject(ILaunchConfiguration configuration) throws CoreException {
        IProject project;
        IScriptProject scriptProject;
        String projectName = AbstractScriptLaunchConfigurationDelegate.getScriptProjectName(configuration);
        if (projectName != null && (projectName = projectName.trim()).length() > 0 && (scriptProject = DLTKCore.create((IProject)(project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName)))) != null && scriptProject.exists()) {
            return scriptProject;
        }
        return null;
    }

    public static String getScriptProjectName(ILaunchConfiguration configuration) throws CoreException {
        return configuration.getAttribute("project", null);
    }

    public String getMainScriptName(ILaunchConfiguration configuration) throws CoreException {
        String script = configuration.getAttribute("mainScript", null);
        if (script == null) {
            return null;
        }
        return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(script);
    }

    public String[] getScriptArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("scriptArguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        return DebugPlugin.parseArguments((String)args);
    }

    protected final String[] getInterpreterArguments(ILaunchConfiguration configuration) throws CoreException {
        String arguments = configuration.getAttribute("interpreterArguments", "");
        String args = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(arguments);
        return DebugPlugin.parseArguments((String)args);
    }

    public Map getInterpreterSpecificAttributesMap(ILaunchConfiguration configuration) throws CoreException {
        Map map = configuration.getAttribute("interpreterTypeSpecificAttrs", null);
        return map;
    }

    public File getWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        return this.verifyWorkingDirectory(configuration);
    }

    public IPath getWorkingDirectoryPath(ILaunchConfiguration configuration) throws CoreException {
        String path = configuration.getAttribute("workingDir", null);
        if (path != null) {
            path = VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(path);
            return new Path(path);
        }
        return null;
    }

    public File verifyWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IPath path = this.getWorkingDirectoryPath(configuration);
        if (path == null) {
            File dir = this.getDefaultWorkingDirectory(configuration);
            if (dir != null) {
                if (!dir.isDirectory()) {
                    this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{dir.toString()}), null, 108);
                }
                return dir;
            }
        } else if (path.isAbsolute()) {
            File dir = new File(path.toOSString());
            if (dir.isDirectory()) {
                return dir;
            }
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{path.toString()}), null, 108);
        } else {
            IResource res = ResourcesPlugin.getWorkspace().getRoot().findMember(path);
            if (res instanceof IContainer && res.exists()) {
                return res.getLocation().toFile();
            }
            this.abort(MessageFormat.format((String)LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Working_directory_does_not_exist___0__12, (Object[])new String[]{path.toString()}), null, 108);
        }
        return null;
    }

    public String verifyMainScriptName(ILaunchConfiguration configuration) throws CoreException {
        String name = this.getMainScriptName(configuration);
        if (name == null) {
            this.abort(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_Main_type_not_specified_11, null, 106);
        }
        return name;
    }

    protected String getScriptLaunchPath(ILaunchConfiguration configuration) throws CoreException {
        String mainScriptName = this.verifyMainScriptName(configuration);
        IProject project = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration).getProject();
        return String.valueOf(project.getLocation().toPortableString()) + '/' + mainScriptName;
    }

    protected InterpreterConfig createInterpreterConfig(ILaunchConfiguration configuration, ILaunch launch) throws CoreException {
        File mainScript = new File(this.getScriptLaunchPath(configuration));
        File workingDirectory = this.getWorkingDirectory(configuration);
        InterpreterConfig config = new InterpreterConfig(mainScript, workingDirectory);
        String[] scriptArgs = this.getScriptArguments(configuration);
        config.addScriptArgs(scriptArgs);
        String[] interpreterArgs = this.getInterpreterArguments(configuration);
        config.addInterpreterArgs(interpreterArgs);
        config.addEnvVars(DebugPlugin.getDefault().getLaunchManager().getNativeEnvironmentCasePreserved());
        return config;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        try {
            try {
                IInterpreterRunner runner;
                InterpreterConfig config;
                block13: {
                    block12: {
                        block11: {
                            monitor.beginTask(String.valueOf(configuration.getName()) + " ...", 3);
                            if (!monitor.isCanceled()) break block11;
                            break block12;
                        }
                        config = this.createInterpreterConfig(configuration, launch);
                        if (monitor.isCanceled()) break block12;
                        monitor.worked(1);
                        runner = this.getInterpreterRunner(configuration, mode);
                        if (!monitor.isCanceled()) break block13;
                    }
                    Object var8_5 = null;
                    monitor.done();
                    return;
                }
                monitor.worked(1);
                this.runRunner(configuration, runner, config, launch, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            catch (CoreException e) {
                IStatus status = e.getStatus();
                IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler(status);
                if (handler == null) {
                    throw e;
                }
                handler.handleStatus(status, (Object)this);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            monitor.done();
            throw throwable;
        }
        monitor.done();
    }

    protected void runRunner(ILaunchConfiguration configuration, IInterpreterRunner runner, InterpreterConfig config, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        runner.run(config, launch, monitor);
    }

    protected String getWorkingDir(ILaunchConfiguration configuration) throws CoreException {
        File workingDir = this.verifyWorkingDirectory(configuration);
        String workingDirName = null;
        if (workingDir != null) {
            workingDirName = workingDir.getAbsolutePath();
        }
        return workingDirName;
    }

    protected IPath[] createBuildPath(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<Path> paths = new ArrayList<Path>();
        String[] buildpath = this.getBuildpath(configuration);
        int i = 0;
        while (i < buildpath.length) {
            paths.add(new Path(buildpath[i]));
            ++i;
        }
        String[] bootpath = this.getBootpath(configuration);
        if (bootpath != null) {
            int i2 = 0;
            while (i2 < bootpath.length) {
                paths.add(new Path(bootpath[i2]));
                ++i2;
            }
        }
        return paths.toArray(new IPath[paths.size()]);
    }

    protected String createNativeBuildPath(IPath[] paths) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < paths.length) {
            sb.append(paths[i].toOSString());
            if (i < paths.length - 1) {
                sb.append(':');
            }
            ++i;
        }
        return sb.toString();
    }

    protected IProject[] getBuildOrder(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected IProject[] getProjectsForProblemSearch(ILaunchConfiguration configuration, String mode) throws CoreException {
        return this.fOrderedProjects;
    }

    protected boolean isLaunchProblem(IMarker problemMarker) throws CoreException {
        return super.isLaunchProblem(problemMarker) && problemMarker.getType().equals("org.eclipse.dltk.core.problem");
    }

    public boolean preLaunchCheck(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        if (monitor != null) {
            monitor.subTask(LaunchingMessages.AbstractScriptLaunchConfigurationDelegate_20);
        }
        this.fOrderedProjects = null;
        IScriptProject scriptProject = ScriptRuntime.getScriptProject(configuration);
        if (scriptProject != null) {
            this.fOrderedProjects = this.computeReferencedBuildOrder(new IProject[]{scriptProject.getProject()});
        }
        return super.preLaunchCheck(configuration, mode, monitor);
    }

    protected IBreakpoint[] getBreakpoints(ILaunchConfiguration configuration) {
        return new IBreakpoint[0];
    }

    public IInterpreterRunner getInterpreterRunner(ILaunchConfiguration configuration, String mode) throws CoreException {
        IInterpreterInstall install = this.verifyInterpreterInstall(configuration);
        IInterpreterRunner runner = install.getInterpreterRunner(mode);
        if (runner == null) {
            this.abort(MessageFormat.format((String)LaunchingMessages.ScriptLaunchConfigurationDelegate_0, (Object[])new String[]{install.getName(), mode}), null, 107);
        }
        return runner;
    }

    public String[] getEnvironment(ILaunchConfiguration configuration) throws CoreException {
        return DebugPlugin.getDefault().getLaunchManager().getEnvironment(configuration);
    }

    public String[] getScriptLibraryPath(ILaunchConfiguration configuration) throws CoreException {
        String[] paths;
        IScriptProject project = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration);
        if (project != null && (paths = ScriptRuntime.computeScriptLibraryPath(project, true)).length > 0) {
            return paths;
        }
        return null;
    }

    protected File getDefaultWorkingDirectory(ILaunchConfiguration configuration) throws CoreException {
        IScriptProject jp = AbstractScriptLaunchConfigurationDelegate.getScriptProject(configuration);
        if (jp != null) {
            IProject p = jp.getProject();
            return p.getLocation().toFile();
        }
        return null;
    }

    public abstract String getLanguageId();
}

