/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.parsers.raw;

import org.eclipse.dltk.tcl.internal.parsers.raw.CodeScanner;
import org.eclipse.dltk.tcl.internal.parsers.raw.ErrorDescription;
import org.eclipse.dltk.tcl.internal.parsers.raw.ISubstitution;
import org.eclipse.dltk.tcl.internal.parsers.raw.SimpleTclParser;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclElement;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclParseException;
import org.eclipse.dltk.tcl.internal.parsers.raw.TclTextUtils;

public class BracesSubstitution
extends TclElement
implements ISubstitution {
    public static boolean iAm(CodeScanner scanner) {
        int c = scanner.read();
        if (c == -1) {
            return false;
        }
        scanner.unread();
        return c == 123;
    }

    public boolean readMe(CodeScanner input) throws TclParseException {
        if (!BracesSubstitution.iAm(input)) {
            return false;
        }
        this.setStart(input.getPosition());
        input.read();
        int nest = 1;
        while (nest > 0) {
            int c = input.read();
            if (c == -1) {
                SimpleTclParser.handleError(new ErrorDescription("unexpected eof while processing braces started at " + this.getStart(), -1, 0));
                break;
            }
            if (c == 92) {
                c = input.read();
                if (c == 123 || c == 125) continue;
                if (c == 13) {
                    int c1 = input.read();
                    if (c1 == 10) {
                        while ((c = input.read()) != -1 && TclTextUtils.isTrueWhitespace(c)) {
                        }
                        input.unread();
                        continue;
                    }
                    input.unread();
                }
            }
            if (c == 123) {
                ++nest;
                continue;
            }
            if (c != 125) continue;
            --nest;
        }
        if (!input.isEOF()) {
            this.setEnd(input.getPosition() - 1);
        } else {
            this.setEnd(input.getPosition());
        }
        return true;
    }
}

