/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ui.templates;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.dltk.ui.templates.ScriptTemplateContextType;
import org.eclipse.dltk.ui.text.completion.ScriptContentAssistInvocationContext;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateCompletionProcessor;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateException;
import org.eclipse.jface.text.templates.TemplateProposal;

public abstract class ScriptTempalteCompletionProcessor
extends TemplateCompletionProcessor {
    private static final Comparator comaparator = new ProposalComparator();
    private ScriptContentAssistInvocationContext context;

    public ScriptTempalteCompletionProcessor(ScriptContentAssistInvocationContext context) {
        if (context == null) {
            throw new IllegalArgumentException();
        }
        this.context = context;
    }

    protected ScriptContentAssistInvocationContext getContext() {
        return this.context;
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        String prefix;
        Region region;
        TemplateContext context;
        ITextSelection selection = (ITextSelection)viewer.getSelectionProvider().getSelection();
        if (selection.getOffset() == offset) {
            offset = selection.getOffset() + selection.getLength();
        }
        if ((context = this.createContext(viewer, (IRegion)(region = new Region(offset - (prefix = this.extractPrefix(viewer, offset)).length(), prefix.length())))) == null) {
            return new ICompletionProposal[0];
        }
        context.setVariable("selection", selection.getText());
        Template[] templates = this.getTemplates(context.getContextType().getId());
        ArrayList<ICompletionProposal> matches = new ArrayList<ICompletionProposal>();
        int i = 0;
        while (i < templates.length) {
            block6: {
                Template template = templates[i];
                try {
                    context.getContextType().validate(template.getPattern());
                }
                catch (TemplateException templateException) {
                    break block6;
                }
                if (template.getName().startsWith(prefix) && template.matches(prefix, context.getContextType().getId())) {
                    matches.add(this.createProposal(template, context, (IRegion)region, this.getRelevance(template, prefix)));
                }
            }
            ++i;
        }
        Collections.sort(matches, comaparator);
        return matches.toArray(new ICompletionProposal[matches.size()]);
    }

    protected TemplateContext createContext(ITextViewer viewer, IRegion region) {
        TemplateContextType contextType = this.getContextType(viewer, region);
        if (contextType instanceof ScriptTemplateContextType) {
            IDocument document = viewer.getDocument();
            return ((ScriptTemplateContextType)contextType).createContext(document, region.getOffset(), region.getLength(), this.getContext().getSourceModule());
        }
        return super.createContext(viewer, region);
    }

    private static final class ProposalComparator
    implements Comparator {
        private ProposalComparator() {
        }

        public int compare(Object o1, Object o2) {
            return ((TemplateProposal)o2).getRelevance() - ((TemplateProposal)o1).getRelevance();
        }
    }
}

