/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.core.codeassist;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.declarations.Argument;
import org.eclipse.dltk.ast.declarations.MethodDeclaration;
import org.eclipse.dltk.ast.declarations.ModuleDeclaration;
import org.eclipse.dltk.ast.declarations.TypeDeclaration;
import org.eclipse.dltk.ast.expressions.CallExpression;
import org.eclipse.dltk.ast.references.ConstantReference;
import org.eclipse.dltk.ast.references.VariableReference;
import org.eclipse.dltk.codeassist.IAssistParser;
import org.eclipse.dltk.codeassist.ScriptSelectionEngine;
import org.eclipse.dltk.compiler.env.ISourceModule;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.IField;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.core.mixin.IMixinElement;
import org.eclipse.dltk.core.search.SearchMatch;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.ruby.ast.RubyAssignment;
import org.eclipse.dltk.ruby.ast.RubyColonExpression;
import org.eclipse.dltk.ruby.ast.RubySuperExpression;
import org.eclipse.dltk.ruby.core.model.FakeField;
import org.eclipse.dltk.ruby.core.utils.RubySyntaxUtils;
import org.eclipse.dltk.ruby.internal.core.codeassist.RubySelectionParser;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinClass;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinElementInfo;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinMethod;
import org.eclipse.dltk.ruby.internal.parser.mixin.RubyMixinModel;
import org.eclipse.dltk.ruby.internal.parsers.jruby.ASTUtils;
import org.eclipse.dltk.ruby.typeinference.RubyClassType;
import org.eclipse.dltk.ruby.typeinference.RubyModelUtils;
import org.eclipse.dltk.ruby.typeinference.RubyTypeInferencingUtils;
import org.eclipse.dltk.ruby.typeinference.evaluators.ColonExpressionEvaluator;
import org.eclipse.dltk.ruby.typeinference.evaluators.ConstantReferenceEvaluator;
import org.eclipse.dltk.ruby.typeinference.goals.NonTypeConstantTypeGoal;
import org.eclipse.dltk.ti.BasicContext;
import org.eclipse.dltk.ti.DLTKTypeInferenceEngine;
import org.eclipse.dltk.ti.GoalState;
import org.eclipse.dltk.ti.IContext;
import org.eclipse.dltk.ti.goals.AbstractTypeGoal;
import org.eclipse.dltk.ti.goals.ExpressionTypeGoal;
import org.eclipse.dltk.ti.goals.IGoal;
import org.eclipse.dltk.ti.types.IEvaluatedType;

public class RubySelectionEngine
extends ScriptSelectionEngine {
    public static boolean DEBUG = DLTKCore.DEBUG_SELECTION;
    protected int actualSelectionStart;
    protected int actualSelectionEnd;
    private Set selectionElements = new HashSet();
    private RubySelectionParser parser = new RubySelectionParser();
    private ISourceModule sourceModule;
    private ASTNode[] wayToNode;
    private DLTKTypeInferenceEngine inferencer = new DLTKTypeInferenceEngine();

    private TypeDeclaration getEnclosingType(ASTNode node) {
        return ASTUtils.getEnclosingType(this.wayToNode, node, true);
    }

    private CallExpression getEnclosingCallNode(ASTNode node) {
        return ASTUtils.getEnclosingCallNode(this.wayToNode, node, true);
    }

    public IAssistParser getParser() {
        return null;
    }

    public IModelElement[] select(ISourceModule sourceUnit, int selectionSourceStart, int selectionSourceEnd) {
        block21: {
            this.sourceModule = (ISourceModule)sourceUnit.getModelElement();
            String source = sourceUnit.getSourceContents();
            if (DEBUG) {
                System.out.print("SELECTION IN ");
                System.out.print(sourceUnit.getFileName());
                System.out.print(" FROM ");
                System.out.print(selectionSourceStart);
                System.out.print(" TO ");
                System.out.println(selectionSourceEnd);
                System.out.println("SELECTION - Source :");
                System.out.println(source);
            }
            if (selectionSourceStart > selectionSourceEnd) {
                int x = selectionSourceEnd;
                selectionSourceEnd = selectionSourceStart;
                selectionSourceStart = x;
            }
            if (!this.checkSelection(source, selectionSourceStart, selectionSourceEnd)) {
                return new IModelElement[0];
            }
            --this.actualSelectionEnd;
            if (DEBUG) {
                System.out.print("SELECTION - Checked : \"");
                System.out.print(source.substring(this.actualSelectionStart, this.actualSelectionEnd + 1));
                System.out.println('\"');
            }
            try {
                ModuleDeclaration parsedUnit = this.parser.parse(sourceUnit);
                if (parsedUnit != null) {
                    ASTNode node;
                    if (DEBUG) {
                        System.out.println("SELECTION - AST :");
                        System.out.println(parsedUnit.toString());
                    }
                    if ((node = ASTUtils.findMinimalNode(parsedUnit, this.actualSelectionStart, this.actualSelectionEnd)) == null) {
                        return new IModelElement[0];
                    }
                    this.wayToNode = ASTUtils.restoreWayToNode(parsedUnit, node);
                    org.eclipse.dltk.core.ISourceModule modelModule = (org.eclipse.dltk.core.ISourceModule)this.sourceModule.getModelElement();
                    if (node instanceof TypeDeclaration) {
                        TypeDeclaration typeDeclaration = (TypeDeclaration)node;
                        this.selectionOnTypeDeclaration(parsedUnit, typeDeclaration);
                    } else if (node instanceof MethodDeclaration) {
                        MethodDeclaration methodDeclaration = (MethodDeclaration)node;
                        this.selectionOnMethodDeclaration(parsedUnit, methodDeclaration);
                    } else if (node instanceof ConstantReference || node instanceof RubyColonExpression) {
                        this.selectTypes(modelModule, parsedUnit, node);
                    } else if (node instanceof VariableReference) {
                        this.selectionOnVariable(modelModule, parsedUnit, (VariableReference)node);
                    } else if (node instanceof RubySuperExpression) {
                        RubySuperExpression superExpr = (RubySuperExpression)node;
                        this.selectOnSuper(modelModule, parsedUnit, superExpr);
                    } else {
                        CallExpression parentCall = this.getEnclosingCallNode(node);
                        if (parentCall != null) {
                            this.selectOnMethod(modelModule, parsedUnit, parentCall);
                        }
                    }
                }
            }
            catch (IndexOutOfBoundsException e) {
                if (!DEBUG) break block21;
                System.out.println("Exception caught by RubySelectionEngine:");
                e.printStackTrace(System.out);
            }
        }
        ArrayList<IModelElement> resultElements = new ArrayList<IModelElement>();
        Iterator iterator = this.selectionElements.iterator();
        while (iterator.hasNext()) {
            IModelElement element = (IModelElement)iterator.next();
            if (!sourceUnit.getModelElement().getScriptProject().equals(element.getScriptProject())) continue;
            resultElements.add(element);
        }
        return resultElements.toArray(new IModelElement[resultElements.size()]);
    }

    private void selectOnSuper(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration parsedUnit, RubySuperExpression superExpr) {
        RubyClassType selfClass = RubyTypeInferencingUtils.determineSelfClass(modelModule, parsedUnit, superExpr.sourceStart());
        MethodDeclaration enclosingMethod = ASTUtils.getEnclosingMethod(this.wayToNode, superExpr, false);
        if (enclosingMethod != null) {
            String name = enclosingMethod.getName();
            RubyMixinClass rubyClass = RubyMixinModel.getInstance().createRubyClass(selfClass);
            RubyMixinClass superclass = rubyClass.getSuperclass();
            RubyMixinMethod method = superclass.getMethod(name);
            if (method != null) {
                IMethod[] sourceMethods = method.getSourceMethods();
                int i = 0;
                while (i < sourceMethods.length) {
                    this.selectionElements.add(sourceMethods[i]);
                    ++i;
                }
            }
        }
    }

    private void selectOnColonExpression(ModuleDeclaration parsedUnit, RubyColonExpression node, org.eclipse.dltk.core.ISourceModule modelModule) {
        BasicContext basicContext = new BasicContext((org.eclipse.dltk.core.ISourceModule)this.sourceModule, parsedUnit);
        ColonExpressionEvaluator evaluator = new ColonExpressionEvaluator((IGoal)new ExpressionTypeGoal((IContext)basicContext, (ASTNode)node));
        IGoal[] init = evaluator.init();
        if (init != null && init.length != 0) {
            IEvaluatedType leftType = this.inferencer.evaluateType((AbstractTypeGoal)init[0], -1);
            IGoal[] goals = evaluator.subGoalDone(init[0], leftType, GoalState.DONE);
            if (goals == null || goals.length == 0) {
                RubyMixinClass mixinClass;
                Object evaluatedType = evaluator.produceResult();
                if (evaluatedType instanceof RubyClassType && (mixinClass = RubyMixinModel.getInstance().createRubyClass((RubyClassType)((Object)evaluatedType))) != null) {
                    this.selectionElements.addAll(Arrays.asList(mixinClass.getSourceTypes()));
                }
            } else if (goals[0] instanceof NonTypeConstantTypeGoal) {
                this.processNonTypeConstant((NonTypeConstantTypeGoal)goals[0]);
            }
        }
    }

    private void processNonTypeConstant(NonTypeConstantTypeGoal ngoal) {
        IMixinElement element = ngoal.getElement();
        if (element != null) {
            Object[] eObjects = element.getAllObjects();
            int i = 0;
            while (i < eObjects.length) {
                RubyMixinElementInfo info;
                Object obj;
                if (eObjects[i] instanceof RubyMixinElementInfo && (obj = (info = (RubyMixinElementInfo)eObjects[i]).getObject()) instanceof IModelElement) {
                    this.selectionElements.add(obj);
                }
                ++i;
            }
        }
    }

    private void selectOnConstant(ModuleDeclaration parsedUnit, ConstantReference node, org.eclipse.dltk.core.ISourceModule modelModule) {
        BasicContext basicContext = new BasicContext((org.eclipse.dltk.core.ISourceModule)this.sourceModule, parsedUnit);
        ConstantReferenceEvaluator evaluator = new ConstantReferenceEvaluator((IGoal)new ExpressionTypeGoal((IContext)basicContext, (ASTNode)node));
        IGoal[] init = evaluator.init();
        if (init == null || init.length == 0) {
            RubyMixinClass mixinClass;
            Object evaluatedType = evaluator.produceResult();
            if (evaluatedType instanceof RubyClassType && (mixinClass = RubyMixinModel.getInstance().createRubyClass((RubyClassType)((Object)evaluatedType))) != null) {
                this.selectionElements.addAll(Arrays.asList(mixinClass.getSourceTypes()));
            }
        } else if (init[0] instanceof NonTypeConstantTypeGoal) {
            this.processNonTypeConstant((NonTypeConstantTypeGoal)init[0]);
        }
    }

    protected boolean checkSelection(String source, int start, int end) {
        String str;
        if (start - 1 == end) {
            ISourceRange range = RubySyntaxUtils.getEnclosingName(source, start);
            if (range != null) {
                this.actualSelectionStart = range.getOffset();
                this.actualSelectionEnd = this.actualSelectionStart + range.getLength();
            }
            ISourceRange range2 = RubySyntaxUtils.insideMethodOperator(source, start);
            if (range != null && (range2 == null || range2.getLength() < range.getLength())) {
                return true;
            }
            if (range2 != null) {
                this.actualSelectionStart = range2.getOffset();
                this.actualSelectionEnd = this.actualSelectionStart + range2.getLength();
                return true;
            }
        } else if (start >= 0 && end < source.length() && RubySyntaxUtils.isRubyName(str = source.substring(start, end + 1))) {
            this.actualSelectionStart = start;
            this.actualSelectionEnd = end + 1;
            return true;
        }
        return false;
    }

    private void selectTypes(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration parsedUnit, ASTNode node) {
        if (node instanceof ConstantReference) {
            this.selectOnConstant(parsedUnit, (ConstantReference)node, modelModule);
        } else if (node instanceof RubyColonExpression) {
            this.selectOnColonExpression(parsedUnit, (RubyColonExpression)node, modelModule);
        }
        if (this.selectionElements.isEmpty()) {
            TypeNameMatchRequestor requestor = new TypeNameMatchRequestor(){

                public void acceptTypeNameMatch(TypeNameMatch match) {
                    RubySelectionEngine.this.selectionElements.add(match.getType());
                }
            };
            String unqualifiedName = null;
            if (node instanceof RubyColonExpression) {
                RubyColonExpression expr = (RubyColonExpression)node;
                unqualifiedName = expr.getName();
            } else if (node instanceof ConstantReference) {
                ConstantReference expr = (ConstantReference)node;
                unqualifiedName = expr.getName();
            }
            if (unqualifiedName != null) {
                ScriptModelUtil.searchTypeDeclarations((IScriptProject)modelModule.getScriptProject(), (String)unqualifiedName, (TypeNameMatchRequestor)requestor);
            }
        }
    }

    private void selectionOnVariable(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration parsedUnit, VariableReference e) {
        String name = e.getName();
        if (name.startsWith("@")) {
            IField[] fields = RubyModelUtils.findFields(modelModule, parsedUnit, name, e.sourceStart());
            int i = 0;
            while (i < fields.length) {
                this.selectionElements.add(fields[i]);
                ++i;
            }
        } else {
            MethodDeclaration parentScope = null;
            MethodDeclaration methodDeclaration = ASTUtils.getEnclosingMethod(this.wayToNode, (ASTNode)e, false);
            if (methodDeclaration != null) {
                List arguments = methodDeclaration.getArguments();
                Iterator iterator = arguments.iterator();
                while (iterator.hasNext()) {
                    Argument arg = (Argument)iterator.next();
                    if (!arg.getName().equals(name)) continue;
                    this.selectionElements.add(this.createLocalVariable(name, arg.sourceStart(), arg.sourceEnd()));
                    return;
                }
                parentScope = methodDeclaration;
            } else if (this.wayToNode.length >= 2) {
                parentScope = this.wayToNode[this.wayToNode.length - 2];
            }
            if (parentScope != null) {
                RubyAssignment[] assignments = RubyTypeInferencingUtils.findLocalVariableAssignments(parentScope, (ASTNode)e, name);
                if (assignments.length > 0) {
                    RubyAssignment assignment = assignments[0];
                    this.selectionElements.add(this.createLocalVariable(name, assignment.getLeft().sourceStart(), assignment.getLeft().sourceEnd()));
                } else {
                    this.selectionElements.add(this.createLocalVariable(name, e.sourceStart(), e.sourceEnd()));
                }
            }
        }
    }

    private IField createLocalVariable(String name, int nameStart, int nameEnd) {
        return new FakeField((ModelElement)this.sourceModule, name, nameStart, nameEnd - nameStart);
    }

    private IType[] getSourceTypesForClass(ModuleDeclaration parsedUnit, ASTNode statement) {
        RubyMixinClass mixinClass;
        ExpressionTypeGoal typeGoal = new ExpressionTypeGoal((IContext)new BasicContext((org.eclipse.dltk.core.ISourceModule)this.sourceModule, parsedUnit), statement);
        IEvaluatedType evaluatedType = this.inferencer.evaluateType((AbstractTypeGoal)typeGoal, 5000);
        if (evaluatedType instanceof RubyClassType && (mixinClass = RubyMixinModel.getInstance().createRubyClass((RubyClassType)evaluatedType)) != null) {
            return mixinClass.getSourceTypes();
        }
        return new IType[0];
    }

    private void selectionOnTypeDeclaration(ModuleDeclaration parsedUnit, TypeDeclaration typeDeclaration) {
        IModelElement elementAt = null;
        try {
            elementAt = ((org.eclipse.dltk.core.ISourceModule)this.sourceModule).getElementAt(typeDeclaration.sourceStart() + 1);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        if (elementAt != null) {
            this.selectionElements.add(elementAt);
        }
    }

    private void selectionOnMethodDeclaration(ModuleDeclaration parsedUnit, MethodDeclaration methodDeclaration) {
        IModelElement elementAt = null;
        try {
            elementAt = ((org.eclipse.dltk.core.ISourceModule)this.sourceModule).getElementAt(methodDeclaration.sourceStart() + 1);
        }
        catch (ModelException e) {
            e.printStackTrace();
        }
        if (elementAt != null) {
            this.selectionElements.add(elementAt);
        }
    }

    private void selectOnMethod(org.eclipse.dltk.core.ISourceModule modelModule, ModuleDeclaration parsedUnit, CallExpression parentCall) {
        String methodName = parentCall.getName();
        ASTNode receiver = parentCall.getReceiver();
        IMethod[] availableMethods = null;
        IMethod[] availableMethods2 = null;
        if (receiver == null) {
            RubyClassType type = RubyTypeInferencingUtils.determineSelfClass(modelModule, parsedUnit, parentCall.sourceStart());
            availableMethods = RubyModelUtils.searchClassMethods(modelModule, parsedUnit, (IEvaluatedType)type, methodName);
        } else {
            ExpressionTypeGoal goal = new ExpressionTypeGoal((IContext)new BasicContext(modelModule, parsedUnit), receiver);
            IEvaluatedType type = this.inferencer.evaluateType((AbstractTypeGoal)goal, 5000);
            availableMethods = RubyModelUtils.searchClassMethods(modelModule, parsedUnit, type, methodName);
            if (receiver instanceof VariableReference) {
                availableMethods2 = RubyModelUtils.getSingletonMethods((VariableReference)receiver, parsedUnit, modelModule, methodName);
            }
        }
        if (availableMethods2 != null) {
            IMethod[] newm = new IMethod[(availableMethods != null ? availableMethods.length : 0) + availableMethods2.length];
            int next = 0;
            if (availableMethods != null) {
                System.arraycopy(availableMethods, 0, newm, 0, availableMethods.length);
                next = availableMethods.length;
            }
            System.arraycopy(availableMethods2, 0, newm, next, availableMethods2.length);
            availableMethods = newm;
        }
        if (availableMethods == null || availableMethods.length == 0) {
            final ArrayList methods = new ArrayList();
            SearchRequestor requestor = new SearchRequestor(){

                public void acceptSearchMatch(SearchMatch match) throws CoreException {
                    IModelElement modelElement = (IModelElement)match.getElement();
                    org.eclipse.dltk.core.ISourceModule sm = (org.eclipse.dltk.core.ISourceModule)modelElement.getAncestor(5);
                    IModelElement elementAt = sm.getElementAt(match.getOffset());
                    methods.add(elementAt);
                }
            };
            ScriptModelUtil.searchMethodDeclarations((IScriptProject)modelModule.getScriptProject(), (String)methodName, (SearchRequestor)requestor);
            availableMethods = methods.toArray(new IMethod[methods.size()]);
        }
        if (availableMethods != null) {
            int count = 0;
            int i = 0;
            while (i < availableMethods.length) {
                if (availableMethods[i].getElementName().equals(methodName)) {
                    this.selectionElements.add(availableMethods[i]);
                    ++count;
                }
                ++i;
            }
        }
    }
}

