/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.tcl.internal.ui.text.completion;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.core.IScriptProject;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.ui.text.completion.ScriptTypeCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.contentassist.ContextInformation;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension4;
import org.eclipse.jface.text.contentassist.IContextInformation;

public class TclOverrideCompletionProposal
extends ScriptTypeCompletionProposal
implements ICompletionProposalExtension4 {
    private String methodName;

    public TclOverrideCompletionProposal(IScriptProject project, ISourceModule cu, String methodName, String[] paramTypes, int start, int length, String displayName, String completionProposal) {
        super(completionProposal, cu, start, length, null, displayName, 0);
        Assert.isNotNull((Object)project);
        Assert.isNotNull((Object)methodName);
        Assert.isNotNull((Object)paramTypes);
        Assert.isNotNull((Object)cu);
        this.methodName = methodName;
        this.setReplacementString(completionProposal);
    }

    public CharSequence getPrefixCompletionText(IDocument document, int completionOffset) {
        return this.methodName;
    }

    protected boolean updateReplacementString(IDocument document, char trigger, int offset) throws CoreException, BadLocationException {
        Document buffer = new Document(document.get());
        int index = offset - 1;
        while (index >= 0 && Character.isJavaIdentifierPart(buffer.getChar(index))) {
            --index;
        }
        int length = offset - index - 1;
        buffer.replace(index + 1, length, " ");
        return true;
    }

    public boolean isAutoInsertable() {
        return false;
    }

    public IContextInformation getContextInformation() {
        return new ContextInformation(this.getDisplayString(), this.getDisplayString());
    }
}

