/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.core.search;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.IType;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.WorkingCopyOwner;
import org.eclipse.dltk.core.search.BasicSearchEngine;
import org.eclipse.dltk.core.search.IDLTKSearchScope;
import org.eclipse.dltk.core.search.SearchParticipant;
import org.eclipse.dltk.core.search.SearchPattern;
import org.eclipse.dltk.core.search.SearchRequestor;
import org.eclipse.dltk.core.search.TypeNameMatch;
import org.eclipse.dltk.core.search.TypeNameMatchRequestor;
import org.eclipse.dltk.core.search.TypeNameRequestor;
import org.eclipse.dltk.core.search.indexing.IndexManager;
import org.eclipse.dltk.internal.compiler.env.AccessRuleSet;
import org.eclipse.dltk.internal.core.ModelManager;
import org.eclipse.dltk.internal.core.Openable;
import org.eclipse.dltk.internal.core.search.IndexQueryRequestor;
import org.eclipse.dltk.internal.core.search.PatternSearchJob;
import org.eclipse.dltk.internal.core.search.TypeNameMatchRequestorWrapper;
import org.eclipse.dltk.internal.core.search.TypeNameRequestorWrapper;
import org.eclipse.dltk.internal.core.search.matching.MixinPattern;
import org.eclipse.dltk.internal.core.util.HandleFactory;

public class SearchEngine {
    private static final String SPECIAL_MIXIN = "#special#mixin#";
    private BasicSearchEngine basicEngine;

    public SearchEngine() {
        this.basicEngine = new BasicSearchEngine();
    }

    public SearchEngine(ISourceModule[] workingCopies) {
        int length = workingCopies.length;
        ISourceModule[] units = new ISourceModule[length];
        System.arraycopy(workingCopies, 0, units, 0, length);
        this.basicEngine = new BasicSearchEngine(units);
    }

    public SearchEngine(WorkingCopyOwner workingCopyOwner) {
        this.basicEngine = new BasicSearchEngine(workingCopyOwner);
    }

    public static IDLTKSearchScope createHierarchyScope(IType type) throws ModelException {
        return BasicSearchEngine.createHierarchyScope(type);
    }

    public static IDLTKSearchScope createHierarchyScope(IType type, WorkingCopyOwner owner) throws ModelException {
        return BasicSearchEngine.createHierarchyScope(type, owner);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements) {
        return BasicSearchEngine.createSearchScope(elements);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, boolean includeReferencedProjects) {
        return BasicSearchEngine.createSearchScope(elements, includeReferencedProjects);
    }

    public static IDLTKSearchScope createSearchScope(IModelElement[] elements, int includeMask) {
        return BasicSearchEngine.createSearchScope(elements, includeMask);
    }

    public static TypeNameMatch createTypeNameMatch(IType type, int modifiers) {
        return BasicSearchEngine.createTypeNameMatch(type, modifiers);
    }

    public static IDLTKSearchScope createWorkspaceScope(IDLTKLanguageToolkit toolkit) {
        return BasicSearchEngine.createWorkspaceScope(toolkit);
    }

    public static SearchParticipant getDefaultSearchParticipant() {
        return BasicSearchEngine.getDefaultSearchParticipant();
    }

    public void search(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, SearchRequestor requestor, IProgressMonitor monitor) throws CoreException {
        this.basicEngine.search(pattern, participants, scope, requestor, monitor);
    }

    public List searchSourceOnly(SearchPattern pattern, SearchParticipant[] participants, IDLTKSearchScope scope, IProgressMonitor monitor) throws CoreException {
        return this.basicEngine.searchSourceOnly(pattern, participants, scope, monitor);
    }

    public void searchAllTypeNames(char[] packageExactName, char[] typeName, int matchRule, int searchFor, IDLTKSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        this.searchAllTypeNames(packageExactName, 0, typeName, matchRule, searchFor, scope, nameRequestor, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IDLTKSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameRequestorWrapper requestorWrapper = new TypeNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllTypeNames(packageName, packageMatchRule, typeName, typeMatchRule, searchFor, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[] packageName, int packageMatchRule, char[] typeName, int typeMatchRule, int searchFor, IDLTKSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(packageName, packageMatchRule, typeName, typeMatchRule, searchFor, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, IDLTKSearchScope scope, TypeNameRequestor nameRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameRequestorWrapper requestorWrapper = new TypeNameRequestorWrapper(nameRequestor);
        this.basicEngine.searchAllTypeNames(qualifications, typeNames, 8, 0, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchAllTypeNames(char[][] qualifications, char[][] typeNames, IDLTKSearchScope scope, TypeNameMatchRequestor nameMatchRequestor, int waitingPolicy, IProgressMonitor progressMonitor) throws ModelException {
        TypeNameMatchRequestorWrapper requestorWrapper = new TypeNameMatchRequestorWrapper(nameMatchRequestor, scope);
        this.basicEngine.searchAllTypeNames(qualifications, typeNames, 8, 0, scope, requestorWrapper, waitingPolicy, progressMonitor);
    }

    public void searchDeclarationsOfAccessedFields(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
        this.basicEngine.searchDeclarationsOfAccessedFields(enclosingElement, requestor, monitor);
    }

    public void searchDeclarationsOfReferencedTypes(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
        this.basicEngine.searchDeclarationsOfReferencedTypes(enclosingElement, requestor, monitor);
    }

    public void searchDeclarationsOfSentMessages(IModelElement enclosingElement, SearchRequestor requestor, IProgressMonitor monitor) throws ModelException {
        this.basicEngine.searchDeclarationsOfSentMessages(enclosingElement, requestor, monitor);
    }

    public static ISourceModule[] searchMixinSources(String key, IDLTKLanguageToolkit toolkit, final Map keys) {
        final IDLTKSearchScope scope = SearchEngine.createWorkspaceScope(toolkit);
        final HandleFactory factory = new HandleFactory();
        final ArrayList modules = new ArrayList();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                Openable module;
                if (documentPath.startsWith(SearchEngine.SPECIAL_MIXIN)) {
                    documentPath = documentPath.substring(SearchEngine.SPECIAL_MIXIN.length());
                }
                if (documentPath.indexOf("|") != -1) {
                    documentPath = documentPath.substring(documentPath.indexOf("|") + 1);
                }
                if ((module = factory.createOpenable(documentPath, scope)) instanceof ISourceModule) {
                    modules.add(module);
                }
                if (keys != null) {
                    String val = new String(indexRecord.getIndexKey());
                    if (keys.containsKey(module)) {
                        Set keysList = (Set)keys.get(module);
                        keysList.add(val);
                    } else {
                        HashSet<String> keysList = new HashSet<String>();
                        keysList.add(val);
                        keys.put(module, keysList);
                    }
                }
                return true;
            }
        };
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        MixinPattern pattern = new MixinPattern(key.toCharArray(), 10);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        participant.selectMixinIndexes(pattern, scope);
        indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, searchRequestor), 3, null);
        return modules.toArray(new ISourceModule[modules.size()]);
    }

    public static ISourceModule[] searchMixinSources(String key, IDLTKLanguageToolkit toolkit) {
        return SearchEngine.searchMixinSources(key, toolkit, null);
    }

    public static String[] searchMixinPatterns(String key, IDLTKLanguageToolkit toolkit) {
        IDLTKSearchScope scope = SearchEngine.createWorkspaceScope(toolkit);
        final ArrayList result = new ArrayList();
        IndexQueryRequestor searchRequestor = new IndexQueryRequestor(){

            public boolean acceptIndexMatch(String documentPath, SearchPattern indexRecord, SearchParticipant participant, AccessRuleSet access) {
                String val = new String(indexRecord.getIndexKey());
                if (!result.contains(val)) {
                    result.add(val);
                }
                return true;
            }
        };
        IndexManager indexManager = ModelManager.getModelManager().getIndexManager();
        int flags = 8;
        if (key.indexOf(42) != -1 || key.indexOf(63) != -1) {
            flags |= 2;
        }
        MixinPattern pattern = new MixinPattern(key.toCharArray(), flags);
        SearchParticipant participant = SearchEngine.getDefaultSearchParticipant();
        participant.selectMixinIndexes(pattern, scope);
        indexManager.performConcurrentJob(new PatternSearchJob(pattern, participant, scope, searchRequestor), 3, null);
        return result.toArray(new String[result.size()]);
    }
}

