/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;

public class BasicDLTKExtensionManager {
    public static final String PRIORITY_ATTR = "priority";
    private static final String NATURE_ATTR = "nature";
    private Map extensions;
    private String extensionPoint = null;
    private String identifier = "nature";

    protected void setIdentifierValue(String identifier) {
        this.identifier = identifier;
        if (this.extensions != null) {
            this.extensions = null;
        }
    }

    public BasicDLTKExtensionManager(String extensionPoint) {
        this.extensionPoint = extensionPoint;
        Assert.isNotNull((Object)this.extensionPoint);
    }

    private void initialize() {
        if (this.extensions != null) {
            return;
        }
        this.extensions = new HashMap(5);
        IConfigurationElement[] cfg = Platform.getExtensionRegistry().getConfigurationElementsFor(this.extensionPoint);
        int i = 0;
        while (i < cfg.length) {
            int lev;
            String nature = cfg[i].getAttribute(this.identifier);
            ElementInfo oldInfo = (ElementInfo)this.extensions.get(nature);
            if (oldInfo != null && (lev = this.getLevel(cfg[i])) <= oldInfo.level) {
                ElementInfo e = oldInfo;
                ElementInfo nInfo = this.createNewInfo(cfg[i], null);
                while (e != null) {
                    if (e.oldInfo == null) {
                        e.oldInfo = nInfo;
                    } else {
                        if (nInfo.level < e.oldInfo.level) {
                            e = e.oldInfo;
                            continue;
                        }
                        nInfo.oldInfo = e.oldInfo;
                        e.oldInfo = nInfo;
                    }
                    break;
                }
            } else {
                ElementInfo info = this.createNewInfo(cfg[i], oldInfo);
                this.extensions.put(nature, info);
            }
            ++i;
        }
    }

    private ElementInfo createNewInfo(IConfigurationElement cfg, ElementInfo oldInfo) {
        ElementInfo info = this.createInfo(cfg);
        info.level = this.getLevel(info.config);
        info.oldInfo = oldInfo;
        return info;
    }

    protected ElementInfo getElementInfo(String nature) {
        this.initialize();
        return (ElementInfo)this.extensions.get(nature);
    }

    protected int getLevel(IConfigurationElement config) {
        String priority = config.getAttribute(PRIORITY_ATTR);
        if (priority == null) {
            return 0;
        }
        try {
            int parseInt = Integer.parseInt(priority);
            return parseInt;
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public ElementInfo[] getElementInfos() {
        this.initialize();
        Collection values = this.extensions.values();
        return values.toArray(new ElementInfo[values.size()]);
    }

    protected ElementInfo createInfo(IConfigurationElement config) {
        return new ElementInfo(config);
    }

    public String findScriptNature(IProject project) {
        try {
            String[] natureIds = project.getDescription().getNatureIds();
            int i = 0;
            while (i < natureIds.length) {
                String natureId = natureIds[i];
                if (this.getElementInfo(natureId) != null) {
                    return natureId;
                }
                ++i;
            }
        }
        catch (CoreException coreException) {
            return null;
        }
        return null;
    }

    public static class ElementInfo {
        int level;
        protected IConfigurationElement config;
        public Object object;
        public ElementInfo oldInfo;

        protected ElementInfo(IConfigurationElement config) {
            this.config = config;
        }

        public IConfigurationElement getConfig() {
            return this.config;
        }
    }
}

