/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.core;

import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.core.IMethod;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IScriptFolder;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.internal.core.ModelElement;
import org.eclipse.dltk.internal.core.NamedMember;
import org.eclipse.dltk.internal.core.SourceMethodElementInfo;
import org.eclipse.dltk.utils.CorePrinter;

public class SourceMethod
extends NamedMember
implements IMethod {
    public SourceMethod(ModelElement parent, String name) {
        super(parent, name);
    }

    public int getElementType() {
        return 9;
    }

    public String[] getParameters() throws ModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        if (info != null) {
            return info.getArgumentNames();
        }
        return null;
    }

    public String[] getParameterInitializers() throws ModelException {
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        if (info != null) {
            return info.getArgumentInitializers();
        }
        return null;
    }

    public void printNode(CorePrinter output) {
        output.formatPrint("DLTK Source Method:" + this.getElementName());
        output.indent();
        try {
            IModelElement[] modelElements = this.getChildren();
            int i = 0;
            while (i < modelElements.length) {
                IModelElement element = modelElements[i];
                if (element instanceof ModelElement) {
                    ((ModelElement)element).printNode(output);
                } else {
                    output.print("Unknown element:" + element);
                }
                ++i;
            }
        }
        catch (ModelException ex) {
            output.formatPrint(ex.getLocalizedMessage());
        }
        output.dedent();
    }

    public boolean isConstructor() throws ModelException {
        if (!this.getElementName().equals(this.parent.getElementName())) {
            return false;
        }
        SourceMethodElementInfo info = (SourceMethodElementInfo)this.getElementInfo();
        return info.isConstructor();
    }

    protected char getHandleMementoDelimiter() {
        return '~';
    }

    public String getFullyQualifiedName(String enclosingTypeSeparator) {
        try {
            return this.getFullyQualifiedName(enclosingTypeSeparator, false);
        }
        catch (ModelException modelException) {
            return null;
        }
    }

    public String getFullyQualifiedName() {
        return this.getFullyQualifiedName("$");
    }

    public IScriptFolder getScriptFolder() {
        IModelElement parentElement = this.parent;
        while (parentElement != null) {
            if (parentElement.getElementType() == 4) {
                return (IScriptFolder)parentElement;
            }
            parentElement = parentElement.getParent();
        }
        Assert.isTrue((boolean)false);
        return null;
    }
}

