/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.debug.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.dltk.debug.core.model.IScriptDebugTarget;
import org.eclipse.dltk.debug.ui.ConsoleScriptDebugTargetStreamManager;
import org.eclipse.dltk.internal.debug.core.model.IScriptDebugTargetStreamManager;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IOConsole;

public class DebugConsoleManager
implements ILaunchListener {
    private static DebugConsoleManager instance;
    private Map launchToConsoleMap = new HashMap();

    public static DebugConsoleManager getInstance() {
        if (instance == null) {
            instance = new DebugConsoleManager();
        }
        return instance;
    }

    protected boolean acceptLaunch(ILaunch launch) {
        if (launch == null) {
            return false;
        }
        return launch.getLaunchMode().equals("debug");
    }

    protected IOConsole createConsole(String name) {
        IOConsole console = new IOConsole(name, null);
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.addConsoles(new IConsole[]{console});
        manager.showConsoleView((IConsole)console);
        return console;
    }

    protected void destroyConsole(IOConsole console) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        manager.removeConsoles(new IConsole[]{console});
    }

    protected DebugConsoleManager() {
    }

    public void launchAdded(ILaunch launch) {
        if (!this.acceptLaunch(launch)) {
            return;
        }
        this.launchToConsoleMap.put(launch, this.createConsole("Debug console"));
    }

    public void launchChanged(ILaunch launch) {
        IOConsole console;
        IScriptDebugTarget target;
        if (!this.acceptLaunch(launch)) {
            return;
        }
        if (launch.getDebugTarget() instanceof IScriptDebugTarget && (target = (IScriptDebugTarget)launch.getDebugTarget()) != null && (console = (IOConsole)this.launchToConsoleMap.get(launch)) != null && target.getStreamManager() == null) {
            ConsoleScriptDebugTargetStreamManager manager = new ConsoleScriptDebugTargetStreamManager(console);
            target.setStreamManager((IScriptDebugTargetStreamManager)manager);
        }
    }

    public void launchRemoved(ILaunch launch) {
        if (!this.acceptLaunch(launch)) {
            return;
        }
        IOConsole console = (IOConsole)this.launchToConsoleMap.get(launch);
        this.destroyConsole(console);
        this.launchToConsoleMap.remove(launch);
    }
}

