/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.editor;

import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.dltk.core.DLTKCore;
import org.eclipse.dltk.core.ElementChangedEvent;
import org.eclipse.dltk.core.IDLTKLanguageToolkit;
import org.eclipse.dltk.core.IElementChangedListener;
import org.eclipse.dltk.core.IMember;
import org.eclipse.dltk.core.IModelElement;
import org.eclipse.dltk.core.IModelElementDelta;
import org.eclipse.dltk.core.IParent;
import org.eclipse.dltk.core.ISourceModule;
import org.eclipse.dltk.core.ISourceRange;
import org.eclipse.dltk.core.ISourceReference;
import org.eclipse.dltk.core.ModelException;
import org.eclipse.dltk.core.ScriptModelUtil;
import org.eclipse.dltk.internal.ui.actions.AbstractToggleLinkingAction;
import org.eclipse.dltk.internal.ui.actions.CompositeActionGroup;
import org.eclipse.dltk.internal.ui.dnd.DLTKViewerDragAdapter;
import org.eclipse.dltk.internal.ui.dnd.DelegatingDropAdapter;
import org.eclipse.dltk.internal.ui.editor.DLTKEditorMessages;
import org.eclipse.dltk.internal.ui.editor.ScriptEditor;
import org.eclipse.dltk.internal.ui.editor.TogglePresentationAction;
import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDragAdapter;
import org.eclipse.dltk.internal.ui.scriptview.SelectionTransferDropAdapter;
import org.eclipse.dltk.ui.DLTKPluginImages;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.MembersOrderPreferenceCache;
import org.eclipse.dltk.ui.ModelElementSorter;
import org.eclipse.dltk.ui.ProblemsLabelDecorator;
import org.eclipse.dltk.ui.ScriptElementLabels;
import org.eclipse.dltk.ui.actions.CustomFiltersActionGroup;
import org.eclipse.dltk.ui.actions.MemberFilterActionGroup;
import org.eclipse.dltk.ui.actions.OpenViewActionGroup;
import org.eclipse.dltk.ui.actions.SearchActionGroup;
import org.eclipse.dltk.ui.viewsupport.AppearanceAwareLabelProvider;
import org.eclipse.dltk.ui.viewsupport.DecoratingModelLabelProvider;
import org.eclipse.dltk.ui.viewsupport.SourcePositionSorter;
import org.eclipse.dltk.ui.viewsupport.StatusBarUpdater;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IPostSelectionProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.model.WorkbenchAdapter;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInSource;
import org.eclipse.ui.part.IShowInTarget;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.texteditor.ITextEditorActionConstants;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class ScriptOutlinePage
extends Page
implements IContentOutlinePage,
IAdaptable,
IPostSelectionProvider {
    static Object[] NO_CHILDREN = new Object[0];
    private IModelElement fInput;
    private Menu fMenu;
    protected ScriptOutlineViewer fOutlineViewer;
    private ScriptEditor fEditor;
    protected IPreferenceStore fStore;
    private MemberFilterActionGroup fMemberFilterActionGroup;
    private ListenerList fSelectionChangedListeners = new ListenerList(1);
    private ListenerList fPostSelectionChangedListeners = new ListenerList(1);
    private Hashtable fActions = new Hashtable();
    private TogglePresentationAction fTogglePresentation;
    private ToggleLinkingAction fToggleLinkingAction;
    private CompositeActionGroup fActionGroups;
    private IPropertyChangeListener fPropertyChangeListener;
    private CustomFiltersActionGroup fCustomFiltersActionGroup;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public ScriptOutlinePage(ScriptEditor editor, IPreferenceStore store) {
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fStore = store;
        this.fTogglePresentation = new TogglePresentationAction();
        this.fTogglePresentation.setEditor((ITextEditor)editor);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                ScriptOutlinePage.this.doPropertyChange(event);
            }
        };
        this.fStore.addPropertyChangeListener(this.fPropertyChangeListener);
    }

    protected void addAction(IMenuManager menu, String group, String actionID) {
        IAction action = this.getAction(actionID);
        if (action != null) {
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (action.isEnabled()) {
                IMenuManager subMenu = menu.findMenuUsingPath(group);
                if (subMenu != null) {
                    subMenu.add(action);
                } else {
                    menu.appendToGroup(group, action);
                }
            }
        }
    }

    public void addPostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addPostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.add((Object)listener);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.addSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.add((Object)listener);
        }
    }

    protected void contextMenuAboutToShow(IMenuManager menu) {
        if (menu.isEmpty()) {
            menu.add((IContributionItem)new GroupMarker("group.goto"));
            menu.add((IContributionItem)new Separator("group.open"));
            menu.add((IContributionItem)new GroupMarker("group.show"));
            menu.add((IContributionItem)new Separator("group.edit"));
            menu.add((IContributionItem)new Separator("group.search"));
            menu.add((IContributionItem)new Separator("group.properties"));
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        this.fActionGroups.setContext(new ActionContext((ISelection)selection));
        this.fActionGroups.fillContextMenu(menu);
    }

    protected ILabelDecorator getLabelDecorator() {
        return null;
    }

    public void createControl(Composite parent) {
        Tree tree = new Tree(parent, 2);
        AppearanceAwareLabelProvider lprovider = new AppearanceAwareLabelProvider(0x201000000402BL | ScriptElementLabels.ALL_CATEGORY, 1, this.fStore);
        ILabelDecorator ldecorator = this.getLabelDecorator();
        if (ldecorator != null) {
            lprovider.addLabelDecorator(ldecorator);
        }
        this.fOutlineViewer = new ScriptOutlineViewer(tree);
        this.initDragAndDrop();
        this.fOutlineViewer.setContentProvider((IContentProvider)new ChildrenProvider());
        this.fOutlineViewer.setLabelProvider((IBaseLabelProvider)new DecoratingModelLabelProvider(lprovider));
        Object[] listeners = this.fSelectionChangedListeners.getListeners();
        int i = 0;
        while (i < listeners.length) {
            this.fSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        listeners = this.fPostSelectionChangedListeners.getListeners();
        i = 0;
        while (i < listeners.length) {
            this.fPostSelectionChangedListeners.remove(listeners[i]);
            this.fOutlineViewer.addPostSelectionChangedListener((ISelectionChangedListener)listeners[i]);
            ++i;
        }
        IPageSite site = this.getSite();
        this.updateSelectionProvider(site);
        IDLTKLanguageToolkit toolkit = this.fEditor.getLanguageToolkit();
        this.fActionGroups = new CompositeActionGroup(new ActionGroup[]{new OpenViewActionGroup(this), new SearchActionGroup(this, toolkit)});
        IActionBars actionBars = site.getActionBars();
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.UNDO, this.fEditor.getAction(ITextEditorActionConstants.UNDO));
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.REDO, this.fEditor.getAction(ITextEditorActionConstants.REDO));
        IAction action = this.fEditor.getAction(ITextEditorActionConstants.NEXT);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoNextAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.NEXT, action);
        action = this.fEditor.getAction(ITextEditorActionConstants.PREVIOUS);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.gotoPreviousAnnotation", action);
        actionBars.setGlobalActionHandler(ITextEditorActionConstants.PREVIOUS, action);
        actionBars.setGlobalActionHandler("org.eclipse.ui.edit.text.toggleShowSelectedElementOnly", (IAction)this.fTogglePresentation);
        this.fActionGroups.fillActionBars(actionBars);
        IStatusLineManager statusLineManager = actionBars.getStatusLineManager();
        if (statusLineManager != null) {
            StatusBarUpdater updater = new StatusBarUpdater(statusLineManager);
            this.fOutlineViewer.addPostSelectionChangedListener(updater);
        }
        this.fCustomFiltersActionGroup = new CustomFiltersActionGroup("org.eclipse.dltk.ui.ScriptOutlinePage", (StructuredViewer)this.fOutlineViewer);
        this.registerToolbarActions(actionBars);
        this.fOutlineViewer.setInput(this.fInput);
    }

    public void dispose() {
        if (this.fEditor == null) {
            return;
        }
        if (this.fMemberFilterActionGroup != null) {
            this.fMemberFilterActionGroup.dispose();
            this.fMemberFilterActionGroup = null;
        }
        if (this.fCustomFiltersActionGroup != null) {
            this.fCustomFiltersActionGroup.dispose();
            this.fCustomFiltersActionGroup = null;
        }
        this.fEditor.outlinePageClosed();
        this.fEditor = null;
        this.fSelectionChangedListeners.clear();
        this.fSelectionChangedListeners = null;
        this.fPostSelectionChangedListeners.clear();
        this.fPostSelectionChangedListeners = null;
        if (this.fPropertyChangeListener != null) {
            this.fStore.removePropertyChangeListener(this.fPropertyChangeListener);
            this.fPropertyChangeListener = null;
        }
        if (this.fMenu != null && !this.fMenu.isDisposed()) {
            this.fMenu.dispose();
            this.fMenu = null;
        }
        if (this.fActionGroups != null) {
            this.fActionGroups.dispose();
        }
        this.fTogglePresentation.setEditor(null);
        this.fOutlineViewer = null;
        super.dispose();
    }

    private void doPropertyChange(PropertyChangeEvent event) {
        if (this.fOutlineViewer != null && MembersOrderPreferenceCache.isMemberOrderProperty(event.getProperty())) {
            this.fOutlineViewer.refresh(false);
        }
    }

    public IAction getAction(String actionID) {
        Assert.isNotNull((Object)actionID);
        return (IAction)this.fActions.get(actionID);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.ui.part.IShowInSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz) {
            return this.getShowInSource();
        }
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz2) {
            return new IShowInTargetList(){

                public String[] getShowInTargetIds() {
                    return new String[]{"org.eclipse.dltk.ui.ScriptExplorer"};
                }
            };
        }
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.ui.part.IShowInTarget");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key == clazz3) {
            return this.getShowInTarget();
        }
        return null;
    }

    public Control getControl() {
        if (this.fOutlineViewer != null) {
            return this.fOutlineViewer.getControl();
        }
        return null;
    }

    protected final ScriptOutlineViewer getOutlineViewer() {
        return this.fOutlineViewer;
    }

    public ISelection getSelection() {
        if (this.fOutlineViewer == null) {
            return StructuredSelection.EMPTY;
        }
        return this.fOutlineViewer.getSelection();
    }

    protected IShowInSource getShowInSource() {
        return new IShowInSource(){

            public ShowInContext getShowInContext() {
                return new ShowInContext(null, ScriptOutlinePage.this.getSite().getSelectionProvider().getSelection());
            }
        };
    }

    protected IShowInTarget getShowInTarget() {
        return new IShowInTarget(){

            public boolean show(ShowInContext context) {
                ISelection sel = context.getSelection();
                if (sel instanceof ITextSelection) {
                    ITextSelection tsel = (ITextSelection)sel;
                    int offset = tsel.getOffset();
                    IModelElement element = ScriptOutlinePage.this.fEditor.getElementAt(offset);
                    if (element != null) {
                        ScriptOutlinePage.this.setSelection((ISelection)new StructuredSelection((Object)element));
                        return true;
                    }
                } else if (sel instanceof IStructuredSelection) {
                    ScriptOutlinePage.this.setSelection(sel);
                    return true;
                }
                return false;
            }
        };
    }

    public void init(IPageSite pageSite) {
        super.init(pageSite);
    }

    private void initDragAndDrop() {
        int ops = 7;
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance()};
        TransferDropTargetListener[] dropListeners = new TransferDropTargetListener[]{new SelectionTransferDropAdapter((StructuredViewer)this.fOutlineViewer)};
        this.fOutlineViewer.addDropSupport(ops | 0x10, transfers, new DelegatingDropAdapter(dropListeners));
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)this.fOutlineViewer)};
        this.fOutlineViewer.addDragSupport(ops, transfers, new DLTKViewerDragAdapter((StructuredViewer)this.fOutlineViewer, dragListeners));
    }

    private boolean isInnerType(IModelElement element) {
        IModelElement parent;
        if (element != null && element.getElementType() == 7 && (parent = element.getParent()) != null) {
            int parentElementType = parent.getElementType();
            return parentElementType != 5;
        }
        return false;
    }

    protected void registerSpecialToolbarActions(IActionBars actionBars) {
    }

    private void registerToolbarActions(IActionBars actionBars) {
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        toolBarManager.add((IAction)new LexicalSortingAction());
        this.fMemberFilterActionGroup = new MemberFilterActionGroup((StructuredViewer)this.fOutlineViewer, this.fStore);
        this.fMemberFilterActionGroup.contributeToToolBar(toolBarManager);
        this.fCustomFiltersActionGroup.fillActionBars(actionBars);
        this.registerSpecialToolbarActions(actionBars);
        IMenuManager viewMenuManager = actionBars.getMenuManager();
        viewMenuManager.add((IContributionItem)new Separator("EndFilterGroup"));
        this.fToggleLinkingAction = new ToggleLinkingAction(this);
        viewMenuManager.add((IAction)this.fToggleLinkingAction);
    }

    public void removePostSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removePostSelectionChangedListener(listener);
        } else {
            this.fPostSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.removeSelectionChangedListener(listener);
        } else {
            this.fSelectionChangedListeners.remove((Object)listener);
        }
    }

    public void select(ISourceReference reference) {
        IStructuredSelection ss;
        List elements;
        ISelection s;
        if (this.fOutlineViewer != null && (s = this.fOutlineViewer.getSelection()) instanceof IStructuredSelection && !(elements = (ss = (IStructuredSelection)s).toList()).contains(reference)) {
            s = reference == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)reference);
            this.fOutlineViewer.setSelection(s, true);
        }
    }

    public void setAction(String actionID, IAction action) {
        Assert.isNotNull((Object)actionID);
        if (action == null) {
            this.fActions.remove(actionID);
        } else {
            this.fActions.put(actionID, action);
        }
    }

    public void setFocus() {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.getControl().setFocus();
        }
    }

    public void setInput(IModelElement inputElement) {
        this.fInput = inputElement;
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setInput(this.fInput);
            this.updateSelectionProvider(this.getSite());
        }
    }

    public void setSelection(ISelection selection) {
        if (this.fOutlineViewer != null) {
            this.fOutlineViewer.setSelection(selection);
        }
    }

    private void updateSelectionProvider(IPageSite site) {
        ISourceModule cu;
        Object provider = this.fOutlineViewer;
        if (this.fInput != null && (cu = (ISourceModule)this.fInput.getAncestor(5)) != null && !ScriptModelUtil.isPrimary((ISourceModule)cu)) {
            provider = new EmptySelectionProvider();
        }
        site.setSelectionProvider((ISelectionProvider)provider);
    }

    protected class ChildrenProvider
    implements ITreeContentProvider {
        private ElementChangedListener fListener;

        protected ChildrenProvider() {
        }

        public void dispose() {
            if (this.fListener != null) {
                DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        protected IModelElement[] filter(IModelElement[] children) {
            boolean initializers = false;
            int i = 0;
            while (i < children.length) {
                if (this.matches(children[i])) {
                    initializers = true;
                    break;
                }
                ++i;
            }
            if (!initializers) {
                return children;
            }
            Vector<IModelElement> v = new Vector<IModelElement>();
            int i2 = 0;
            while (i2 < children.length) {
                if (!this.matches(children[i2])) {
                    v.addElement(children[i2]);
                }
                ++i2;
            }
            Object[] result = new IModelElement[v.size()];
            v.copyInto(result);
            return result;
        }

        public Object[] getChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        return this.filter(c.getChildren());
                    }
                    catch (ModelException x) {
                        if (!DLTKCore.DEBUG && x.isDoesNotExist()) break block3;
                        DLTKUIPlugin.log(x);
                    }
                }
            }
            return NO_CHILDREN;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }

        public Object getParent(Object child) {
            if (child instanceof IModelElement) {
                IModelElement e = (IModelElement)child;
                return e.getParent();
            }
            return null;
        }

        public boolean hasChildren(Object parent) {
            block3: {
                if (parent instanceof IParent) {
                    IParent c = (IParent)parent;
                    try {
                        IModelElement[] children = this.filter(c.getChildren());
                        return children != null && children.length > 0;
                    }
                    catch (ModelException x) {
                        if (!DLTKUIPlugin.isDebug() && x.isDoesNotExist()) break block3;
                        DLTKUIPlugin.log(x);
                    }
                }
            }
            return false;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            boolean isCU = newInput instanceof ISourceModule;
            if (isCU && this.fListener == null) {
                this.fListener = new ElementChangedListener();
                DLTKCore.addElementChangedListener((IElementChangedListener)this.fListener);
            } else if (!isCU && this.fListener != null) {
                DLTKCore.removeElementChangedListener((IElementChangedListener)this.fListener);
                this.fListener = null;
            }
        }

        public boolean isDeleted(Object o) {
            return false;
        }

        protected boolean matches(IModelElement element) {
            if (element.getElementType() == 9) {
                String name = element.getElementName();
                return name != null && name.indexOf(60) >= 0;
            }
            return false;
        }
    }

    protected class ElementChangedListener
    implements IElementChangedListener {
        protected ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent e) {
            if (ScriptOutlinePage.this.getControl() == null) {
                return;
            }
            Display d = ScriptOutlinePage.this.getControl().getDisplay();
            if (d != null) {
                d.asyncExec(new Runnable(this, e){
                    final /* synthetic */ ElementChangedListener this$1;
                    private final /* synthetic */ ElementChangedEvent val$e;
                    {
                        this.this$1 = elementChangedListener;
                        this.val$e = elementChangedEvent;
                    }

                    public void run() {
                        ISourceModule cu = (ISourceModule)ScriptOutlinePage.access$0(ElementChangedListener.access$0(this.this$1));
                        ISourceModule base = cu;
                        IModelElementDelta delta = this.this$1.findElement((IModelElement)base, this.val$e.getDelta());
                        if (delta != null && ElementChangedListener.access$0((ElementChangedListener)this.this$1).fOutlineViewer != null) {
                            ElementChangedListener.access$0((ElementChangedListener)this.this$1).fOutlineViewer.reconcile(delta);
                        }
                    }
                });
            }
        }

        protected IModelElementDelta findElement(IModelElement unit, IModelElementDelta delta) {
            if (delta == null || unit == null) {
                return null;
            }
            IModelElement element = delta.getElement();
            if (unit.equals(element)) {
                if (this.isPossibleStructuralChange(delta)) {
                    return delta;
                }
                return null;
            }
            if (element.getElementType() > 5) {
                return null;
            }
            IModelElementDelta[] children = delta.getAffectedChildren();
            if (children == null || children.length == 0) {
                return null;
            }
            int i = 0;
            while (i < children.length) {
                IModelElementDelta d = this.findElement(unit, children[i]);
                if (d != null) {
                    return d;
                }
                ++i;
            }
            return null;
        }

        private boolean isPossibleStructuralChange(IModelElementDelta cuDelta) {
            if (cuDelta.getKind() != 4) {
                return true;
            }
            int flags = cuDelta.getFlags();
            if ((flags & 8) != 0) {
                return true;
            }
            return (flags & 0x4001) == 1;
        }

        static /* synthetic */ ScriptOutlinePage access$0(ElementChangedListener elementChangedListener) {
            return elementChangedListener.ScriptOutlinePage.this;
        }
    }

    private static final class EmptySelectionProvider
    implements ISelectionProvider {
        private EmptySelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public ISelection getSelection() {
            return StructuredSelection.EMPTY;
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        }

        public void setSelection(ISelection selection) {
        }
    }

    class LexicalSortingAction
    extends Action {
        private ModelElementSorter fComparator = new ModelElementSorter();
        private SourcePositionSorter fSourcePositonComparator = new SourcePositionSorter();

        public LexicalSortingAction() {
            this.setText(DLTKEditorMessages.ScriptOutlinePage_Sort_label);
            DLTKPluginImages.setLocalImageDescriptors((IAction)this, "alphab_sort_co.gif");
            this.setToolTipText(DLTKEditorMessages.ScriptOutlinePage_Sort_tooltip);
            this.setDescription(DLTKEditorMessages.ScriptOutlinePage_Sort_description);
            boolean checked = ScriptOutlinePage.this.fStore.getBoolean("LexicalSortingAction.isChecked");
            this.valueChanged(checked, false);
        }

        public void run() {
            this.valueChanged(this.isChecked(), true);
        }

        private void valueChanged(boolean on, boolean store) {
            this.setChecked(on);
            BusyIndicator.showWhile((Display)ScriptOutlinePage.this.fOutlineViewer.getControl().getDisplay(), (Runnable)new Runnable(this, on){
                final /* synthetic */ LexicalSortingAction this$1;
                private final /* synthetic */ boolean val$on;
                {
                    this.this$1 = lexicalSortingAction;
                    this.val$on = bl;
                }

                public void run() {
                    if (this.val$on) {
                        LexicalSortingAction.access$2((LexicalSortingAction)this.this$1).fOutlineViewer.setComparator((ViewerComparator)LexicalSortingAction.access$0(this.this$1));
                    } else {
                        LexicalSortingAction.access$2((LexicalSortingAction)this.this$1).fOutlineViewer.setComparator((ViewerComparator)LexicalSortingAction.access$1(this.this$1));
                    }
                }
            });
            if (store) {
                DLTKUIPlugin.getDefault().getPreferenceStore().setValue("LexicalSortingAction.isChecked", on);
            }
        }

        static /* synthetic */ ModelElementSorter access$0(LexicalSortingAction lexicalSortingAction) {
            return lexicalSortingAction.fComparator;
        }

        static /* synthetic */ SourcePositionSorter access$1(LexicalSortingAction lexicalSortingAction) {
            return lexicalSortingAction.fSourcePositonComparator;
        }

        static /* synthetic */ ScriptOutlinePage access$2(LexicalSortingAction lexicalSortingAction) {
            return lexicalSortingAction.ScriptOutlinePage.this;
        }
    }

    static class NoClassElement
    extends WorkbenchAdapter
    implements IAdaptable {
        NoClassElement() {
        }

        public Object getAdapter(Class clas) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.ui.model.IWorkbenchAdapter");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (clas == clazz) {
                return this;
            }
            return null;
        }

        public String toString() {
            return DLTKEditorMessages.ScriptOutlinePage_error_NoTopLevelType;
        }
    }

    protected class ScriptOutlineViewer
    extends TreeViewer {
        private Item fReusedExpandedItem;
        private boolean fReorderedMembers;
        private boolean fForceFireSelectionChanged;

        public ScriptOutlineViewer(Tree tree) {
            super(tree);
            this.setAutoExpandLevel(-1);
            this.setUseHashlookup(true);
        }

        protected boolean filtered(IModelElement parent, IModelElement child) {
            Object[] result = new Object[]{child};
            ViewerFilter[] filters = this.getFilters();
            int i = 0;
            while (i < filters.length) {
                if ((result = filters[i].filter((Viewer)this, (Object)parent, result)).length == 0) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        protected ISourceRange getSourceRange(IModelElement element) throws ModelException {
            if (element instanceof ISourceReference) {
                return ((ISourceReference)element).getSourceRange();
            }
            if (element instanceof IMember) {
                return ((IMember)element).getNameRange();
            }
            return null;
        }

        private IResource getUnderlyingResource() {
            Object input = this.getInput();
            if (input instanceof ISourceModule) {
                ISourceModule cu = (ISourceModule)input;
                cu = cu.getPrimary();
                return cu.getResource();
            }
            return null;
        }

        protected void handleLabelProviderChanged(LabelProviderChangedEvent event) {
            IResource resource;
            ProblemsLabelDecorator.ProblemsLabelChangedEvent e;
            Object input = this.getInput();
            if (event instanceof ProblemsLabelDecorator.ProblemsLabelChangedEvent && (e = (ProblemsLabelDecorator.ProblemsLabelChangedEvent)event).isMarkerChange() && input instanceof ISourceModule) {
                return;
            }
            Object[] changed = event.getElements();
            if (changed != null && (resource = this.getUnderlyingResource()) != null) {
                int i = 0;
                while (i < changed.length) {
                    if (changed[i] != null && changed[i].equals(resource)) {
                        event = new LabelProviderChangedEvent((IBaseLabelProvider)event.getSource());
                        break;
                    }
                    ++i;
                }
            }
            super.handleLabelProviderChanged(event);
        }

        protected void internalExpandToLevel(Widget node, int level) {
            IModelElement je;
            Item i;
            if (node instanceof Item && (i = (Item)node).getData() instanceof IModelElement && ScriptOutlinePage.this.isInnerType(je = (IModelElement)i.getData()) && i != this.fReusedExpandedItem) {
                this.setExpanded(i, false);
                return;
            }
            super.internalExpandToLevel(node, level);
        }

        public boolean isExpandable(Object element) {
            if (this.hasFilters()) {
                return this.getFilteredChildren(element).length > 0;
            }
            return super.isExpandable(element);
        }

        protected boolean mustUpdateParent(IModelElementDelta delta, IModelElement element) {
            return false;
        }

        protected boolean overlaps(ISourceRange range, int start, int end) {
            return start <= range.getOffset() + range.getLength() - 1 && range.getOffset() <= end;
        }

        public void reconcile(IModelElementDelta delta) {
            this.fReorderedMembers = false;
            this.fForceFireSelectionChanged = false;
            if (this.getComparator() == null) {
                Widget w = this.findItem(ScriptOutlinePage.this.fInput);
                if (w != null && !w.isDisposed()) {
                    this.update(w, delta);
                }
                if (this.fForceFireSelectionChanged) {
                    this.fireSelectionChanged(new SelectionChangedEvent(ScriptOutlinePage.this.getSite().getSelectionProvider(), this.getSelection()));
                }
                if (this.fReorderedMembers) {
                    this.refresh(false);
                    this.fReorderedMembers = false;
                }
            } else {
                this.refresh(true);
            }
        }

        protected void reuseTreeItem(Item item, Object element) {
            Item[] c = this.getChildren((Widget)item);
            if (c != null && c.length > 0) {
                if (this.getExpanded(item)) {
                    this.fReusedExpandedItem = item;
                }
                int k = 0;
                while (k < c.length) {
                    if (c[k].getData() != null) {
                        this.disassociate(c[k]);
                    }
                    c[k].dispose();
                    ++k;
                }
            }
            this.updateItem((Widget)item, element);
            this.updatePlus(item, element);
            this.internalExpandToLevel((Widget)item, -1);
            this.fReusedExpandedItem = null;
            this.fForceFireSelectionChanged = true;
        }

        /*
         * Exception decompiling
         */
        protected void update(Widget w, IModelElementDelta delta) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    public class ToggleLinkingAction
    extends AbstractToggleLinkingAction {
        ScriptOutlinePage fJavaOutlinePage;

        public ToggleLinkingAction(ScriptOutlinePage outlinePage) {
            boolean isLinkingEnabled = DLTKUIPlugin.getDefault().getPreferenceStore().getBoolean("syncOutlineOnCursorMove");
            this.setChecked(isLinkingEnabled);
            this.fJavaOutlinePage = outlinePage;
        }

        public void run() {
            DLTKUIPlugin.getDefault().getPreferenceStore().setValue("syncOutlineOnCursorMove", this.isChecked());
            if (this.isChecked() && ScriptOutlinePage.this.fEditor != null) {
                ScriptOutlinePage.this.fEditor.synchronizeOutlinePage(ScriptOutlinePage.this.fEditor.computeHighlightRangeSourceReference(), false);
            }
        }
    }
}

