/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.internal.ui.refactoring;

import java.util.Arrays;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.dltk.internal.ui.editor.EditorUtility;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.dltk.internal.ui.refactoring.RefactoringSavePreferences;
import org.eclipse.dltk.ui.DLTKUIPlugin;
import org.eclipse.dltk.ui.util.ExceptionHandler;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.actions.GlobalBuildAction;
import org.eclipse.ui.dialogs.ListDialog;

public class RefactoringSaveHelper {
    private boolean fFilesSaved;
    private boolean fAllowSaveAlways;

    public RefactoringSaveHelper(boolean allowSaveAlways) {
        this.fAllowSaveAlways = allowSaveAlways;
    }

    public RefactoringSaveHelper() {
        this(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveEditors(Shell shell) {
        IEditorPart[] dirtyEditors = EditorUtility.getDirtyEditors();
        if (dirtyEditors.length == 0) {
            return true;
        }
        if (!this.saveAllDirtyEditors(shell, dirtyEditors)) {
            return false;
        }
        try {
            boolean autoBuild;
            IWorkspaceDescription description;
            IWorkspace workspace;
            block9: {
                block8: {
                    workspace = ResourcesPlugin.getWorkspace();
                    description = workspace.getDescription();
                    autoBuild = description.isAutoBuilding();
                    description.setAutoBuilding(false);
                    workspace.setDescription(description);
                    try {
                        if (!DLTKUIPlugin.getActiveWorkbenchWindow().getWorkbench().saveAllEditors(false)) {
                            Object var6_7 = null;
                            break block8;
                        }
                        this.fFilesSaved = true;
                        break block9;
                    }
                    catch (Throwable throwable) {
                        Object var6_8 = null;
                        description.setAutoBuilding(autoBuild);
                        workspace.setDescription(description);
                        throw throwable;
                    }
                }
                description.setAutoBuilding(autoBuild);
                workspace.setDescription(description);
                return false;
            }
            Object var6_9 = null;
            description.setAutoBuilding(autoBuild);
            workspace.setDescription(description);
            return true;
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, shell, RefactoringMessages.RefactoringStarter_saving, RefactoringMessages.RefactoringStarter_unexpected_exception);
            return false;
        }
    }

    public void triggerBuild() {
        if (this.fFilesSaved && ResourcesPlugin.getWorkspace().getDescription().isAutoBuilding()) {
            new GlobalBuildAction(DLTKUIPlugin.getActiveWorkbenchWindow(), 10).run();
        }
    }

    private boolean saveAllDirtyEditors(Shell shell, IEditorPart[] dirtyEditors) {
        if (this.fAllowSaveAlways && RefactoringSavePreferences.getSaveAllEditors()) {
            return true;
        }
        ListDialog dialog = new ListDialog(shell){

            protected Control createDialogArea(Composite parent) {
                Composite result = (Composite)super.createDialogArea(parent);
                if (RefactoringSaveHelper.this.fAllowSaveAlways) {
                    Button check = new Button(result, 32);
                    check.setText(RefactoringMessages.RefactoringStarter_always_save);
                    check.setSelection(RefactoringSavePreferences.getSaveAllEditors());
                    check.addSelectionListener((SelectionListener)new SelectionAdapter(this, check){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ Button val$check;
                        {
                            this.this$1 = var1_1;
                            this.val$check = button;
                        }

                        public void widgetSelected(SelectionEvent e) {
                            RefactoringSavePreferences.setSaveAllEditors(this.val$check.getSelection());
                        }
                    });
                    1.applyDialogFont((Control)result);
                }
                return result;
            }
        };
        dialog.setTitle(RefactoringMessages.RefactoringStarter_save_all_resources);
        dialog.setAddCancelButton(true);
        dialog.setLabelProvider(this.createDialogLabelProvider());
        dialog.setMessage(RefactoringMessages.RefactoringStarter_must_save);
        dialog.setContentProvider((IStructuredContentProvider)new ArrayContentProvider());
        dialog.setInput(Arrays.asList(dirtyEditors));
        return dialog.open() == 0;
    }

    public boolean hasFilesSaved() {
        return this.fFilesSaved;
    }

    private ILabelProvider createDialogLabelProvider() {
        return new LabelProvider(){

            public Image getImage(Object element) {
                return ((IEditorPart)element).getTitleImage();
            }

            public String getText(Object element) {
                return ((IEditorPart)element).getTitle();
            }
        };
    }
}

