/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.internal.ui;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dltk.ruby.core.RubyPlugin;
import org.eclipse.ui.progress.UIJob;

public class InitializeAfterLoadJob
extends UIJob {
    public InitializeAfterLoadJob() {
        super("Starting DLTK Ruby initialization");
        this.setSystem(true);
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        RubyPlugin.initialized = false;
        RealJob job = new RealJob("Initializing DLTK Ruby");
        job.setPriority(20);
        job.schedule();
        return new Status(0, "org.eclipse.dltk.ruby.ui", 0, "", null);
    }

    private final class RealJob
    extends Job {
        public RealJob(String name) {
            super(name);
        }

        public void waitForAutoBuild() {
            boolean wasInterrupted = false;
            do {
                try {
                    Job.getJobManager().join(ResourcesPlugin.FAMILY_AUTO_BUILD, null);
                    wasInterrupted = false;
                }
                catch (OperationCanceledException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {
                    wasInterrupted = true;
                }
            } while (wasInterrupted);
        }

        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask("", 10);
            RubyPlugin.initialized = true;
            return new Status(0, "org.eclipse.dltk.ruby.core", 0, "", null);
        }

        public boolean belongsTo(Object family) {
            return "org.eclipse.dltk.ruby.ui".equals(family);
        }
    }
}

