/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.parser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.antlr.runtime.RuleReturnScope;
import org.antlr.runtime.Token;
import org.antlr.runtime.tree.Tree;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.javascript.ast.ArrayInitializer;
import org.eclipse.dltk.javascript.ast.AsteriskExpression;
import org.eclipse.dltk.javascript.ast.BinaryOperation;
import org.eclipse.dltk.javascript.ast.BooleanLiteral;
import org.eclipse.dltk.javascript.ast.BreakStatement;
import org.eclipse.dltk.javascript.ast.CallExpression;
import org.eclipse.dltk.javascript.ast.CaseClause;
import org.eclipse.dltk.javascript.ast.CatchClause;
import org.eclipse.dltk.javascript.ast.CommaExpression;
import org.eclipse.dltk.javascript.ast.Comment;
import org.eclipse.dltk.javascript.ast.ConditionalOperator;
import org.eclipse.dltk.javascript.ast.ConstDeclaration;
import org.eclipse.dltk.javascript.ast.ContinueStatement;
import org.eclipse.dltk.javascript.ast.DecimalLiteral;
import org.eclipse.dltk.javascript.ast.DefaultClause;
import org.eclipse.dltk.javascript.ast.DefaultXmlNamespaceStatement;
import org.eclipse.dltk.javascript.ast.DeleteStatement;
import org.eclipse.dltk.javascript.ast.DoWhileStatement;
import org.eclipse.dltk.javascript.ast.EmptyExpression;
import org.eclipse.dltk.javascript.ast.ExceptionFilter;
import org.eclipse.dltk.javascript.ast.Expression;
import org.eclipse.dltk.javascript.ast.FinallyClause;
import org.eclipse.dltk.javascript.ast.ForEachInStatement;
import org.eclipse.dltk.javascript.ast.ForInStatement;
import org.eclipse.dltk.javascript.ast.ForStatement;
import org.eclipse.dltk.javascript.ast.FunctionStatement;
import org.eclipse.dltk.javascript.ast.GetAllChildrenExpression;
import org.eclipse.dltk.javascript.ast.GetArrayItemExpression;
import org.eclipse.dltk.javascript.ast.GetLocalNameExpression;
import org.eclipse.dltk.javascript.ast.GetMethod;
import org.eclipse.dltk.javascript.ast.Identifier;
import org.eclipse.dltk.javascript.ast.IfStatement;
import org.eclipse.dltk.javascript.ast.Keyword;
import org.eclipse.dltk.javascript.ast.Label;
import org.eclipse.dltk.javascript.ast.LabelledStatement;
import org.eclipse.dltk.javascript.ast.MultiLineComment;
import org.eclipse.dltk.javascript.ast.NewExpression;
import org.eclipse.dltk.javascript.ast.NullExpression;
import org.eclipse.dltk.javascript.ast.ObjectInitializer;
import org.eclipse.dltk.javascript.ast.ParenthesizedExpression;
import org.eclipse.dltk.javascript.ast.PropertyExpression;
import org.eclipse.dltk.javascript.ast.PropertyInitializer;
import org.eclipse.dltk.javascript.ast.RegExpLiteral;
import org.eclipse.dltk.javascript.ast.ReturnStatement;
import org.eclipse.dltk.javascript.ast.Script;
import org.eclipse.dltk.javascript.ast.SetMethod;
import org.eclipse.dltk.javascript.ast.SingleLineComment;
import org.eclipse.dltk.javascript.ast.Statement;
import org.eclipse.dltk.javascript.ast.StatementBlock;
import org.eclipse.dltk.javascript.ast.StatementList;
import org.eclipse.dltk.javascript.ast.StringLiteral;
import org.eclipse.dltk.javascript.ast.SwitchComponent;
import org.eclipse.dltk.javascript.ast.SwitchStatement;
import org.eclipse.dltk.javascript.ast.ThisExpression;
import org.eclipse.dltk.javascript.ast.ThrowStatement;
import org.eclipse.dltk.javascript.ast.TryStatement;
import org.eclipse.dltk.javascript.ast.TypeOfExpression;
import org.eclipse.dltk.javascript.ast.UnaryOperation;
import org.eclipse.dltk.javascript.ast.VariableDeclaration;
import org.eclipse.dltk.javascript.ast.VoidExpression;
import org.eclipse.dltk.javascript.ast.VoidOperator;
import org.eclipse.dltk.javascript.ast.WhileStatement;
import org.eclipse.dltk.javascript.ast.WithStatement;
import org.eclipse.dltk.javascript.ast.XmlAttributeIdentifier;
import org.eclipse.dltk.javascript.ast.XmlLiteral;
import org.eclipse.dltk.javascript.ast.YieldOperator;
import org.eclipse.dltk.javascript.parser.JSVisitor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTransformer
extends JSVisitor {
    private Tree root;
    private List<Token> tokens;
    private String source;
    private int[] tokenOffsets = null;
    private ASTNode parent;
    private ASTNode result = null;
    private List resultList = null;
    private int currentRecursionDeep;
    private static int MAX_RECURSION_DEEP = 512;

    public JSTransformer(RuleReturnScope root, List<Token> tokens) {
        this((Tree)root.getTree(), tokens, null, 0);
    }

    private void checkRecursionDeep() {
        if (this.currentRecursionDeep > MAX_RECURSION_DEEP) {
            throw new IllegalArgumentException("Too many AST deep");
        }
    }

    private JSTransformer(Tree tree, List<Token> tokens, ASTNode parent, int recursionDeep) {
        super(MAX_RECURSION_DEEP);
        Assert.isNotNull(tokens);
        Assert.isTrue((tokens.size() > 0 ? 1 : 0) != 0);
        this.root = tree;
        this.parent = parent;
        this.tokens = tokens;
        this.currentRecursionDeep = recursionDeep;
        this.checkRecursionDeep();
        this.prepareOffsetMap();
    }

    private JSTransformer(Tree tree, List<Token> tokens, int[] tokenOffsets, String source, ASTNode parent, int recursionDeep) {
        super(MAX_RECURSION_DEEP);
        Assert.isNotNull(tokens);
        Assert.isTrue((tokens.size() > 0 ? 1 : 0) != 0);
        this.root = tree;
        this.parent = parent;
        this.tokens = tokens;
        this.tokenOffsets = tokenOffsets;
        this.source = source;
        this.currentRecursionDeep = recursionDeep;
        this.checkRecursionDeep();
    }

    public Script transform() {
        if (this.root == null) {
            return null;
        }
        if (this.root.getType() != 0) {
            Script script = new Script();
            script.addStatement(this.transformStatementNode(this.root, (ASTNode)script));
            this.addComments(script);
            script.setStart(0);
            script.setEnd(this.source.length());
            return script;
        }
        return (Script)this.transformNode();
    }

    private ASTNode transformNode() {
        this.visitNode(this.root);
        Assert.isNotNull((Object)this.result, (String)this.root.toString());
        return this.result;
    }

    private List transformListNode() {
        this.visitNode(this.root);
        Assert.isTrue((this.resultList != null ? 1 : 0) != 0);
        return this.resultList;
    }

    private ASTNode transformNode(Tree node, ASTNode parent) {
        return new JSTransformer(node, this.tokens, this.tokenOffsets, this.source, parent, this.currentRecursionDeep + 1).transformNode();
    }

    private void prepareOffsetMap() {
        this.tokenOffsets = new int[this.tokens.size() + 1];
        int offset = 0;
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < this.tokens.size()) {
            String tokenText = this.tokens.get(i).getText();
            this.tokenOffsets[i] = offset;
            offset += tokenText.length();
            buffer.append(tokenText);
            ++i;
        }
        this.tokenOffsets[this.tokens.size()] = offset;
        this.source = buffer.toString();
    }

    private int getTokenOffset(int tokenIndex) {
        Assert.isTrue((this.tokenOffsets != null ? 1 : 0) != 0);
        Assert.isTrue((tokenIndex >= -1 && tokenIndex < this.tokenOffsets.length ? 1 : 0) != 0);
        return this.tokenOffsets[tokenIndex];
    }

    private int getTokenOffset(int tokenType, int startTokenIndex, int endTokenIndex) {
        Assert.isTrue((startTokenIndex >= 0 ? 1 : 0) != 0);
        Assert.isTrue((endTokenIndex > 0 ? 1 : 0) != 0);
        Assert.isTrue((startTokenIndex <= endTokenIndex ? 1 : 0) != 0);
        Token token = null;
        int i = startTokenIndex;
        while (i <= endTokenIndex) {
            Token item = this.tokens.get(i);
            if (item.getType() == tokenType) {
                token = item;
                break;
            }
            ++i;
        }
        if (token == null) {
            return -1;
        }
        return this.getTokenOffset(token.getTokenIndex());
    }

    private int getTokenOffset(int tokenType, int startTokenIndex, int endTokenIndex, int skipCount) {
        Assert.isTrue((startTokenIndex > 0 ? 1 : 0) != 0);
        Assert.isTrue((endTokenIndex > 0 ? 1 : 0) != 0);
        Assert.isTrue((startTokenIndex <= endTokenIndex ? 1 : 0) != 0);
        Token token = null;
        int skipped = 0;
        int i = startTokenIndex;
        while (i <= endTokenIndex) {
            Token item = this.tokens.get(i);
            if (item.getType() == tokenType) {
                if (skipped == skipCount) {
                    token = item;
                    break;
                }
                ++skipped;
            }
            ++i;
        }
        if (token == null) {
            return -1;
        }
        return this.getTokenOffset(token.getTokenIndex());
    }

    private Statement transformStatementNode(Tree node, ASTNode parent) {
        ASTNode expression = new JSTransformer(node, this.tokens, this.tokenOffsets, this.source, parent, this.currentRecursionDeep + 1).transformNode();
        if (expression instanceof Statement) {
            return (Statement)expression;
        }
        VoidExpression voidExpression = new VoidExpression(parent);
        voidExpression.setExpression((Expression)expression);
        Token token = this.tokens.get(node.getTokenStopIndex());
        if (token.getType() == 77) {
            voidExpression.setSemicolonPosition(this.getTokenOffset(token.getTokenIndex()));
            voidExpression.getExpression().setEnd(Math.min(voidExpression.getSemicolonPosition(), expression.sourceEnd()));
        }
        Assert.isTrue((expression.sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((expression.sourceEnd() > 0 ? 1 : 0) != 0);
        voidExpression.setStart(expression.sourceStart());
        voidExpression.setEnd(Math.max(expression.sourceEnd(), voidExpression.getSemicolonPosition() + 1));
        return voidExpression;
    }

    private List transformListNode(Tree node, ASTNode parent) {
        return new JSTransformer(node, this.tokens, this.tokenOffsets, this.source, parent, this.currentRecursionDeep + 1).transformListNode();
    }

    @Override
    protected boolean visitArguments(Tree node) {
        ArrayList<ASTNode> nodes = new ArrayList<ASTNode>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            nodes.add(this.transformNode(node.getChild(i), this.parent));
            ++i;
        }
        this.resultList = nodes;
        return true;
    }

    @Override
    protected boolean visitBinaryOperation(Tree node) {
        if (node.getType() == 89) {
            switch (node.getChildCount()) {
                case 0: {
                    return this.visitAsterisk(node);
                }
                case 1: {
                    return this.visit(node.getChild(0));
                }
            }
        }
        Assert.isNotNull((Object)node.getChild(0));
        Assert.isNotNull((Object)node.getChild(1));
        BinaryOperation operation = new BinaryOperation(this.parent);
        operation.setOperation(node.getType());
        operation.setLeftExpression((Expression)this.transformNode(node.getChild(0), this.parent));
        operation.setRightExpression((Expression)this.transformNode(node.getChild(1), this.parent));
        operation.setOperationPosition(this.getTokenOffset(node.getType(), JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((operation.getOperationPosition() >= operation.getLeftExpression().sourceEnd() ? 1 : 0) != 0);
        Assert.isTrue((operation.getOperationPosition() + operation.getOperationText().length() <= operation.getRightExpression().sourceStart() ? 1 : 0) != 0);
        operation.setStart(operation.getLeftExpression().sourceStart());
        operation.setEnd(operation.getRightExpression().sourceEnd());
        this.result = operation;
        return true;
    }

    @Override
    protected boolean visitBlock(Tree node) {
        StatementBlock block = new StatementBlock(this.parent);
        ArrayList<Statement> statements = new ArrayList<Statement>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            statements.add(this.transformStatementNode(node.getChild(i), this.parent));
            ++i;
        }
        block.setStatements(statements);
        block.setLC(this.getTokenOffset(70, node.getTokenStartIndex(), node.getTokenStopIndex()));
        block.setRC(this.getTokenOffset(71, node.getTokenStopIndex(), node.getTokenStopIndex()));
        if (block.getLC() > -1 && block.getRC() > -1) {
            block.setStart(block.getLC());
            block.setEnd(block.getRC() + 1);
        } else {
            block.setStart(((ASTNode)block.getStatements().get(0)).sourceStart());
            block.setEnd(((ASTNode)block.getStatements().get(block.getStatements().size() - 1)).sourceStart());
        }
        this.result = block;
        return true;
    }

    @Override
    protected boolean visitBreak(Tree node) {
        BreakStatement statement = new BreakStatement(this.parent);
        Keyword breakKeyword = new Keyword(statement, "break");
        breakKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        breakKeyword.setEnd(breakKeyword.sourceStart() + "break".length());
        statement.setBreakKeyword(breakKeyword);
        if (node.getChildCount() > 0) {
            Label label = new Label(statement);
            label.setText(node.getChild(0).getText());
            label.setStart(this.getTokenOffset(node.getChild(0).getTokenStartIndex()));
            label.setEnd(this.getTokenOffset(node.getChild(0).getTokenStopIndex() + 1));
            statement.setLabel(label);
        }
        statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(statement.getBreakKeyword().sourceStart());
        if (statement.getLabel() != null) {
            statement.setEnd(Math.max(statement.getSemicolonPosition(), statement.getLabel().sourceEnd()));
        } else {
            statement.setEnd(Math.max(statement.getSemicolonPosition(), statement.getBreakKeyword().sourceEnd()));
        }
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitCall(Tree node) {
        CallExpression call = new CallExpression(this.parent);
        Assert.isNotNull((Object)node.getChild(0));
        Assert.isNotNull((Object)node.getChild(1));
        call.setExpression(this.transformNode(node.getChild(0), call));
        call.setArguments(this.transformListNode(node.getChild(1), call));
        ArrayList<Integer> commas = new ArrayList<Integer>();
        Tree args = node.getChild(1);
        int i = 1;
        while (i < args.getChildCount()) {
            commas.add(new Integer(this.getTokenOffset(78, args.getChild(i - 1).getTokenStopIndex() + 1, args.getChild(i).getTokenStartIndex())));
            ++i;
        }
        call.setCommas(commas);
        call.setLP(this.getTokenOffset(72, node.getChild(1).getTokenStartIndex(), node.getChild(1).getTokenStartIndex()));
        call.setRP(this.getTokenOffset(73, node.getChild(1).getTokenStopIndex(), node.getChild(1).getTokenStopIndex()));
        call.setStart(call.getExpression().sourceStart());
        call.setEnd(call.getRP() + 1);
        this.result = call;
        return true;
    }

    @Override
    protected boolean visitCase(Tree node) {
        CaseClause caseClause = new CaseClause(this.parent);
        Keyword caseKeyword = new Keyword(caseClause, "case");
        caseKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        caseKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        caseClause.setCaseKeyword(caseKeyword);
        caseClause.setCondition((Expression)this.transformNode(node.getChild(0), caseClause));
        caseClause.setColonPosition(this.getTokenOffset(104, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        StatementList list = new StatementList(caseClause);
        ArrayList<Statement> statements = new ArrayList<Statement>(node.getChildCount());
        int i = 1;
        while (i < node.getChildCount()) {
            statements.add(this.transformStatementNode(node.getChild(i), list));
            ++i;
        }
        list.setStatementList(statements);
        if (node.getChildCount() > 1) {
            list.setStart(this.getTokenOffset(node.getChild(1).getTokenStartIndex()));
            list.setEnd(this.getTokenOffset(node.getChild(node.getChildCount() - 1).getTokenStopIndex() + 1));
        } else {
            list.setStart(caseClause.getColonPosition() + 1);
            list.setEnd(caseClause.getColonPosition() + 1);
        }
        caseClause.setStatements(list);
        caseClause.setStart(caseClause.getCaseKeyword().sourceStart());
        caseClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = caseClause;
        return true;
    }

    @Override
    protected boolean visitDecimalLiteral(Tree node) {
        DecimalLiteral number = new DecimalLiteral(this.parent);
        number.setText(node.getText());
        number.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        number.setEnd(number.sourceStart() + number.getText().length());
        this.result = number;
        return true;
    }

    @Override
    protected boolean visitDefault(Tree node) {
        DefaultClause defaultClause = new DefaultClause(this.parent);
        Keyword defaultKeyword = new Keyword(this.parent, "default");
        defaultKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        defaultKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        defaultClause.setDefaultKeyword(defaultKeyword);
        defaultClause.setColonPosition(this.getTokenOffset(104, node.getTokenStartIndex() + 1, node.getTokenStopIndex() + 1));
        StatementList list = new StatementList(defaultClause);
        if (node.getChildCount() > 0) {
            list.setStart(this.getTokenOffset(node.getChild(0).getTokenStartIndex()));
            list.setEnd(this.getTokenOffset(node.getChild(node.getChildCount() - 1).getTokenStopIndex() + 1));
        } else {
            list.setStart(defaultClause.getColonPosition() + 1);
            list.setEnd(defaultClause.getColonPosition() + 1);
        }
        ArrayList<Statement> statements = new ArrayList<Statement>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            statements.add(this.transformStatementNode(node.getChild(i), list));
            ++i;
        }
        list.setStatementList(statements);
        defaultClause.setStatements(list);
        defaultClause.setStart(defaultClause.getDefaultKeyword().sourceStart());
        defaultClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = defaultClause;
        return true;
    }

    @Override
    protected boolean visitExpression(Tree node) {
        this.result = node.getChildCount() > 0 ? this.transformNode(node.getChild(0), this.parent) : new EmptyExpression(this.parent);
        return true;
    }

    @Override
    protected boolean visitFor(Tree node) {
        switch (node.getChild(0).getType()) {
            case 139: {
                return this.visitForStatement(node);
            }
            case 138: {
                return this.visitForInStatement(node);
            }
        }
        throw new IllegalArgumentException("FORSTEP or FORITER expected");
    }

    private boolean visitForStatement(Tree node) {
        ForStatement statement = new ForStatement(this.parent);
        Keyword forKeyword = new Keyword(this.parent, "for");
        forKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        forKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setForKeyword(forKeyword);
        statement.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, node.getTokenStopIndex()));
        statement.setInitial((Expression)this.transformNode(node.getChild(0).getChild(0), statement));
        statement.setCondition((Expression)this.transformNode(node.getChild(0).getChild(1), statement));
        statement.setStep((Expression)this.transformNode(node.getChild(0).getChild(2), statement));
        if (statement.getInitial() instanceof EmptyExpression) {
            statement.setInitialSemicolonPosition(this.getTokenOffset(77, node.getTokenStartIndex() + 2, node.getTokenStopIndex()));
            statement.getInitial().setStart(statement.getInitialSemicolonPosition());
            statement.getInitial().setEnd(statement.getInitialSemicolonPosition());
            if (statement.getCondition() instanceof EmptyExpression) {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(77, node.getTokenStartIndex(), node.getTokenStopIndex(), 1));
                statement.getCondition().setStart(statement.getConditionalSemicolonPosition());
                statement.getCondition().setEnd(statement.getConditionalSemicolonPosition());
            } else {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(77, node.getChild(0).getChild(1).getTokenStopIndex() + 1, node.getTokenStopIndex()));
            }
        } else {
            statement.setInitialSemicolonPosition(this.getTokenOffset(77, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(0)) + 1, node.getTokenStopIndex()));
            if (statement.getCondition() instanceof EmptyExpression) {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(77, node.getChild(0).getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex(), 1));
                statement.getCondition().setStart(statement.getConditionalSemicolonPosition());
                statement.getCondition().setEnd(statement.getConditionalSemicolonPosition());
            } else {
                statement.setConditionalSemicolonPosition(this.getTokenOffset(77, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(1)) + 1, node.getTokenStopIndex()));
            }
        }
        if (statement.getStep() instanceof EmptyExpression) {
            statement.setStart(statement.getConditionalSemicolonPosition() + 1);
            statement.setEnd(statement.getConditionalSemicolonPosition() + 1);
        }
        statement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        if (statement.getBody() == null || !(statement.getBody() instanceof VoidExpression) || ((VoidExpression)statement.getBody()).getSemicolonPosition() == -1) {
            statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        }
        statement.setStart(statement.getForKeyword().sourceStart());
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    private boolean visitForInStatement(Tree node) {
        ForInStatement statement = new ForInStatement(this.parent);
        Keyword forKeyword = new Keyword(statement, "for");
        forKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        forKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setForKeyword(forKeyword);
        statement.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        statement.setItem((Expression)this.transformNode(node.getChild(0).getChild(0), statement));
        Keyword inKeyword = new Keyword(statement, "in");
        int iteratorStart = node.getChild(0).getChild(1).getTokenStartIndex();
        if (iteratorStart == -1 && node.getChild(0).getChild(1).getType() == 137 && node.getChild(0).getChild(1).getChildCount() > 0) {
            iteratorStart = node.getChild(0).getChild(1).getChild(0).getTokenStartIndex();
        }
        inKeyword.setStart(this.getTokenOffset(20, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(0)) + 1, iteratorStart));
        inKeyword.setEnd(inKeyword.sourceStart() + "in".length());
        statement.setInKeyword(inKeyword);
        statement.setIterator((Expression)this.transformNode(node.getChild(0).getChild(1), statement));
        statement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        if (statement.getBody() == null || !(statement.getBody() instanceof VoidExpression) || ((VoidExpression)statement.getBody()).getSemicolonPosition() == -1) {
            statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        }
        statement.setStart(statement.getForKeyword().sourceStart());
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitFunction(Tree node) {
        FunctionStatement fn = new FunctionStatement(this.parent);
        Keyword functionKeyword = new Keyword(fn, "function");
        functionKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        functionKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        fn.setFunctionKeyword(functionKeyword);
        int argsIndex = 0;
        if (node.getChild(0).getType() != 128) {
            fn.setName((Identifier)this.transformNode(node.getChild(0), fn));
            ++argsIndex;
        }
        Tree argsNode = node.getChild(argsIndex);
        fn.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, argsNode.getTokenStartIndex()));
        fn.setArguments(this.transformListNode(argsNode, fn));
        ArrayList<Integer> commas = new ArrayList<Integer>();
        if (argsNode.getChildCount() > 1) {
            int i = 1;
            while (i < argsNode.getChildCount()) {
                commas.add(new Integer(this.getTokenOffset(78, argsNode.getChild(i - 1).getTokenStopIndex() + 1, argsNode.getChild(i).getTokenStartIndex())));
                ++i;
            }
        }
        fn.setArgumentCommas(commas);
        fn.setRP(this.getTokenOffset(73, node.getChild(argsIndex).getTokenStopIndex(), node.getChild(argsIndex + 1).getTokenStartIndex()));
        fn.setBody((StatementBlock)this.transformNode(node.getChild(argsIndex + 1), fn));
        fn.setStart(fn.getFunctionKeyword().sourceStart());
        fn.setEnd(fn.getBody().sourceEnd());
        this.result = fn;
        return true;
    }

    @Override
    protected boolean visitIdentifier(Tree node) {
        Identifier id = new Identifier(this.parent);
        id.setName(node.getText());
        id.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        id.setEnd(id.sourceStart() + id.getName().length());
        this.result = id;
        return true;
    }

    @Override
    protected boolean visitReturn(Tree node) {
        Token token;
        ReturnStatement returnStatement = new ReturnStatement(this.parent);
        Keyword keyword = new Keyword(returnStatement, "return");
        keyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        keyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        returnStatement.setReturnKeyword(keyword);
        if (node.getChildCount() > 0) {
            returnStatement.setValue((Expression)this.transformNode(node.getChild(0), returnStatement));
        }
        if ((token = this.tokens.get(node.getTokenStopIndex())).getType() == 77) {
            returnStatement.setSemicolonPosition(this.getTokenOffset(node.getTokenStopIndex()));
            returnStatement.setEnd(returnStatement.getSemicolonPosition() + 1);
        } else if (returnStatement.getValue() != null) {
            returnStatement.setEnd(returnStatement.getValue().sourceEnd() + 1);
        } else {
            returnStatement.setEnd(returnStatement.getReturnKeyword().sourceEnd());
        }
        returnStatement.setStart(returnStatement.getReturnKeyword().sourceStart());
        this.result = returnStatement;
        return true;
    }

    @Override
    protected boolean visitStringLiteral(Tree node) {
        StringLiteral literal = new StringLiteral(this.parent);
        literal.setText(node.getText());
        literal.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        literal.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = literal;
        return true;
    }

    @Override
    protected boolean visitSwitch(Tree node) {
        SwitchStatement statement = new SwitchStatement(this.parent);
        Keyword switchKeyword = new Keyword(statement, "switch");
        switchKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        switchKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setSwitchKeyword(switchKeyword);
        statement.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        statement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        statement.setCondition((Expression)this.transformNode(node.getChild(0), statement));
        statement.setLC(this.getTokenOffset(70, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        ArrayList<Tree> caseNodes = new ArrayList<Tree>(node.getChildCount() - 1);
        int i = 1;
        while (i < node.getChildCount()) {
            caseNodes.add(node.getChild(i));
            ++i;
        }
        Collections.sort(caseNodes, new Comparator<Tree>(){

            @Override
            public int compare(Tree o1, Tree o2) {
                return o1.getTokenStartIndex() - o2.getTokenStartIndex();
            }
        });
        for (Tree child : caseNodes) {
            switch (child.getType()) {
                case 8: 
                case 11: {
                    statement.addCase((SwitchComponent)this.transformNode(child, statement));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException();
                }
            }
        }
        statement.setRC(this.getTokenOffset(71, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(statement.getSwitchKeyword().sourceStart());
        statement.setEnd(statement.getRC() + 1);
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitUnaryOperation(Tree node) {
        UnaryOperation operation = new UnaryOperation(this.parent);
        operation.setOperation(node.getType());
        int operationType = node.getType();
        if (operation.isPostfix()) {
            operation.setOperationPosition(this.getTokenOffset(operationType, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        } else {
            operation.setOperationPosition(this.getTokenOffset(operationType, node.getTokenStartIndex(), node.getTokenStopIndex()));
        }
        if (operation.getOperationPosition() == -1) {
            switch (operationType) {
                case 147: {
                    operationType = 91;
                    break;
                }
                case 146: {
                    operationType = 92;
                    break;
                }
                case 143: {
                    operationType = 88;
                }
            }
            if (operation.isPostfix()) {
                operation.setOperationPosition(this.getTokenOffset(operationType, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
            } else {
                operation.setOperationPosition(this.getTokenOffset(operationType, node.getTokenStartIndex(), node.getTokenStopIndex()));
            }
        }
        Assert.isTrue((operation.getOperationPosition() > -1 ? 1 : 0) != 0);
        operation.setExpression((Expression)this.transformNode(node.getChild(0), operation));
        operation.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        operation.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = operation;
        return true;
    }

    @Override
    protected boolean visitContinue(Tree node) {
        ContinueStatement statement = new ContinueStatement(this.parent);
        Keyword continueKeyword = new Keyword(statement, "continue");
        continueKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        continueKeyword.setEnd(continueKeyword.sourceStart() + "continue".length());
        statement.setContinueKeyword(continueKeyword);
        if (node.getChildCount() > 0) {
            Label label = new Label(statement);
            label.setText(node.getChild(0).getText());
            label.setStart(this.getTokenOffset(node.getChild(0).getTokenStartIndex()));
            label.setEnd(this.getTokenOffset(node.getChild(0).getTokenStopIndex() + 1));
            statement.setLabel(label);
        }
        statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitVarDeclaration(Tree node) {
        VariableDeclaration var = new VariableDeclaration(this.parent);
        Keyword varKeyword = new Keyword(this.parent, "var");
        varKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        varKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        var.setVarKeyword(varKeyword);
        ArrayList<Integer> commas = new ArrayList<Integer>();
        ArrayList<ASTNode> variables = new ArrayList<ASTNode>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            variables.add(this.transformNode(node.getChild(i), var));
            if (i > 0) {
                commas.add(new Integer(this.getTokenOffset(78, node.getChild(i - 1).getTokenStopIndex() + 1, node.getChild(i).getTokenStartIndex())));
            }
            ++i;
        }
        var.setVariables(variables);
        var.setCommas(commas);
        var.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        var.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = var;
        return true;
    }

    @Override
    protected boolean visitObjectInitializer(Tree node) {
        ObjectInitializer initializer = new ObjectInitializer(this.parent);
        ArrayList<ASTNode> properties = new ArrayList<ASTNode>(node.getChildCount());
        ArrayList<Integer> commas = new ArrayList<Integer>();
        int i = 0;
        while (i < node.getChildCount()) {
            properties.add(this.transformNode(node.getChild(i), initializer));
            if (i > 0) {
                commas.add(new Integer(this.getTokenOffset(78, node.getChild(i - 1).getTokenStopIndex() + 1, node.getChild(i).getTokenStartIndex())));
            }
            ++i;
        }
        initializer.setInitializers(properties);
        initializer.setCommas(commas);
        initializer.setLC(this.getTokenOffset(node.getTokenStartIndex()));
        initializer.setRC(this.getTokenOffset(node.getTokenStopIndex()));
        Token LC = this.tokens.get(node.getTokenStartIndex());
        Token RC = this.tokens.get(node.getTokenStopIndex());
        initializer.setMultiline(LC.getLine() != RC.getLine());
        initializer.setStart(initializer.getLC());
        initializer.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = initializer;
        return true;
    }

    @Override
    protected boolean visitPropertyInitializer(Tree node) {
        PropertyInitializer initializer = new PropertyInitializer(this.parent);
        initializer.setName((Expression)this.transformNode(node.getChild(0), initializer));
        initializer.setColon(this.getTokenOffset(104, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        initializer.setValue((Expression)this.transformNode(node.getChild(1), initializer));
        initializer.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        initializer.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = initializer;
        return true;
    }

    @Override
    protected boolean visitForEachInStatement(Tree node) {
        ForEachInStatement statement = new ForEachInStatement(this.parent);
        Keyword forKeyword = new Keyword(statement, "for");
        forKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        forKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setForKeyword(forKeyword);
        Keyword eachKeyword = new Keyword(statement, "each");
        eachKeyword.setStart(this.getTokenOffset(17, node.getTokenStartIndex(), node.getTokenStopIndex()));
        eachKeyword.setEnd(eachKeyword.sourceStart() + "each".length());
        statement.setEachKeyword(eachKeyword);
        statement.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        statement.setItem((Expression)this.transformNode(node.getChild(0).getChild(0), statement));
        Keyword inKeyword = new Keyword(statement, "in");
        int iteratorStart = node.getChild(0).getChild(1).getTokenStartIndex();
        if (iteratorStart == -1 && node.getChild(0).getChild(1).getType() == 137 && node.getChild(0).getChild(1).getChildCount() > 0) {
            iteratorStart = node.getChild(0).getChild(1).getChild(0).getTokenStartIndex();
        }
        inKeyword.setStart(this.getTokenOffset(20, JSTransformer.getRealTokenStopIndex(node.getChild(0).getChild(0)) + 1, iteratorStart));
        inKeyword.setEnd(inKeyword.sourceStart() + "in".length());
        statement.setInKeyword(inKeyword);
        statement.setIterator((Expression)this.transformNode(node.getChild(0).getChild(1), statement));
        statement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        if (statement.getBody() == null || !(statement.getBody() instanceof VoidExpression) || ((VoidExpression)statement.getBody()).getSemicolonPosition() == -1) {
            statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    private static int getRealTokenStopIndex(Tree node) {
        if (node.getTokenStopIndex() == -1) {
            return JSTransformer.getRealTokenStopIndex(node.getChild(node.getChildCount() - 1));
        }
        if (node.getChildCount() > 0) {
            return Math.max(node.getTokenStopIndex(), JSTransformer.getRealTokenStopIndex(node.getChild(node.getChildCount() - 1)));
        }
        return node.getTokenStopIndex();
    }

    @Override
    protected boolean visitByField(Tree node) {
        PropertyExpression property = new PropertyExpression(this.parent);
        property.setObject((Expression)this.transformNode(node.getChild(0), property));
        property.setProperty((Expression)this.transformNode(node.getChild(1), property));
        property.setDotPosition(this.getTokenOffset(76, JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((property.getObject().sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((property.getProperty().sourceEnd() > 0 ? 1 : 0) != 0);
        property.setStart(property.getObject().sourceStart());
        property.setEnd(property.getProperty().sourceEnd());
        this.result = property;
        return true;
    }

    @Override
    protected boolean visitWhile(Tree node) {
        WhileStatement statement = new WhileStatement(this.parent);
        Keyword whileKeyword = new Keyword(statement, "while");
        whileKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        whileKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setWhileKeyword(whileKeyword);
        statement.setLP(this.getTokenOffset(72, node.getTokenStartIndex(), node.getChild(0).getTokenStartIndex()));
        statement.setCondition((Expression)this.transformNode(node.getChild(0), statement));
        statement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setBody(this.transformStatementNode(node.getChild(1), statement));
        }
        if (statement.getBody() == null || !(statement.getBody() instanceof VoidExpression) || ((VoidExpression)statement.getBody()).getSemicolonPosition() == -1) {
            statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitIf(Tree node) {
        IfStatement ifStatement = new IfStatement(this.parent);
        Keyword ifKeyword = new Keyword(ifStatement, "if");
        ifKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        ifKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        ifStatement.setIfKeyword(ifKeyword);
        ifStatement.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        ifStatement.setCondition((Expression)this.transformNode(node.getChild(0), ifStatement));
        ifStatement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        ifStatement.setThenStatement(this.transformStatementNode(node.getChild(1), ifStatement));
        if (node.getChildCount() > 2) {
            Keyword elseKeyword = new Keyword(ifStatement, "else");
            elseKeyword.setStart(this.getTokenOffset(14, node.getChild(1).getTokenStopIndex() + 1, node.getChild(2).getTokenStartIndex()));
            elseKeyword.setEnd(elseKeyword.sourceStart() + "else".length());
            ifStatement.setElseKeyword(elseKeyword);
            ifStatement.setElseStatement(this.transformStatementNode(node.getChild(2), ifStatement));
        }
        ifStatement.setStart(ifStatement.getIfKeyword().sourceStart());
        ifStatement.setEnd(node.getTokenStopIndex() + 1);
        this.result = ifStatement;
        return true;
    }

    @Override
    protected boolean visitDoWhile(Tree node) {
        DoWhileStatement statement = new DoWhileStatement(this.parent);
        Keyword doKeyword = new Keyword(this.parent, "do");
        doKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        doKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setDoKeyword(doKeyword);
        statement.setBody(this.transformStatementNode(node.getChild(0), statement));
        Keyword whileKeyword = new Keyword(this.parent, "while");
        whileKeyword.setStart(this.getTokenOffset(31, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        whileKeyword.setEnd(whileKeyword.sourceStart() + "while".length());
        statement.setWhileKeyword(whileKeyword);
        statement.setLP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        statement.setCondition((Expression)this.transformNode(node.getChild(1), statement));
        statement.setRP(this.getTokenOffset(73, node.getChild(1).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        statement.setSemicolonPosition(this.getTokenOffset(77, node.getChild(1).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitConditional(Tree node) {
        ConditionalOperator operator = new ConditionalOperator(this.parent);
        operator.setCondition((Expression)this.transformNode(node.getChild(0), operator));
        operator.setTrueValue((Expression)this.transformNode(node.getChild(1), operator));
        operator.setFalseValue((Expression)this.transformNode(node.getChild(2), operator));
        operator.setQuestionPosition(this.getTokenOffset(103, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        operator.setColonPosition(this.getTokenOffset(104, node.getChild(1).getTokenStopIndex() + 1, node.getChild(2).getTokenStartIndex()));
        operator.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        operator.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = operator;
        return true;
    }

    @Override
    protected boolean visitParenthesizedExpression(Tree node) {
        ParenthesizedExpression expression = new ParenthesizedExpression(this.parent);
        expression.setExpression((Expression)this.transformNode(node.getChild(0), expression));
        expression.setLP(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setRP(this.getTokenOffset(node.getTokenStopIndex()));
        expression.setStart(expression.getLP());
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitTry(Tree node) {
        TryStatement statement = new TryStatement(this.parent);
        Keyword tryKeyword = new Keyword(this.parent, "try");
        tryKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        tryKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setTryKeyword(tryKeyword);
        statement.setBody((StatementBlock)this.transformStatementNode(node.getChild(0), statement));
        ArrayList<ASTNode> catches = new ArrayList<ASTNode>(node.getChildCount() - 1);
        int i = 1;
        while (i < node.getChildCount()) {
            Tree child = node.getChild(i);
            switch (child.getType()) {
                case 9: {
                    catches.add(this.transformNode(child, statement));
                    break;
                }
                case 15: {
                    statement.setFinally((FinallyClause)this.transformNode(child, statement));
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("CATCH or FINALLY expected");
                }
            }
            ++i;
        }
        statement.setCatches(catches);
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitThrow(Tree node) {
        ThrowStatement statement = new ThrowStatement(this.parent);
        Keyword throwKeyword = new Keyword(statement, "throw");
        throwKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        throwKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setThrowKeyword(throwKeyword);
        if (node.getChildCount() > 0) {
            statement.setException((Expression)this.transformNode(node.getChild(0), statement));
        }
        statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitNew(Tree node) {
        NewExpression expression = new NewExpression(this.parent);
        Keyword newKeyword = new Keyword(expression, "new");
        newKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        newKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        expression.setNewKeyword(newKeyword);
        expression.setObjectClass((Identifier)this.transformNode(node.getChild(0), expression));
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitCatch(Tree node) {
        CatchClause catchClause = new CatchClause(this.parent);
        Keyword catchKeyword = new Keyword(catchClause, "catch");
        catchKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        catchKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        catchClause.setCatchKeyword(catchKeyword);
        catchClause.setLP(this.getTokenOffset(72, node.getTokenStartIndex() + 1, node.getChild(0).getTokenStartIndex()));
        catchClause.setException((Identifier)this.transformNode(node.getChild(0), catchClause));
        int statementIndex = 1;
        if (node.getChild(1).getType() == 19) {
            ++statementIndex;
            ExceptionFilter filter = new ExceptionFilter(catchClause);
            Tree filterNode = node.getChild(1);
            Keyword ifKeyword = new Keyword(catchClause, "if");
            ifKeyword.setStart(this.getTokenOffset(filterNode.getTokenStartIndex()));
            ifKeyword.setEnd(this.getTokenOffset(filterNode.getTokenStartIndex() + 1));
            filter.setIfKeyword(ifKeyword);
            filter.setExpression((Expression)this.transformNode(filterNode.getChild(0), filter));
            filter.setStart(this.getTokenOffset(filterNode.getTokenStartIndex()));
            filter.setEnd(this.getTokenOffset(filterNode.getTokenStopIndex() + 1));
            catchClause.setExceptionFilter(filter);
        }
        catchClause.setRP(this.getTokenOffset(73, node.getChild(statementIndex - 1).getTokenStopIndex() + 1, node.getChild(statementIndex).getTokenStartIndex()));
        catchClause.setStatement(this.transformStatementNode(node.getChild(statementIndex), catchClause));
        catchClause.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        catchClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = catchClause;
        return true;
    }

    @Override
    protected boolean visitFinally(Tree node) {
        FinallyClause finallyClause = new FinallyClause(this.parent);
        Keyword finallyKeyword = new Keyword(finallyClause, "finally");
        finallyKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        finallyKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        finallyClause.setFinallyKeyword(finallyKeyword);
        finallyClause.setStatement(this.transformStatementNode(node.getChild(0), finallyClause));
        finallyClause.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        finallyClause.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = finallyClause;
        return true;
    }

    @Override
    protected boolean visitArray(Tree node) {
        ArrayInitializer array = new ArrayInitializer(this.parent);
        array.setLB(this.getTokenOffset(74, node.getTokenStartIndex(), node.getTokenStartIndex()));
        ArrayList<ASTNode> items = new ArrayList<ASTNode>(node.getChildCount());
        ArrayList<Integer> commas = new ArrayList<Integer>();
        int i = 0;
        while (i < node.getChildCount()) {
            Tree child = node.getChild(i);
            if (child.getType() != 140) {
                throw new UnsupportedOperationException("ITEM expected");
            }
            items.add(this.transformNode(child.getChild(0), array));
            if (i > 0) {
                commas.add(new Integer(this.getTokenOffset(78, node.getChild(i - 1).getTokenStopIndex() + 1, child.getTokenStartIndex())));
            }
            ++i;
        }
        array.setItems(items);
        array.setCommas(commas);
        array.setRB(this.getTokenOffset(75, node.getTokenStopIndex(), node.getTokenStopIndex()));
        array.setStart(array.getLB());
        array.setEnd(array.getRB() + 1);
        this.result = array;
        return true;
    }

    @Override
    protected boolean visitByIndex(Tree node) {
        GetArrayItemExpression item = new GetArrayItemExpression(this.parent);
        item.setArray((Expression)this.transformNode(node.getChild(0), item));
        item.setIndex((Expression)this.transformNode(node.getChild(1), item));
        item.setLB(this.getTokenOffset(74, JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        item.setRB(this.getTokenOffset(75, node.getChild(1).getTokenStopIndex() + 1, this.tokens.size() + 1));
        item.setStart(item.getArray().sourceStart());
        item.setEnd(item.getRB() + 1);
        this.result = item;
        return true;
    }

    @Override
    protected boolean visitCommaExpression(Tree node) {
        CommaExpression expression = new CommaExpression(this.parent);
        ArrayList<ASTNode> items = new ArrayList<ASTNode>(node.getChildCount());
        ArrayList<Integer> commas = new ArrayList<Integer>();
        int i = 0;
        while (i < node.getChildCount()) {
            items.add(this.transformNode(node.getChild(i), expression));
            if (i > 0) {
                commas.add(new Integer(this.getTokenOffset(78, node.getChild(i - 1).getTokenStopIndex(), node.getChild(i).getTokenStartIndex())));
            }
            ++i;
        }
        expression.setItems(items);
        expression.setCommas(commas);
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitRegExp(Tree node) {
        RegExpLiteral regexp = new RegExpLiteral(this.parent);
        regexp.setText(node.getText());
        regexp.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        regexp.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = regexp;
        return true;
    }

    @Override
    protected boolean visitWith(Tree node) {
        WithStatement statement = new WithStatement(this.parent);
        Keyword withKeyword = new Keyword(statement, "with");
        withKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        withKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setWithKeyword(withKeyword);
        statement.setLP(this.getTokenOffset(72, node.getTokenStartIndex(), node.getChild(0).getTokenStartIndex()));
        statement.setExpression((Expression)this.transformNode(node.getChild(0), statement));
        statement.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex()));
        if (node.getChildCount() > 1) {
            statement.setStatement(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitThis(Tree node) {
        ThisExpression expression = new ThisExpression(this.parent);
        Keyword thisKeyword = new Keyword(expression, "this");
        thisKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        thisKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        expression.setThisKeyword(thisKeyword);
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitLabelled(Tree node) {
        LabelledStatement statement = new LabelledStatement(this.parent);
        Label label = new Label(statement);
        label.setText(node.getChild(0).getText());
        label.setStart(this.getTokenOffset(node.getChild(0).getTokenStartIndex()));
        label.setEnd(this.getTokenOffset(node.getChild(0).getTokenStopIndex() + 1));
        statement.setLabel(label);
        statement.setColonPosition(this.getTokenOffset(104, node.getChild(0).getTokenStopIndex() + 1, node.getTokenStopIndex() + 1));
        if (node.getChildCount() > 1) {
            statement.setStatement(this.transformStatementNode(node.getChild(1), statement));
        }
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitDelete(Tree node) {
        DeleteStatement statement = new DeleteStatement(this.parent);
        Keyword deleteKeyword = new Keyword(statement, "delete");
        deleteKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        deleteKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        statement.setDeleteKeyword(deleteKeyword);
        statement.setExpression((Expression)this.transformNode(node.getChild(0), statement));
        statement.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        statement.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        statement.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitGet(Tree node) {
        GetMethod method = new GetMethod(this.parent);
        Keyword getKeyword = new Keyword(method, "get");
        getKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        getKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        method.setGetKeyword(getKeyword);
        method.setName((Identifier)this.transformNode(node.getChild(0), method));
        method.setLP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        method.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        method.setBody((StatementBlock)this.transformStatementNode(node.getChild(1), method));
        method.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        method.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = method;
        return true;
    }

    @Override
    protected boolean visitSet(Tree node) {
        SetMethod method = new SetMethod(this.parent);
        Keyword setKeyword = new Keyword(method, "set");
        setKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        setKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        method.setSetKeyword(setKeyword);
        method.setName((Identifier)this.transformNode(node.getChild(0), method));
        method.setLP(this.getTokenOffset(72, node.getChild(0).getTokenStopIndex() + 1, node.getChild(1).getTokenStartIndex()));
        method.setArgument((Identifier)this.transformNode(node.getChild(1), method));
        method.setRP(this.getTokenOffset(73, node.getChild(0).getTokenStopIndex() + 1, node.getChild(2).getTokenStartIndex()));
        method.setBody((StatementBlock)this.transformStatementNode(node.getChild(2), method));
        method.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        method.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = method;
        return true;
    }

    @Override
    protected boolean visitNull(Tree node) {
        NullExpression expression = new NullExpression(this.parent);
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitTypeOf(Tree node) {
        TypeOfExpression expression = new TypeOfExpression(this.parent);
        Keyword typeofKeyword = new Keyword(this.parent, "typeof");
        typeofKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        typeofKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        expression.setTypeOfKeyword(typeofKeyword);
        expression.setExpression((Expression)this.transformNode(node.getChild(0), expression));
        expression.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        expression.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitConst(Tree node) {
        ConstDeclaration declaration = new ConstDeclaration(this.parent);
        Keyword constKeyword = new Keyword(this.parent, "const");
        constKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        constKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        declaration.setConstKeyword(constKeyword);
        ArrayList<Integer> commas = new ArrayList<Integer>();
        ArrayList<ASTNode> consts = new ArrayList<ASTNode>(node.getChildCount());
        int i = 0;
        while (i < node.getChildCount()) {
            consts.add(this.transformNode(node.getChild(i), declaration));
            if (i > 0) {
                commas.add(new Integer(this.getTokenOffset(78, node.getChild(i - 1).getTokenStopIndex() + 1, node.getChild(i).getTokenStartIndex())));
            }
            ++i;
        }
        declaration.setConsts(consts);
        declaration.setCommas(commas);
        declaration.setSemicolonPosition(this.getTokenOffset(77, node.getTokenStopIndex(), node.getTokenStopIndex()));
        declaration.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        declaration.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = declaration;
        return true;
    }

    @Override
    protected boolean visitScript(Tree node) {
        Script script = new Script();
        int i = 0;
        while (i < node.getChildCount()) {
            script.addStatement(this.transformStatementNode(node.getChild(i), (ASTNode)script));
            ++i;
        }
        this.addComments(script);
        script.setStart(0);
        script.setEnd(this.source.length());
        this.result = script;
        return true;
    }

    private void addComments(Script script) {
        int i = 0;
        while (i < this.tokens.size()) {
            Token token = this.tokens.get(i);
            switch (token.getType()) {
                case 166: {
                    script.addComment(this.visitMultiLineComment(token));
                    break;
                }
                case 167: {
                    script.addComment(this.visitSingleLineComment(token));
                }
            }
            ++i;
        }
    }

    private Comment visitMultiLineComment(Token token) {
        MultiLineComment comment = new MultiLineComment();
        comment.setText(token.getText());
        comment.setStart(this.getTokenOffset(token.getTokenIndex()));
        comment.setEnd(comment.sourceStart() + token.getText().length());
        return comment;
    }

    private Comment visitSingleLineComment(Token token) {
        SingleLineComment comment = new SingleLineComment();
        comment.setText(token.getText());
        comment.setStart(this.getTokenOffset(token.getTokenIndex()));
        comment.setEnd(comment.sourceStart() + token.getText().length());
        return comment;
    }

    @Override
    protected boolean visitBooleanLiteral(Tree node) {
        BooleanLiteral bool = new BooleanLiteral(this.parent);
        bool.setText(node.getText());
        bool.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        bool.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        this.result = bool;
        return true;
    }

    @Override
    protected boolean visitVoid(Tree node) {
        VoidOperator expression = new VoidOperator(this.parent);
        Keyword voidKeyword = new Keyword(expression, "void");
        voidKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        voidKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        expression.setVoidKeyword(voidKeyword);
        expression.setExpression((Expression)this.transformNode(node.getChild(0), expression));
        expression.setStart(expression.getVoidKeyword().sourceStart());
        expression.setEnd(expression.getExpression().sourceEnd());
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitXmlLiteral(Tree node) {
        XmlLiteral xml = new XmlLiteral(this.parent);
        xml.setXml(node.getText());
        xml.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        xml.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        this.result = xml;
        return false;
    }

    @Override
    protected boolean visitNamespace(Tree node) {
        DefaultXmlNamespaceStatement statement = new DefaultXmlNamespaceStatement(this.parent);
        Keyword defaultKeyword = new Keyword(statement, "default");
        defaultKeyword.setStart(this.getTokenOffset(node.getChild(0).getTokenStartIndex()));
        defaultKeyword.setEnd(defaultKeyword.sourceStart() + "default".length());
        statement.setDefaultKeyword(defaultKeyword);
        Keyword xmlKeyword = new Keyword(statement, "xml");
        xmlKeyword.setStart(this.getTokenOffset(node.getChild(1).getTokenStartIndex()));
        xmlKeyword.setEnd(xmlKeyword.sourceStart() + "xml".length());
        statement.setXmlKeyword(xmlKeyword);
        Keyword namespaceKeyword = new Keyword(statement, "namespace");
        namespaceKeyword.setStart(this.getTokenOffset(38, node.getTokenStartIndex(), node.getTokenStopIndex()));
        namespaceKeyword.setEnd(namespaceKeyword.sourceStart() + "namespace".length());
        statement.setNamespaceKeyword(namespaceKeyword);
        statement.setAssignOperation(this.getTokenOffset(node.getChild(2).getTokenStartIndex()));
        StringLiteral value = new StringLiteral(statement);
        value.setStart(this.getTokenOffset(node.getChild(3).getTokenStartIndex()));
        value.setEnd(this.getTokenOffset(node.getChild(3).getTokenStartIndex()) + 1);
        value.setText(node.getChild(3).getText());
        statement.setValue(value);
        Token token = this.tokens.get(node.getTokenStopIndex());
        if (token.getType() == 77) {
            statement.setSemicolonPosition(this.getTokenOffset(node.getTokenStopIndex()));
            statement.setEnd(statement.getSemicolonPosition() + 1);
        } else {
            statement.setEnd(statement.getValue().sourceEnd());
        }
        statement.setStart(statement.getDefaultKeyword().sourceStart());
        this.result = statement;
        return true;
    }

    @Override
    protected boolean visitXmlAttribute(Tree node) {
        XmlAttributeIdentifier id = new XmlAttributeIdentifier(this.parent);
        id.setName(node.getText());
        id.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        id.setEnd(id.sourceStart() + id.getName().length());
        this.result = id;
        return true;
    }

    protected boolean visitAsterisk(Tree node) {
        AsteriskExpression asterisk = new AsteriskExpression(this.parent);
        asterisk.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        asterisk.setEnd(asterisk.sourceStart() + node.getText().length());
        this.result = asterisk;
        return true;
    }

    @Override
    protected boolean visitGetAllChildren(Tree node) {
        GetAllChildrenExpression expression = new GetAllChildrenExpression(this.parent);
        expression.setObject((Expression)this.transformNode(node.getChild(0), expression));
        expression.setProperty((Expression)this.transformNode(node.getChild(1), expression));
        expression.setDotDotPosition(this.getTokenOffset(126, JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((expression.getObject().sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((expression.getProperty().sourceEnd() > 0 ? 1 : 0) != 0);
        expression.setStart(expression.getObject().sourceStart());
        expression.setEnd(expression.getProperty().sourceEnd());
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitGetLocalName(Tree node) {
        GetLocalNameExpression expression = new GetLocalNameExpression(this.parent);
        expression.setNamespace((Expression)this.transformNode(node.getChild(0), expression));
        expression.setLocalName((Expression)this.transformNode(node.getChild(1), expression));
        expression.setColonColonPosition(this.getTokenOffset(127, JSTransformer.getRealTokenStopIndex(node.getChild(0)) + 1, node.getChild(1).getTokenStartIndex()));
        Assert.isTrue((expression.getNamespace().sourceStart() >= 0 ? 1 : 0) != 0);
        Assert.isTrue((expression.getLocalName().sourceEnd() > 0 ? 1 : 0) != 0);
        expression.setStart(expression.getNamespace().sourceStart());
        expression.setEnd(expression.getLocalName().sourceEnd());
        this.result = expression;
        return true;
    }

    @Override
    protected boolean visitHexIntegerLiteral(Tree node) {
        DecimalLiteral number = new DecimalLiteral(this.parent);
        number.setText(node.getText());
        number.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        number.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = number;
        return true;
    }

    @Override
    protected boolean visitOctalIntegerLiteral(Tree node) {
        DecimalLiteral number = new DecimalLiteral(this.parent);
        number.setText(node.getText());
        number.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        number.setEnd(this.getTokenOffset(node.getTokenStopIndex() + 1));
        this.result = number;
        return true;
    }

    @Override
    protected boolean visitYield(Tree node) {
        YieldOperator expression = new YieldOperator(this.parent);
        Keyword yieldKeyword = new Keyword(expression, "yield");
        yieldKeyword.setStart(this.getTokenOffset(node.getTokenStartIndex()));
        yieldKeyword.setEnd(this.getTokenOffset(node.getTokenStartIndex() + 1));
        expression.setVoidKeyword(yieldKeyword);
        expression.setExpression((Expression)this.transformNode(node.getChild(0), expression));
        expression.setStart(expression.getVoidKeyword().sourceStart());
        expression.setEnd(expression.getExpression().sourceEnd());
        this.result = expression;
        return true;
    }
}

