/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.ruby.debug;

import org.eclipse.dltk.debug.core.model.ArrayScriptType;
import org.eclipse.dltk.debug.core.model.AtomicScriptType;
import org.eclipse.dltk.debug.core.model.ComplexScriptType;
import org.eclipse.dltk.debug.core.model.HashScriptType;
import org.eclipse.dltk.debug.core.model.IScriptType;
import org.eclipse.dltk.debug.core.model.IScriptTypeFactory;
import org.eclipse.dltk.debug.core.model.StringScriptType;
import org.eclipse.dltk.ruby.debug.RubySetScriptType;

public class RubyTypeFactory
implements IScriptTypeFactory {
    private static final String[] atomicTypes = new String[]{"Bignum", "FalseClass", "Fixnum", "Float", "Integer", "NilClass", "Numeric", "Range", "Regexp", "Symbol", "TrueClass"};

    public IScriptType buildType(String type) {
        if ("string".equalsIgnoreCase(type)) {
            return new StringScriptType(type);
        }
        if ("array".equalsIgnoreCase(type)) {
            return new ArrayScriptType();
        }
        if ("hash".equals(type)) {
            return new HashScriptType();
        }
        int i = 0;
        while (i < atomicTypes.length) {
            if (atomicTypes[i].equals(type)) {
                return new AtomicScriptType(type);
            }
            ++i;
        }
        if ("set".equals(type)) {
            return new RubySetScriptType();
        }
        return new ComplexScriptType(type);
    }
}

