/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dltk.javascript.internal.ui.text;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.dltk.compiler.task.ITodoTaskPreferences;
import org.eclipse.dltk.ui.text.AbstractScriptScanner;
import org.eclipse.dltk.ui.text.IColorManager;
import org.eclipse.dltk.ui.text.rules.CombinedWordRule;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.ICharacterScanner;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;

class ScriptCommentScanner
extends AbstractScriptScanner {
    private static final char[] COMMENT_CHAR = "//".toCharArray();
    private final String[] fProperties;
    private final String fDefaultTokenProperty;
    private TaskTagMatcher fTaskTagMatcher;
    private final ITodoTaskPreferences preferences;
    private int state = 0;
    private static final int STATE_START = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_BODY = 2;

    public ScriptCommentScanner(IColorManager manager, IPreferenceStore store, String comment, String todoTag, ITodoTaskPreferences preferences) {
        super(manager, store);
        this.fProperties = new String[]{comment, todoTag};
        this.fDefaultTokenProperty = comment;
        this.preferences = preferences;
        this.initialize();
    }

    protected String[] getTokenProperties() {
        return this.fProperties;
    }

    protected List createRules() {
        Token defaultToken = this.getToken(this.fDefaultTokenProperty);
        this.setDefaultReturnToken((IToken)defaultToken);
        ArrayList<IRule> list = new ArrayList<IRule>();
        list.add(this.createTodoRule());
        return list;
    }

    protected IRule createTodoRule() {
        CombinedWordRule combinedWordRule = new CombinedWordRule((IWordDetector)new ScriptIdentifierDetector(), Token.UNDEFINED);
        List matchers = this.createMatchers();
        if (matchers.size() > 0) {
            int i = 0;
            int n = matchers.size();
            while (i < n) {
                combinedWordRule.addWordMatcher((CombinedWordRule.WordMatcher)matchers.get(i));
                ++i;
            }
        }
        return combinedWordRule;
    }

    protected List createMatchers() {
        ArrayList<TaskTagMatcher> list = new ArrayList<TaskTagMatcher>();
        boolean isCaseSensitive = this.preferences.isCaseSensitive();
        String[] tasks = this.preferences.getTagNames();
        if (tasks != null) {
            this.fTaskTagMatcher = new TaskTagMatcher((IToken)this.getToken("DLTK_comment_task_tag"));
            this.fTaskTagMatcher.addTaskTags(tasks);
            this.fTaskTagMatcher.setCaseSensitive(isCaseSensitive);
            list.add(this.fTaskTagMatcher);
        }
        return list;
    }

    protected char[] getCommentChar() {
        return COMMENT_CHAR;
    }

    public void setRange(IDocument document, int offset, int length) {
        super.setRange(document, offset, length);
        this.state = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adaptToPreferenceChange(PropertyChangeEvent event) {
        if (this.fTaskTagMatcher != null && event.getProperty().equals("org.eclipse.dltk.coretasks.tags")) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                TaskTagMatcher taskTagMatcher = this.fTaskTagMatcher;
                synchronized (taskTagMatcher) {
                    this.fTaskTagMatcher.clearWords();
                    this.fTaskTagMatcher.addTaskTags(this.preferences.getTagNames());
                }
            }
        } else if (this.fTaskTagMatcher != null && event.getProperty().equals("org.eclipse.dltk.coretasks.case_sensitive")) {
            Object value = event.getNewValue();
            if (value instanceof String) {
                boolean caseSensitive = Boolean.valueOf((String)value);
                this.fTaskTagMatcher.setCaseSensitive(caseSensitive);
            }
        } else {
            super.adaptToPreferenceChange(event);
        }
    }

    public boolean affectsBehavior(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.dltk.coretasks.tags")) {
            return true;
        }
        if (event.getProperty().equals("org.eclipse.dltk.coretasks.case_sensitive")) {
            return true;
        }
        return super.affectsBehavior(event);
    }

    public IToken nextToken() {
        char[] commentChar = this.getCommentChar();
        this.fTokenOffset = this.fOffset;
        this.fColumn = -1;
        if (this.state == 0) {
            this.state = 1;
            int count = 0;
            int c = this.read();
            while (count < commentChar.length) {
                if (c != commentChar[count]) break;
                c = this.read();
                ++count;
            }
            while (c != -1 && Character.isWhitespace((char)c)) {
                c = this.read();
                ++count;
            }
            this.unread();
            if (count > 0) {
                return this.fDefaultReturnToken;
            }
            if (c == -1) {
                return Token.EOF;
            }
        }
        if (this.state == 1) {
            this.state = 2;
            IToken token = this.fRules[0].evaluate((ICharacterScanner)this);
            if (!token.isUndefined()) {
                return token;
            }
        }
        return this.read() != -1 ? this.fDefaultReturnToken : Token.EOF;
    }

    private static class ScriptIdentifierDetector
    implements IWordDetector {
        private ScriptIdentifierDetector() {
        }

        public boolean isWordStart(char c) {
            return Character.isJavaIdentifierStart(c);
        }

        public boolean isWordPart(char c) {
            return Character.isJavaIdentifierPart(c);
        }
    }

    private class TaskTagMatcher
    extends CombinedWordRule.WordMatcher {
        private IToken fToken;
        private Map fUppercaseWords = new HashMap();
        private boolean fCaseSensitive = true;
        private CombinedWordRule.CharacterBuffer fBuffer = new CombinedWordRule.CharacterBuffer(16);

        public TaskTagMatcher(IToken token) {
            this.fToken = token;
        }

        public synchronized void clearWords() {
            super.clearWords();
            this.fUppercaseWords.clear();
        }

        public synchronized void addTaskTags(String[] tasks) {
            int i = 0;
            while (i < tasks.length) {
                if (tasks[i].length() > 0) {
                    this.addWord(tasks[i], this.fToken);
                }
                ++i;
            }
        }

        public synchronized void addTaskTags(String value) {
            String[] tasks = this.split(value, ",");
            this.addTaskTags(tasks);
        }

        private String[] split(String value, String delimiters) {
            StringTokenizer tokenizer = new StringTokenizer(value, delimiters);
            int size = tokenizer.countTokens();
            String[] tokens = new String[size];
            int i = 0;
            while (i < size) {
                tokens[i++] = tokenizer.nextToken();
            }
            return tokens;
        }

        public synchronized void addWord(String word, IToken token) {
            Assert.isNotNull((Object)word);
            Assert.isNotNull((Object)token);
            super.addWord(word, token);
            this.fUppercaseWords.put(new CombinedWordRule.CharacterBuffer(word.toUpperCase()), token);
        }

        public synchronized IToken evaluate(ICharacterScanner scanner, CombinedWordRule.CharacterBuffer word) {
            if (this.fCaseSensitive) {
                return super.evaluate(scanner, word);
            }
            this.fBuffer.clear();
            int i = 0;
            int n = word.length();
            while (i < n) {
                this.fBuffer.append(Character.toUpperCase(word.charAt(i)));
                ++i;
            }
            IToken token = (IToken)this.fUppercaseWords.get(this.fBuffer);
            if (token != null) {
                return token;
            }
            return Token.UNDEFINED;
        }

        public boolean isCaseSensitive() {
            return this.fCaseSensitive;
        }

        public void setCaseSensitive(boolean caseSensitive) {
            this.fCaseSensitive = caseSensitive;
        }
    }
}

